/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.indent;

import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.indent.TokenItem;

public class IndentSupport {
    protected CodeStyle codeStyle;
    protected TokenSequence<CppTokenId> ts;

    protected TokenItem findToken(TokenItem tokenItem, TokenItem tokenItem2, CppTokenId cppTokenId, boolean bl) {
        if (bl) {
            if (tokenItem != null && tokenItem.equals(tokenItem2)) {
                return null;
            }
            tokenItem = this.getPreviousToken(tokenItem);
            if (tokenItem2 != null) {
                tokenItem2 = tokenItem2.getPrevious();
            }
        }
        while (tokenItem != null && tokenItem.equals(tokenItem2)) {
            if (tokenItem.getTokenID() == cppTokenId) {
                return tokenItem;
            }
            tokenItem = bl ? tokenItem.getPrevious() : tokenItem.getNext();
        }
        return null;
    }

    protected TokenItem findMatchingToken(TokenItem tokenItem, TokenItem tokenItem2, CppTokenId cppTokenId, boolean bl) {
        TokenItem tokenItem3;
        int n = 0;
        CppTokenId cppTokenId2 = tokenItem.getTokenID();
        TokenItem tokenItem4 = tokenItem3 = bl ? tokenItem.getPrevious() : tokenItem.getNext();
        while (tokenItem3 != null && !tokenItem3.equals(tokenItem2)) {
            if (tokenItem3.getTokenID() == cppTokenId) {
                if (n-- == 0) {
                    return tokenItem3;
                }
            } else if (tokenItem3.getTokenID() == cppTokenId2) {
                ++n;
            }
            tokenItem3 = bl ? tokenItem3.getPrevious() : tokenItem3.getNext();
        }
        return null;
    }

    protected TokenItem findImportantToken(TokenItem tokenItem, TokenItem tokenItem2, boolean bl) {
        if (bl) {
            if (tokenItem != null && tokenItem.equals(tokenItem2)) {
                return null;
            }
            tokenItem = this.getPreviousToken(tokenItem);
            if (tokenItem2 != null) {
                tokenItem2 = tokenItem2.getPrevious();
            }
        }
        while (tokenItem != null && !tokenItem.equals(tokenItem2)) {
            if (this.isImportant(tokenItem)) {
                return tokenItem;
            }
            tokenItem = bl ? tokenItem.getPrevious() : tokenItem.getNext();
        }
        return null;
    }

    private boolean isComment(TokenItem tokenItem) {
        CppTokenId cppTokenId = tokenItem.getTokenID();
        return cppTokenId == CppTokenId.LINE_COMMENT || cppTokenId == CppTokenId.BLOCK_COMMENT;
    }

    private boolean isImportant(TokenItem tokenItem) {
        return !this.isComment(tokenItem) && !this.isWhitespace(tokenItem);
    }

    private boolean isWhitespace(TokenItem tokenItem) {
        return "whitespace".equals(tokenItem.getTokenID().primaryCategory());
    }

    protected TokenItem findAnyToken(TokenItem tokenItem, TokenItem tokenItem2, CppTokenId[] cppTokenIdArray, boolean bl) {
        if (bl) {
            if (tokenItem != null && tokenItem.equals(tokenItem2)) {
                return null;
            }
            tokenItem = this.getPreviousToken(tokenItem);
            if (tokenItem2 != null) {
                tokenItem2 = tokenItem2.getPrevious();
            }
        }
        while (tokenItem != null && !tokenItem.equals(tokenItem2)) {
            for (int i = 0; i < cppTokenIdArray.length; ++i) {
                if (tokenItem.getTokenID() != cppTokenIdArray[i]) continue;
                return tokenItem;
            }
            tokenItem = bl ? tokenItem.getPrevious() : tokenItem.getNext();
        }
        return null;
    }

    protected TokenItem findStatementStart(TokenItem tokenItem) {
        return this.findStatementStart(tokenItem, false);
    }

    protected TokenItem findStatementStart(TokenItem tokenItem, boolean bl) {
        TokenItem tokenItem2 = this.findStatement(tokenItem);
        if (tokenItem2 != null) {
            switch (tokenItem2.getTokenID()) {
                case SEMICOLON: {
                    TokenItem tokenItem3 = this.findStatement(tokenItem2);
                    if (tokenItem3 == null) {
                        return tokenItem;
                    }
                    switch (tokenItem3.getTokenID()) {
                        case SEMICOLON: 
                        case LBRACE: 
                        case RBRACE: 
                        case COLON: 
                        case CASE: 
                        case DEFAULT: {
                            return tokenItem2;
                        }
                        case DO: 
                        case FOR: 
                        case IF: 
                        case WHILE: 
                        case PRIVATE: 
                        case PROTECTED: 
                        case PUBLIC: {
                            return this.findStatementStart(tokenItem2, bl);
                        }
                        case ELSE: {
                            TokenItem tokenItem4 = this.findIf(tokenItem3);
                            if (tokenItem4 != null) {
                                return this.findStatementStart(tokenItem4, bl);
                            }
                            return tokenItem3;
                        }
                    }
                    TokenItem tokenItem5 = this.findStatement(tokenItem3);
                    if (tokenItem5 != null) {
                        switch (tokenItem5.getTokenID()) {
                            case SEMICOLON: 
                            case LBRACE: 
                            case RBRACE: 
                            case COLON: {
                                return tokenItem3;
                            }
                            case DO: 
                            case FOR: 
                            case IF: 
                            case WHILE: {
                                return this.findStatementStart(tokenItem5, bl);
                            }
                            case ELSE: {
                                TokenItem tokenItem6 = this.findIf(tokenItem5);
                                if (tokenItem6 != null) {
                                    return this.findStatementStart(tokenItem6, bl);
                                }
                                return tokenItem5;
                            }
                        }
                    }
                    return tokenItem3;
                }
                case LBRACE: {
                    return tokenItem;
                }
                case RBRACE: {
                    TokenItem tokenItem7;
                    TokenItem tokenItem8 = this.findMatchingToken(tokenItem2, null, CppTokenId.LBRACE, true);
                    if (tokenItem8 != null && (tokenItem7 = this.findStatement(tokenItem8)) != null) {
                        switch (tokenItem7.getTokenID()) {
                            case ELSE: {
                                TokenItem tokenItem9 = this.findIf(tokenItem7);
                                if (tokenItem9 != null) {
                                    return this.findStatementStart(tokenItem9, bl);
                                }
                                return tokenItem7;
                            }
                            case CATCH: {
                                TokenItem tokenItem10 = this.findTry(tokenItem7);
                                if (tokenItem10 != null) {
                                    return this.findStatementStart(tokenItem10, bl);
                                }
                                return tokenItem7;
                            }
                            case DO: 
                            case FOR: 
                            case IF: 
                            case WHILE: {
                                return this.findStatementStart(tokenItem7, bl);
                            }
                        }
                        if (tokenItem7.getTokenID() == CppTokenId.LBRACE) {
                            return tokenItem2;
                        }
                        return tokenItem7;
                    }
                    return tokenItem2;
                }
                case COLON: 
                case CASE: 
                case DEFAULT: {
                    return tokenItem;
                }
                case ELSE: {
                    TokenItem tokenItem11 = this.findIf(tokenItem2);
                    if (tokenItem11 != null) {
                        if (!bl) {
                            return tokenItem11;
                        }
                        return this.findStatementStart(tokenItem11, bl);
                    }
                    return tokenItem2;
                }
                case DO: 
                case FOR: 
                case IF: 
                case WHILE: {
                    if (!bl) {
                        return tokenItem2;
                    }
                    return this.findStatementStart(tokenItem2, bl);
                }
                case IDENTIFIER: {
                    return tokenItem2;
                }
            }
            return tokenItem2;
        }
        return tokenItem;
    }

    protected TokenItem findStatement(TokenItem tokenItem) {
        TokenItem tokenItem2 = null;
        boolean bl = true;
        for (TokenItem tokenItem3 = this.getPreviousToken(tokenItem); tokenItem3 != null; tokenItem3 = tokenItem3.getPrevious()) {
            switch (tokenItem3.getTokenID()) {
                case SEMICOLON: {
                    if (this.isForLoopSemicolon(tokenItem3)) break;
                    return tokenItem2 != null ? tokenItem2 : tokenItem3;
                }
                case LBRACE: 
                case ELSE: {
                    return tokenItem2 != null ? tokenItem2 : tokenItem3;
                }
                case RBRACE: {
                    if (!this.isArrayInitializationBraceBlock(tokenItem3, null)) {
                        return tokenItem2 != null ? tokenItem2 : tokenItem3;
                    }
                    tokenItem3 = this.findMatchingToken(tokenItem3, null, CppTokenId.LBRACE, true);
                    break;
                }
                case COLON: {
                    TokenItem tokenItem4;
                    TokenItem tokenItem5 = this.findAnyToken(tokenItem3, null, new CppTokenId[]{CppTokenId.CASE, CppTokenId.DEFAULT, CppTokenId.PUBLIC, CppTokenId.PRIVATE, CppTokenId.PROTECTED, CppTokenId.LBRACE, CppTokenId.RBRACE, CppTokenId.SEMICOLON, CppTokenId.QUESTION}, true);
                    if (tokenItem5 != null) {
                        switch (tokenItem5.getTokenID()) {
                            case CASE: 
                            case DEFAULT: 
                            case PRIVATE: 
                            case PROTECTED: 
                            case PUBLIC: {
                                return tokenItem2 != null ? tokenItem2 : tokenItem3;
                            }
                        }
                    }
                    if ((tokenItem4 = this.findImportantToken(tokenItem3, null, true)) != null && tokenItem4.getTokenID() == CppTokenId.RPAREN) {
                        tokenItem3 = tokenItem4;
                        break;
                    }
                    if (tokenItem2 != null && bl && tokenItem5 == null) {
                        return tokenItem2;
                    }
                    bl = false;
                    break;
                }
                case DO: 
                case CASE: 
                case DEFAULT: 
                case SWITCH: {
                    return tokenItem3;
                }
                case FOR: 
                case IF: 
                case WHILE: {
                    TokenItem tokenItem6;
                    if (tokenItem2 != null && tokenItem2.getTokenID() == CppTokenId.LPAREN && (tokenItem6 = this.findMatchingToken(tokenItem2, tokenItem, CppTokenId.RPAREN, false)) != null && (tokenItem6 = tokenItem6.getNext()) != null && (tokenItem6 = this.findImportantToken(tokenItem6, tokenItem, false)) != null) {
                        return tokenItem6;
                    }
                    return tokenItem3;
                }
            }
            if (!this.isImportant(tokenItem3)) continue;
            tokenItem2 = tokenItem3;
        }
        return tokenItem2;
    }

    protected TokenItem findIf(TokenItem tokenItem) {
        assert (tokenItem != null && tokenItem.getTokenID() == CppTokenId.ELSE);
        int n = 0;
        int n2 = 0;
        block7: while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID()) {
                case LBRACE: {
                    if (--n >= 0) break;
                    return null;
                }
                case RBRACE: {
                    ++n;
                    break;
                }
                case ELSE: {
                    if (n != 0) break;
                    ++n2;
                    break;
                }
                case SEMICOLON: 
                case COLON: 
                case DO: 
                case FOR: 
                case WHILE: 
                case CASE: 
                case DEFAULT: {
                    break;
                }
                case IF: {
                    if (n != 0 || n2-- != 0) continue block7;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    protected TokenItem findSwitch(TokenItem tokenItem) {
        assert (tokenItem != null && (tokenItem.getTokenID() == CppTokenId.CASE || tokenItem.getTokenID() == CppTokenId.DEFAULT));
        int n = 1;
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID()) {
                case LBRACE: {
                    if (--n >= 0) break;
                    return null;
                }
                case RBRACE: {
                    ++n;
                    break;
                }
                case DEFAULT: 
                case SWITCH: {
                    if (n != 0) break;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    protected TokenItem findClassifier(TokenItem tokenItem) {
        int n = 1;
        TokenItem tokenItem2 = tokenItem;
        while ((tokenItem2 = this.findStatement(tokenItem2)) != null) {
            switch (tokenItem2.getTokenID()) {
                case LBRACE: {
                    if (--n < 0) {
                        return null;
                    }
                    if (n != 0) break;
                    while ((tokenItem2 = tokenItem2.getPrevious()) != null) {
                        switch (tokenItem2.getTokenID()) {
                            case CLASS: 
                            case STRUCT: 
                            case ENUM: 
                            case UNION: {
                                return tokenItem2;
                            }
                        }
                    }
                    return null;
                }
                case RBRACE: {
                    ++n;
                }
            }
        }
        return null;
    }

    protected TokenItem findTry(TokenItem tokenItem) {
        assert (tokenItem != null && tokenItem.getTokenID() == CppTokenId.CATCH);
        int n = 0;
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID()) {
                case LBRACE: {
                    if (--n >= 0) break;
                    return null;
                }
                case RBRACE: {
                    ++n;
                    break;
                }
                case TRY: {
                    if (n != 0) break;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    protected boolean isFieldComma(TokenItem tokenItem) {
        TokenItem tokenItem2;
        while (tokenItem != null && tokenItem.getTokenID() == CppTokenId.COMMA && (tokenItem2 = this.findStatementStart(tokenItem)) != tokenItem) {
            tokenItem = tokenItem2;
        }
        if (tokenItem != null) {
            tokenItem2 = this.findImportantToken(tokenItem, null, true);
            if (tokenItem2 != null && tokenItem2.getTokenID() == CppTokenId.LBRACE) {
                TokenItem tokenItem3 = this.findStatementStart(tokenItem2);
                if (tokenItem3 != null && (tokenItem3.getTokenID() == CppTokenId.CLASS || tokenItem3.getTokenID() == CppTokenId.STRUCT || tokenItem3.getTokenID() == CppTokenId.UNION)) {
                    return true;
                }
            } else {
                if (tokenItem2 != null && tokenItem2.getTokenID() == CppTokenId.SEMICOLON) {
                    return this.findClassifier(tokenItem2) != null;
                }
                if (tokenItem2 != null && tokenItem2.getTokenID() == CppTokenId.RBRACE) {
                    return this.findClassifier(tokenItem2) != null;
                }
            }
        }
        return false;
    }

    protected boolean isEnumComma(TokenItem tokenItem) {
        TokenItem tokenItem2;
        TokenItem tokenItem3;
        while (tokenItem != null && tokenItem.getTokenID() == CppTokenId.COMMA && (tokenItem3 = this.findStatementStart(tokenItem)) != tokenItem) {
            tokenItem = tokenItem3;
        }
        return !(tokenItem == null || tokenItem.getTokenID() != CppTokenId.IDENTIFIER && tokenItem.getTokenID() != CppTokenId.DOT || (tokenItem3 = this.findImportantToken(tokenItem, null, true)) == null || tokenItem3.getTokenID() != CppTokenId.LBRACE || (tokenItem2 = this.findStatementStart(tokenItem3)) == null || tokenItem2.getTokenID() != CppTokenId.ENUM && this.findToken(tokenItem2, tokenItem3, CppTokenId.ENUM, false) == null && this.findToken(tokenItem2, tokenItem3, CppTokenId.EQ, false) == null);
    }

    protected boolean isForLoopSemicolon(TokenItem tokenItem) {
        assert (tokenItem != null && tokenItem.getTokenID() == CppTokenId.SEMICOLON);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        block7: for (tokenItem = tokenItem.getPrevious(); tokenItem != null; tokenItem = tokenItem.getPrevious()) {
            switch (tokenItem.getTokenID()) {
                case LPAREN: {
                    if (n == 0) {
                        TokenItem tokenItem2 = this.findImportantToken(tokenItem, null, false);
                        return tokenItem2 != null && tokenItem2.getTokenID() == CppTokenId.FOR;
                    }
                    --n;
                    continue block7;
                }
                case RPAREN: {
                    ++n;
                    continue block7;
                }
                case LBRACE: {
                    if (n2 == 0) {
                        return false;
                    }
                    --n2;
                    continue block7;
                }
                case RBRACE: {
                    ++n2;
                    continue block7;
                }
                case SEMICOLON: {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                }
            }
        }
        return false;
    }

    protected boolean isStatement(TokenItem tokenItem) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (tokenItem != null) {
            switch (tokenItem.getTokenID()) {
                case DO: 
                case FOR: 
                case IF: 
                case WHILE: 
                case ELSE: 
                case CASE: 
                case DEFAULT: 
                case CATCH: 
                case SWITCH: 
                case TRY: 
                case EQ: 
                case AMPEQ: 
                case BAREQ: 
                case STAREQ: 
                case SLASHEQ: 
                case CARETEQ: 
                case PERCENTEQ: 
                case DELETE: 
                case RETURN: 
                case BREAK: 
                case CONTINUE: 
                case GOTO: 
                case SIZEOF: 
                case THIS: 
                case THROW: 
                case USING: {
                    return true;
                }
                case SEMICOLON: {
                    return !bl;
                }
                case LBRACE: 
                case PRIVATE: 
                case PROTECTED: 
                case PUBLIC: 
                case CLASS: 
                case ENUM: 
                case UNION: 
                case FRIEND: 
                case EXPLICIT: 
                case EXTERN: 
                case STATIC: 
                case OPERATOR: 
                case NAMESPACE: 
                case TEMPLATE: 
                case VIRTUAL: 
                case INLINE: {
                    return false;
                }
                case COLON: {
                    if (bl3) break;
                    return false;
                }
                case QUESTION: {
                    bl3 = true;
                    break;
                }
                case SCOPE: {
                    if (bl2 || n != 1) break;
                    bl = true;
                    break;
                }
                case RPAREN: {
                    break;
                }
                case LPAREN: {
                    if (!bl2 && n > 1) {
                        bl = true;
                    }
                    bl2 = true;
                    break;
                }
                case STRUCT: 
                case ASM: 
                case AUTO: 
                case BOOL: 
                case CHAR: 
                case DOUBLE: 
                case EXPORT: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case MUTABLE: 
                case REGISTER: 
                case SHORT: 
                case SIGNED: 
                case TYPEDEF: 
                case TYPENAME: 
                case UNSIGNED: 
                case VOID: 
                case WCHAR_T: 
                case VOLATILE: 
                case CONST: {
                    if (bl2) break;
                    return false;
                }
                case IDENTIFIER: {
                    ++n;
                }
            }
            tokenItem = tokenItem.getNext();
        }
        return true;
    }

    protected TokenItem findClassifierStart(TokenItem tokenItem) {
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID()) {
                case SEMICOLON: 
                case LBRACE: 
                case RBRACE: {
                    return null;
                }
                case TEMPLATE: {
                    return this.findStatementStart(tokenItem);
                }
            }
        }
        return null;
    }

    protected TokenItem getVisibility(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem;
        if (tokenItem2 != null) {
            tokenItem2 = tokenItem.getPrevious();
        }
        while (tokenItem2 != null) {
            switch (tokenItem2.getTokenID()) {
                case SEMICOLON: 
                case LBRACE: 
                case RBRACE: {
                    return null;
                }
                case PRIVATE: 
                case PROTECTED: 
                case PUBLIC: {
                    return tokenItem2;
                }
            }
            tokenItem2 = tokenItem2.getPrevious();
        }
        return null;
    }

    protected TokenItem getLeftParen(TokenItem tokenItem, TokenItem tokenItem2) {
        int n = 0;
        block4: for (tokenItem = tokenItem.getPrevious(); tokenItem != null && !tokenItem.equals(tokenItem2); tokenItem = tokenItem.getPrevious()) {
            switch (tokenItem.getTokenID()) {
                case LPAREN: {
                    if (--n >= 0) continue block4;
                    return tokenItem;
                }
                case RPAREN: {
                    ++n;
                }
            }
        }
        return null;
    }

    protected boolean isArrayInitializationBraceBlock(TokenItem tokenItem, TokenItem tokenItem2) {
        int n = 0;
        block5: for (tokenItem = tokenItem.getPrevious(); tokenItem != null && !tokenItem.equals(tokenItem2); tokenItem = tokenItem.getPrevious()) {
            switch (tokenItem.getTokenID()) {
                case RBRACE: {
                    ++n;
                    continue block5;
                }
                case LBRACE: {
                    if (--n >= 0) continue block5;
                    TokenItem tokenItem3 = this.findImportantToken(tokenItem, tokenItem2, true);
                    return tokenItem3 != null && (CppTokenId.RBRACKET.equals((Object)tokenItem3.getTokenID()) || CppTokenId.EQ.equals((Object)tokenItem3.getTokenID()));
                }
                case SEMICOLON: 
                case DO: 
                case FOR: 
                case IF: 
                case WHILE: {
                    if (n != 0) continue block5;
                    return false;
                }
            }
        }
        return false;
    }

    protected CodeStyle getCodeStyle() {
        return this.codeStyle;
    }

    protected boolean expandTabs() {
        return this.codeStyle.expandTabToSpaces();
    }

    protected int getTabSize() {
        return this.codeStyle.getTabSize();
    }

    protected int getRightIndent() {
        int n = this.getShiftWidth();
        if (this.isHalfIndentNewlineBeforeBrace()) {
            return n / 2;
        }
        return n;
    }

    protected int getRightIndentSwitch() {
        int n = this.getShiftWidth();
        if (this.isHalfIndentNewlineBeforeBrace()) {
            return n / 2;
        }
        return n;
    }

    protected int getRightIndentDeclaration() {
        int n = this.getShiftWidth();
        if (this.isHalfIndentNewlineBeforeBraceDeclaration()) {
            return n / 2;
        }
        return n;
    }

    protected boolean indentCasesFromSwitch() {
        return this.getCodeStyle().indentCasesFromSwitch();
    }

    protected boolean isHalfIndentNewlineBeforeBrace() {
        return this.getCodeStyle().getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED;
    }

    protected boolean isHalfIndentNewlineBeforeBraceSwitch() {
        return this.getCodeStyle().getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED;
    }

    protected boolean isHalfIndentNewlineBeforeBraceDeclaration() {
        return this.getCodeStyle().getFormatNewlineBeforeBraceDeclaration() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED;
    }

    protected boolean getFormatLeadingStarInComment() {
        return this.getCodeStyle().getFormatLeadingStarInComment();
    }

    protected int getFormatStatementContinuationIndent() {
        return this.getCodeStyle().getFormatStatementContinuationIndent();
    }

    protected int getShiftWidth() {
        return this.getCodeStyle().indentSize();
    }

    protected boolean alignMultilineCallArgs() {
        return this.getCodeStyle().alignMultilineCallArgs();
    }

    protected boolean alignMultilineIf() {
        return this.getCodeStyle().alignMultilineIfCondition();
    }

    protected boolean alignMultilineWhile() {
        return this.getCodeStyle().alignMultilineWhileCondition();
    }

    protected boolean alignMultilineFor() {
        return this.getCodeStyle().alignMultilineFor();
    }

    protected boolean alignMultilineMethodParams() {
        return this.getCodeStyle().alignMultilineMethodParams();
    }

    protected TokenItem getPreviousToken(TokenItem tokenItem) {
        if (tokenItem == null) {
            this.ts.moveEnd();
            while (this.ts.movePrevious()) {
                if (this.ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) continue;
                return new TokenItem(this.ts, true);
            }
            return null;
        }
        return tokenItem.getPrevious();
    }

    protected int go(TokenItem tokenItem) {
        TokenSequence<CppTokenId> tokenSequence = tokenItem.getTokenSequence();
        int n = tokenSequence.index();
        tokenSequence.moveIndex(tokenItem.index());
        tokenSequence.moveNext();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTokenColumnAfterBrace(TokenItem tokenItem) {
        int n = this.getTokenColumn(tokenItem);
        TokenSequence<CppTokenId> tokenSequence = tokenItem.getTokenSequence();
        int n2 = this.go(tokenItem);
        try {
            block12: while (tokenSequence.moveNext()) {
                switch ((CppTokenId)tokenSequence.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n3 = n;
                        return n3;
                    }
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: {
                        String string = ((Object)tokenSequence.token().text()).toString();
                        int n4 = string.lastIndexOf(10);
                        if (n4 < 0) {
                            n += string.length();
                        }
                        int n5 = n += string.length() - n4 + 1;
                        return n5;
                    }
                    case WHITESPACE: {
                        int n5;
                        int n4;
                        String string = ((Object)tokenSequence.token().text()).toString();
                        for (n4 = 0; n4 < string.length(); ++n4) {
                            n5 = string.charAt(n4);
                            if (n5 == 9) {
                                n = (n / this.getTabSize() + 1) * this.getTabSize();
                                continue;
                            }
                            ++n;
                        }
                        continue block12;
                    }
                    case LBRACE: {
                        n += tokenSequence.token().length();
                        continue block12;
                    }
                }
                int n6 = n;
                return n6;
            }
            int n7 = n;
            return n7;
        }
        finally {
            tokenSequence.moveIndex(n2);
            tokenSequence.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTokenIndent(TokenItem tokenItem) {
        TokenSequence<CppTokenId> tokenSequence = tokenItem.getTokenSequence();
        int n = this.go(tokenItem);
        try {
            int n2 = 0;
            block10: while (tokenSequence.movePrevious()) {
                switch ((CppTokenId)tokenSequence.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n3 = n2;
                        return n3;
                    }
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: {
                        String string = ((Object)tokenSequence.token().text()).toString();
                        int n4 = string.lastIndexOf(10);
                        if (n4 < 0) {
                            n2 += string.length();
                            continue block10;
                        }
                        int n5 = n2 += string.length() - n4 + 1;
                        return n5;
                    }
                    case WHITESPACE: {
                        int n5;
                        int n4;
                        String string = ((Object)tokenSequence.token().text()).toString();
                        for (n4 = 0; n4 < string.length(); ++n4) {
                            n5 = string.charAt(n4);
                            if (n5 == 9) {
                                n2 = (n2 / this.getTabSize() + 1) * this.getTabSize();
                                continue;
                            }
                            ++n2;
                        }
                        continue block10;
                    }
                }
                n2 = 0;
            }
            int n6 = n2;
            return n6;
        }
        finally {
            tokenSequence.moveIndex(n);
            tokenSequence.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTokenColumn(TokenItem tokenItem) {
        TokenSequence<CppTokenId> tokenSequence = tokenItem.getTokenSequence();
        int n = this.go(tokenItem);
        try {
            int n2 = 0;
            block10: while (tokenSequence.movePrevious()) {
                switch ((CppTokenId)tokenSequence.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n3 = n2;
                        return n3;
                    }
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: {
                        String string = ((Object)tokenSequence.token().text()).toString();
                        int n4 = string.lastIndexOf(10);
                        if (n4 < 0) {
                            n2 += string.length();
                            continue block10;
                        }
                        int n5 = n2 += string.length() - n4 + 1;
                        return n5;
                    }
                    case WHITESPACE: {
                        int n5;
                        int n4;
                        String string = ((Object)tokenSequence.token().text()).toString();
                        for (n4 = 0; n4 < string.length(); ++n4) {
                            n5 = string.charAt(n4);
                            if (n5 == 9) {
                                n2 = (n2 / this.getTabSize() + 1) * this.getTabSize();
                                continue;
                            }
                            ++n2;
                        }
                        continue block10;
                    }
                }
                n2 += tokenSequence.token().length();
            }
            int n6 = n2;
            return n6;
        }
        finally {
            tokenSequence.moveIndex(n);
            tokenSequence.moveNext();
        }
    }
}

