/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DOMBinding;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Schema2BeansUtil {
    public static void write(BaseBean baseBean, Writer writer) throws IOException {
        GraphManager graphManager = baseBean.graphManager();
        if (graphManager == null) {
            throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
        }
        graphManager.write(writer);
    }

    public static void write(BaseBean baseBean, OutputStream outputStream) throws IOException {
        try {
            GraphManager graphManager = baseBean.graphManager();
            if (graphManager == null) {
                throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
            }
            graphManager.write(outputStream);
        }
        catch (Schema2BeansException schema2BeansException) {
            throw new Schema2BeansRuntimeException(schema2BeansException);
        }
    }

    public static void mergeUnsupportedElements(BaseBean baseBean, BaseBean baseBean2) {
        HashMap<Node, BaseBean> hashMap = new HashMap<Node, BaseBean>();
        LinkedList<BaseBean> linkedList = new LinkedList<BaseBean>();
        linkedList.add(baseBean);
        baseBean.childBeans(true, linkedList);
        linkedList.add(baseBean2);
        baseBean2.childBeans(true, linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            BaseBean baseBean3 = (BaseBean)iterator.next();
            DOMBinding dOMBinding = baseBean3.binding;
            if (dOMBinding == null) continue;
            hashMap.put(dOMBinding.getNode(), baseBean3);
        }
        Schema2BeansUtil.mergeNode(hashMap, Schema2BeansUtil.getOwnerDocument(baseBean.binding.getNode()), Schema2BeansUtil.getOwnerDocument(baseBean2.binding.getNode()));
    }

    private static void mergeBeans(Map map, BaseBean baseBean, BaseBean baseBean2) {
        if (baseBean.binding != null && baseBean2.binding != null) {
            Node node = baseBean.binding.getNode();
            Node node2 = baseBean2.binding.getNode();
            if (node != null && node2 != null) {
                Schema2BeansUtil.mergeNode(map, node, node2);
            }
        }
    }

    private static Document getOwnerDocument(Node node) {
        return node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    private static void mergeNode(Map map, Node node, Node node2) {
        Schema2BeansUtil.mergeAttributes(node, node2);
        NodeList nodeList = node.getChildNodes();
        List list = Schema2BeansUtil.relevantNodes(nodeList);
        Document document = Schema2BeansUtil.getOwnerDocument(node);
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node node3 = nodeList.item(i);
            if (Schema2BeansUtil.isRelevantNode(node3)) continue;
            node.removeChild(node3);
        }
        NodeList nodeList2 = node2.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Object object;
            Node node4 = nodeList2.item(i);
            Node node5 = nodeList.item(i);
            if (Schema2BeansUtil.isRelevantNode(node4)) {
                Node node6;
                BaseBean baseBean;
                object = (BaseBean)map.get(node4);
                if (object != null) {
                    baseBean = Schema2BeansUtil.takeEqualBean(map, list, (BaseBean)object);
                    node6 = baseBean == null ? null : baseBean.binding.getNode();
                } else {
                    baseBean = null;
                    node6 = null;
                }
                if (node6 == null) {
                    node6 = Schema2BeansUtil.takeEqualNode(list, node4);
                }
                if (node6 != null) {
                    if (node6 != node5) {
                        node.removeChild(node6);
                        node.insertBefore(node6, node5);
                    }
                    if (baseBean != null) {
                        Schema2BeansUtil.mergeBeans(map, baseBean, (BaseBean)object);
                        continue;
                    }
                    if (Schema2BeansUtil.isRelevantNode(node6)) {
                        Schema2BeansUtil.mergeNode(map, node6, node4);
                        continue;
                    }
                    node6.setNodeValue(node4.getNodeValue());
                    continue;
                }
                Node node7 = document.importNode(node4, true);
                node.insertBefore(node7, node5);
                continue;
            }
            object = document.importNode(node4, true);
            node.insertBefore((Node)object, node5);
        }
    }

    private static void mergeAttributes(Node node, Node node2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        NamedNodeMap namedNodeMap2 = node2.getAttributes();
        if (namedNodeMap == null) {
            if (namedNodeMap2 == null) {
                return;
            }
            TraceLogger.error("Attributes merge error: " + node.getClass().getName() + "  " + node2.getClass().getName());
            return;
        }
        if (namedNodeMap2 == null) {
            TraceLogger.error("Attributes merge error: " + node.getClass().getName() + "  " + node2.getClass().getName());
            return;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            linkedList.add(namedNodeMap.item(i).getNodeName());
        }
        Object object = linkedList.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (namedNodeMap2.getNamedItem(string) != null) continue;
            namedNodeMap.removeNamedItem(string);
        }
        object = Schema2BeansUtil.getOwnerDocument(node);
        for (int i = 0; i < namedNodeMap2.getLength(); ++i) {
            Node node3 = namedNodeMap2.item(i);
            String string = node3.getNodeName();
            String string2 = node3.getNodeValue();
            Node node4 = namedNodeMap.getNamedItem(string);
            if (node4 == null) {
                node4 = object.createAttribute(string);
                namedNodeMap.setNamedItem(node4);
            }
            node4.setNodeValue(string2);
        }
    }

    private static BaseBean takeEqualBean(Map map, List list, BaseBean baseBean) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            BaseBean baseBean2 = (BaseBean)map.get(node);
            if (baseBean2 == null || !baseBean2.isEqualTo(baseBean)) continue;
            iterator.remove();
            return baseBean2;
        }
        return null;
    }

    private static Node takeEqualNode(List list, Node node) {
        List list2 = Schema2BeansUtil.filterNodes(list, node);
        if (list2.size() == 0) {
            return null;
        }
        Node node2 = (Node)list2.get(0);
        list.remove(node2);
        return node2;
    }

    private static List filterNodes(List list, Node node) {
        Object object;
        Object object2;
        Object object3;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        String string = node.getNodeName();
        LinkedList<Node> linkedList2 = list.iterator();
        while (linkedList2.hasNext()) {
            object3 = (Node)linkedList2.next();
            if (!string.equals(object3.getNodeName())) continue;
            linkedList.add((Node)object3);
        }
        if (linkedList.size() <= 1) {
            return linkedList;
        }
        linkedList2 = new LinkedList();
        object3 = linkedList.iterator();
        while (object3.hasNext()) {
            object2 = (Node)object3.next();
            if (!node.equals(object2)) continue;
            object3.remove();
            linkedList2.add((Node)object2);
        }
        if (linkedList.size() == 1) {
            return linkedList;
        }
        if (linkedList.size() == 0) {
            linkedList = linkedList2;
        }
        linkedList2 = new LinkedList<Node>();
        object3 = node.getNodeValue();
        object2 = linkedList.iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            if (Schema2BeansUtil.equals((String)object3, object.getNodeValue())) continue;
            object2.remove();
            linkedList2.add((Node)object);
        }
        if (linkedList.size() == 1) {
            return linkedList;
        }
        if (linkedList.size() == 0) {
            linkedList = linkedList2;
        }
        linkedList2 = new LinkedList();
        object2 = node.getAttributes();
        object = linkedList.iterator();
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            if (Schema2BeansUtil.equals((NamedNodeMap)object2, node2.getAttributes())) continue;
            object.remove();
            linkedList2.add(node2);
        }
        if (linkedList.size() == 0) {
            return linkedList2;
        }
        return linkedList;
    }

    private static boolean equals(String string, String string2) {
        return string == null ? string2 == null : string2 != null && string.trim().equals(string2.trim());
    }

    private static boolean equals(NamedNodeMap namedNodeMap, NamedNodeMap namedNodeMap2) {
        if (namedNodeMap == null || namedNodeMap2 == null) {
            return namedNodeMap == namedNodeMap2;
        }
        int n = namedNodeMap.getLength();
        if (n != namedNodeMap2.getLength()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Node node = namedNodeMap.item(i);
            Node node2 = namedNodeMap2.getNamedItem(node.getNodeName());
            if (node2 != null && node2.getNodeValue().equals(node2.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private static List relevantNodes(NodeList nodeList) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!Schema2BeansUtil.isRelevantNode(node)) continue;
                linkedList.add(node);
            }
        }
        return linkedList;
    }

    private static boolean isRelevantNode(Node node) {
        short s = node.getNodeType();
        return s != 8 && !Schema2BeansUtil.isWhiteSpaceNode(node);
    }

    private static boolean isWhiteSpaceNode(Node node) {
        short s = node.getNodeType();
        return s == 3 && node.getNodeValue().trim().length() == 0;
    }

    private static Node findNode(BaseBean baseBean, String string) {
        if (string.startsWith(baseBean.fullName())) {
            BaseBean baseBean2;
            while ((baseBean2 = Schema2BeansUtil.getMatchingChild(baseBean, string)) != null) {
                baseBean = baseBean2;
            }
            if (string.equals(baseBean.fullName())) {
                return baseBean.binding.node;
            }
            BeanProp[] beanPropArray = baseBean.beanProps();
            for (int i = 0; i < beanPropArray.length; ++i) {
                BeanProp beanProp = beanPropArray[i];
                int n = beanProp.bindingsSize();
                for (int j = 0; j < n; ++j) {
                    if (!string.equals(beanProp.getFullName(j))) continue;
                    return beanProp.getBinding((int)j).node;
                }
            }
        }
        return null;
    }

    private static BaseBean getMatchingChild(BaseBean baseBean, String string) {
        BaseBean[] baseBeanArray = baseBean.childBeans(false);
        for (int i = 0; i < baseBeanArray.length; ++i) {
            BaseBean baseBean2 = baseBeanArray[i];
            if (!string.startsWith(baseBean2.fullName())) continue;
            return baseBean2;
        }
        return null;
    }

    public static class ReindentationListener
    implements PropertyChangeListener {
        String indent = "    ";

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object == null && object2 != null) {
                String string = propertyChangeEvent.getPropertyName();
                BaseBean baseBean = (BaseBean)propertyChangeEvent.getSource();
                Node node = Schema2BeansUtil.findNode(baseBean, string);
                if (node != null) {
                    this.reindentNode(node);
                }
            }
        }

        private void reindentNode(Node node) {
            Object object;
            Object object2;
            Document document = node.getOwnerDocument();
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer("\n");
            for (object2 = node.getParentNode(); object2 != document; object2 = object2.getParentNode()) {
                ++n;
                stringBuffer.append(this.indent);
            }
            object2 = stringBuffer.toString();
            Node node2 = node.getParentNode();
            Node node3 = node.getPreviousSibling();
            if (node3 != null && Schema2BeansUtil.isWhiteSpaceNode(node3)) {
                object = node3.getNodeValue();
                int n2 = ((String)object).lastIndexOf(10);
                object = n2 > 0 ? ((String)object).substring(0, n2) + (String)object2 : object2;
                node3.setNodeValue((String)object);
            } else {
                node2.insertBefore(document.createTextNode((String)object2), node);
            }
            object = node.getNextSibling();
            if (object != null && Schema2BeansUtil.isWhiteSpaceNode((Node)object)) {
                String string = object.getNodeValue();
                int n3 = string.indexOf(10);
                if (n3 == -1) {
                    object.setNodeValue((String)object2);
                }
            } else {
                node2.insertBefore(document.createTextNode((String)object2), (Node)object);
            }
            XMLUtil.reindent(document, node, n, this.indent);
        }

        public String getIndent() {
            return this.indent;
        }

        public void setIndent(String string) {
            this.indent = string;
        }
    }
}

