/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.fake.frameworks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.fake.frameworks.FakeWebFrameworkProvider;
import org.netbeans.modules.web.fake.frameworks.FakeWebModuleExtender;
import org.netbeans.modules.web.fake.modules.ModulesInstaller;
import org.netbeans.modules.web.fake.modules.ProgressMonitor;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class FakeWebFrameworkConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 27938464212508L;
    final ProgressMonitor progressMonitor = new DownloadProgressMonitor();
    final FakeWebModuleExtender fakeExtender;
    private final String name;
    private final String codeNameBase;
    private JComponent panel;
    private JButton downloadButton;
    private JLabel errorLabel;
    private JLabel infoLabel;
    private JPanel progressPanel;

    FakeWebFrameworkConfigurationPanel(FakeWebModuleExtender fakeWebModuleExtender, String string, String string2) {
        assert (fakeWebModuleExtender != null);
        assert (string != null);
        assert (string2 != null);
        this.fakeExtender = fakeWebModuleExtender;
        this.name = string;
        this.codeNameBase = string2;
        this.initComponents();
        String string3 = null;
        String string4 = null;
        if (fakeWebModuleExtender.isModulePresent()) {
            string3 = NbBundle.getMessage(FakeWebFrameworkConfigurationPanel.class, (String)"LBL_EnableInfo", (Object)string);
            string4 = NbBundle.getMessage(FakeWebFrameworkConfigurationPanel.class, (String)"LBL_Enable");
        } else {
            string3 = NbBundle.getMessage(FakeWebFrameworkConfigurationPanel.class, (String)"LBL_DownloadInfo", (Object)string);
            string4 = NbBundle.getMessage(FakeWebFrameworkConfigurationPanel.class, (String)"LBL_Download");
        }
        this.infoLabel.setText(string3);
        this.downloadButton.setText(string4);
        this.setError(" ");
    }

    void setError(String string) {
        assert (SwingUtilities.isEventDispatchThread());
        this.errorLabel.setText(string);
    }

    private void initComponents() {
        this.errorLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.downloadButton = new JButton();
        this.progressPanel = new JPanel();
        this.errorLabel.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"dummy");
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)"dummy");
        Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)"dummy");
        this.downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FakeWebFrameworkConfigurationPanel.this.downloadButtonActionPerformed(actionEvent);
            }
        });
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 3));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.progressPanel, -1, 374, Short.MAX_VALUE).add((Component)this.infoLabel).add((Component)this.downloadButton).add((Component)this.errorLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.errorLabel).addPreferredGap(0).add((Component)this.infoLabel).addPreferredGap(0).add((Component)this.downloadButton).add(18, 18, 18).add((Component)this.progressPanel, -1, 118, Short.MAX_VALUE).addContainerGap()));
    }

    private void downloadButtonActionPerformed(ActionEvent actionEvent) {
        this.downloadButton.setEnabled(false);
        final boolean[] blArray = new boolean[1];
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                blArray[0] = ModulesInstaller.installModules(FakeWebFrameworkConfigurationPanel.this.progressMonitor, FakeWebFrameworkConfigurationPanel.this.codeNameBase);
            }
        });
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                WebFrameworkProvider webFrameworkProvider = null;
                if (blArray[0]) {
                    int n = 0;
                    while (webFrameworkProvider == null && ++n <= 10) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            Exceptions.printStackTrace((Throwable)interruptedException);
                        }
                        webFrameworkProvider = FakeWebFrameworkConfigurationPanel.this.getWebFrameworkProvider();
                    }
                }
                if (webFrameworkProvider != null) {
                    FakeWebFrameworkConfigurationPanel.this.setRealWebFrameworkProvider(webFrameworkProvider);
                    FakeWebFrameworkConfigurationPanel.this.setRealWebFrameworkConfigurationPanel();
                    FakeWebFrameworkConfigurationPanel.this.fakeExtender.update();
                    FakeWebFrameworkConfigurationPanel.this.fakeExtender.stateChanged(null);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String string = null;
                            string = FakeWebFrameworkConfigurationPanel.this.fakeExtender.isModulePresent() ? NbBundle.getMessage(FakeWebFrameworkConfigurationPanel.class, (String)"MSG_EnableFailed") : NbBundle.getMessage(FakeWebFrameworkConfigurationPanel.class, (String)"MSG_DownloadFailed");
                            FakeWebFrameworkConfigurationPanel.this.setError(string);
                            FakeWebFrameworkConfigurationPanel.this.downloadButton.setEnabled(true);
                            FakeWebFrameworkConfigurationPanel.this.progressPanel.removeAll();
                            FakeWebFrameworkConfigurationPanel.this.progressPanel.revalidate();
                            FakeWebFrameworkConfigurationPanel.this.progressPanel.repaint();
                        }
                    });
                }
            }
        });
        task.schedule(0);
    }

    private void setRealWebFrameworkProvider(WebFrameworkProvider webFrameworkProvider) {
        assert (webFrameworkProvider != null) : String.format("Web framework provider must be found for %s (%s)", this.name, this.codeNameBase);
        assert (!(webFrameworkProvider instanceof FakeWebFrameworkProvider.FakeWebFrameworkProviderImpl)) : "Fake web framework provider found";
        this.fakeExtender.setWebFrameworkProvider(webFrameworkProvider);
    }

    private WebFrameworkProvider getWebFrameworkProvider() {
        for (WebFrameworkProvider webFrameworkProvider : WebFrameworks.getFrameworks()) {
            if (!webFrameworkProvider.getClass().getName().equals(this.fakeExtender.getFrameworkProviderClassName())) continue;
            return webFrameworkProvider;
        }
        return null;
    }

    private void setRealWebFrameworkConfigurationPanel() {
        WebModuleExtender webModuleExtender = this.fakeExtender.getDelegate();
        assert (webModuleExtender != null) : String.format("Real web module extender must be found for %s (%s)", this.name, this.codeNameBase);
        this.panel = webModuleExtender.getComponent();
        this.removeAll();
        if (this.panel != null) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.panel, "North");
        }
        this.revalidate();
        this.repaint();
    }

    private final class DownloadProgressMonitor
    implements ProgressMonitor {
        private DownloadProgressMonitor() {
        }

        public void onDownload(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        public void onValidate(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        public void onInstall(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        public void onEnable(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        private void updateProgress(ProgressHandle progressHandle) {
            final JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
            final JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FakeWebFrameworkConfigurationPanel.this.progressPanel.removeAll();
                    FakeWebFrameworkConfigurationPanel.this.progressPanel.add(jLabel);
                    FakeWebFrameworkConfigurationPanel.this.progressPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    FakeWebFrameworkConfigurationPanel.this.progressPanel.add(jComponent);
                    FakeWebFrameworkConfigurationPanel.this.progressPanel.revalidate();
                    FakeWebFrameworkConfigurationPanel.this.progressPanel.repaint();
                }
            });
        }
    }
}

