/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.ui.interfaces.OpenableInBrowser;
import org.netbeans.modules.hudson.util.HudsonPropertiesSupport;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonJobImpl
implements HudsonJob,
OpenableInBrowser {
    private HudsonPropertiesSupport properties = new HudsonPropertiesSupport();
    private Collection<HudsonView> views = new ArrayList<HudsonView>();
    private HudsonInstanceImpl instance;
    private Sheet.Set set;
    private Collection<? extends HudsonJobBuild> builds;
    final List<HudsonMavenModule> mavenModules = new LinkedList<HudsonMavenModule>();

    public HudsonJobImpl(HudsonInstanceImpl hudsonInstanceImpl) {
        this.instance = hudsonInstanceImpl;
    }

    public void putProperty(String string, Object object) {
        if (object == null) {
            throw new NullPointerException("putProperty: " + string);
        }
        this.properties.putProperty(string, object);
    }

    @Override
    public String getDisplayName() {
        String string = this.properties.getProperty("job_display_name", String.class);
        return string != null ? string : this.getName();
    }

    @Override
    public String getName() {
        return this.properties.getProperty("job_name", String.class);
    }

    @Override
    public String getUrl() {
        String string = this.properties.getProperty("job_url", String.class);
        assert (string.endsWith("/")) : string;
        return string;
    }

    @Override
    public HudsonJob.Color getColor() {
        return this.properties.getProperty("job_color", HudsonJob.Color.class);
    }

    @Override
    public boolean isInQueue() {
        try {
            return this.properties.getProperty("job_in_queue", Boolean.class);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public boolean isBuildable() {
        return this.properties.getProperty("job_buildable", Boolean.class);
    }

    @Override
    public int getLastBuild() {
        try {
            return this.properties.getProperty("job_last_build", Integer.class);
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    @Override
    public int getLastStableBuild() {
        try {
            return this.properties.getProperty("job_last_stable_build", Integer.class);
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    @Override
    public int getLastSuccessfulBuild() {
        try {
            return this.properties.getProperty("job_last_successful_build", Integer.class);
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    @Override
    public int getLastFailedBuild() {
        try {
            return this.properties.getProperty("job_last_failed_build", Integer.class);
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    @Override
    public int getLastCompletedBuild() {
        try {
            return this.properties.getProperty("job_last_completed_build", Integer.class);
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    @Override
    public synchronized Collection<HudsonView> getViews() {
        return this.views;
    }

    public synchronized void addView(HudsonView hudsonView) {
        this.views.add(hudsonView);
    }

    @Override
    public void start() {
        this.instance.getConnector().startJob(this);
    }

    public Sheet.Set getSheetSet() {
        if (null == this.set) {
            this.set = Sheet.createPropertiesSet();
            this.set.setDisplayName(this.getDisplayName());
            this.set.put((Node.Property[])new PropertySupport[]{new HudsonJobProperty("job_name", NbBundle.getMessage(HudsonJobImpl.class, (String)"TXT_Job_Prop_Name"), NbBundle.getMessage(HudsonJobImpl.class, (String)"DESC_Job_Prop_Name")), new HudsonJobProperty("job_url", NbBundle.getMessage(HudsonJobImpl.class, (String)"TXT_Job_Prop_Url"), NbBundle.getMessage(HudsonJobImpl.class, (String)"DESC_Job_Prop_Url")), new PropertySupport.ReadWrite<Boolean>("salient", Boolean.TYPE, NbBundle.getMessage(HudsonJobImpl.class, (String)"HudsonJobImpl.watched"), NbBundle.getMessage(HudsonJobImpl.class, (String)"HudsonJobImpl.watched_desc")){

                public Boolean getValue() {
                    return HudsonJobImpl.this.isSalient();
                }

                public void setValue(Boolean bl) {
                    if (!this.getValue().equals(bl)) {
                        HudsonJobImpl.this.instance.setSalient(HudsonJobImpl.this, bl);
                    }
                }
            }});
        }
        return this.set;
    }

    @Override
    public FileSystem getRemoteWorkspace() {
        return this.instance.getRemoteWorkspace(this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HudsonJobImpl)) {
            return false;
        }
        HudsonJobImpl hudsonJobImpl = (HudsonJobImpl)object;
        if (!(this.getDisplayName() == hudsonJobImpl.getDisplayName() || this.getDisplayName() != null && this.getDisplayName().equals(hudsonJobImpl.getDisplayName()))) {
            return false;
        }
        if (!(this.getName() == hudsonJobImpl.getName() || this.getName() != null && this.getName().equals(hudsonJobImpl.getName()))) {
            return false;
        }
        if (!(this.getUrl() == hudsonJobImpl.getUrl() || this.getUrl() != null && this.getUrl().equals(hudsonJobImpl.getUrl()))) {
            return false;
        }
        if (!(this.getColor() == hudsonJobImpl.getColor() || this.getColor() != null && this.getColor().equals((Object)hudsonJobImpl.getColor()))) {
            return false;
        }
        if (this.isInQueue() != hudsonJobImpl.isInQueue()) {
            return false;
        }
        if (this.isBuildable() != hudsonJobImpl.isBuildable()) {
            return false;
        }
        if (!(this.getViews() == hudsonJobImpl.getViews() || this.getViews() != null && ((Object)this.getViews()).equals(hudsonJobImpl.getViews()))) {
            return false;
        }
        if (this.getLastCompletedBuild() != hudsonJobImpl.getLastCompletedBuild()) {
            return false;
        }
        return ((Object)this.mavenModules).equals(hudsonJobImpl.mavenModules);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(HudsonJob hudsonJob) {
        return this.getDisplayName().compareTo(hudsonJob.getDisplayName());
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public synchronized Collection<? extends HudsonJobBuild> getBuilds() {
        if (this.builds == null) {
            this.builds = this.instance.getConnector().getBuilds(this);
        }
        return this.builds;
    }

    @Override
    public HudsonInstanceImpl getInstance() {
        return this.instance;
    }

    @Override
    public boolean isSalient() {
        return this.instance.isSalient(this);
    }

    void addModule(String string, String string2, HudsonJob.Color color, String string3) {
        this.mavenModules.add(new HudsonMavenModule(string, string2, color, string3));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HudsonJobProperty
    extends PropertySupport.ReadOnly<String> {
        public HudsonJobProperty(String string, String string2, String string3) {
            super(string, String.class, string2, string3);
        }

        public String getValue() {
            return HudsonJobImpl.this.properties.getProperty(this.getName(), String.class);
        }
    }

    static class HudsonMavenModule {
        final String name;
        final String displayName;
        final HudsonJob.Color color;
        final String url;

        HudsonMavenModule(String string, String string2, HudsonJob.Color color, String string3) {
            this.name = string;
            this.displayName = string2;
            this.color = color;
            this.url = string3;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HudsonMavenModule)) {
                return false;
            }
            HudsonMavenModule hudsonMavenModule = (HudsonMavenModule)object;
            return this.name.equals(hudsonMavenModule.name) && this.displayName.equals(hudsonMavenModule.displayName) && this.color == hudsonMavenModule.color && this.url.equals(hudsonMavenModule.url);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.url;
        }
    }
}

