/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.hudson.api.HudsonChangeAdapter;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.impl.HudsonConnector;
import org.netbeans.modules.hudson.impl.HudsonInstanceProperties;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.impl.RemoteFileSystem;
import org.netbeans.modules.hudson.ui.interfaces.OpenableInBrowser;
import org.netbeans.modules.hudson.ui.notification.ProblemNotificationController;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonInstanceImpl
implements HudsonInstance,
OpenableInBrowser {
    private static final Logger LOG = Logger.getLogger(HudsonInstanceImpl.class.getName());
    private HudsonInstanceProperties properties;
    private final HudsonConnector connector;
    private HudsonVersion version;
    private boolean connected;
    private boolean terminated;
    private final Synchronization synchronization;
    private final Semaphore semaphore;
    private Collection<HudsonJob> jobs = new ArrayList<HudsonJob>();
    private Collection<HudsonView> views = new ArrayList<HudsonView>();
    private final Collection<HudsonChangeListener> listeners = new ArrayList<HudsonChangeListener>();
    private ProblemNotificationController problemNotificationController;
    private final Map<String, Reference<RemoteFileSystem>> workspaces = new HashMap<String, Reference<RemoteFileSystem>>();
    private final Map<String, Reference<RemoteFileSystem>> artifacts = new HashMap<String, Reference<RemoteFileSystem>>();

    private HudsonInstanceImpl(HudsonInstanceProperties hudsonInstanceProperties) {
        this.properties = hudsonInstanceProperties;
        this.connector = new HudsonConnector(this);
        this.synchronization = new Synchronization();
        this.semaphore = new Semaphore(1, true);
        this.terminated = false;
        this.synchronization.start();
        this.properties.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("sync_time")) {
                    HudsonInstanceImpl.this.synchronization.start();
                }
            }
        });
        final HudsonInstanceImpl hudsonInstanceImpl = this;
        this.addHudsonChangeListener(new HudsonChangeAdapter(){

            public void contentChanged() {
                ArrayList<HudsonJob> arrayList = new ArrayList<HudsonJob>();
                for (HudsonJob hudsonJob : HudsonInstanceImpl.this.getJobs()) {
                    if (!hudsonJob.getColor().equals((Object)HudsonJob.Color.red) && !hudsonJob.getColor().equals((Object)HudsonJob.Color.red_anime)) continue;
                    arrayList.add(hudsonJob);
                }
                if (HudsonInstanceImpl.this.problemNotificationController == null) {
                    HudsonInstanceImpl.this.problemNotificationController = new ProblemNotificationController(hudsonInstanceImpl);
                }
                HudsonInstanceImpl.this.problemNotificationController.updateNotifications();
            }
        });
    }

    @Override
    public boolean isPersisted() {
        return this.properties.isPersisted();
    }

    public void makePersistent() {
        if (this.isPersisted()) {
            return;
        }
        String string = (String)this.properties.get("name");
        String string2 = (String)this.properties.get("url");
        String string3 = (String)this.properties.get("sync_time");
        HudsonInstanceProperties hudsonInstanceProperties = new HudsonInstanceProperties(string, string2, string3);
        for (Map.Entry object2 : this.properties.entrySet()) {
            hudsonInstanceProperties.put((String)object2.getKey(), (String)object2.getValue());
        }
        List<PropertyChangeListener> list = this.properties.getCurrentListeners();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator.next();
            hudsonInstanceProperties.addPropertyChangeListener(propertyChangeListener);
            this.properties.removePropertyChangeListener(propertyChangeListener);
        }
        this.properties = hudsonInstanceProperties;
        this.storeDefinition();
        this.fireContentChanges();
    }

    void storeDefinition() {
        if (!this.isPersisted()) {
            return;
        }
        Preferences preferences = this.prefs();
        for (Map.Entry entry : this.properties.entrySet()) {
            preferences.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public Preferences prefs() {
        return HudsonManagerImpl.instancePrefs().node(HudsonManagerImpl.simplifyServerLocation(this.getName(), true));
    }

    public static HudsonInstanceImpl createHudsonInstance(String string, String string2, String string3) {
        return HudsonInstanceImpl.createHudsonInstance(new HudsonInstanceProperties(string, string2, string3));
    }

    public static HudsonInstanceImpl createHudsonInstance(HudsonInstanceProperties hudsonInstanceProperties) {
        HudsonInstanceImpl hudsonInstanceImpl = new HudsonInstanceImpl(hudsonInstanceProperties);
        assert (hudsonInstanceImpl.getName() != null);
        assert (hudsonInstanceImpl.getUrl() != null);
        assert (Integer.parseInt((String)hudsonInstanceImpl.getProperties().get("sync_time")) >= 0);
        if (null == HudsonManagerImpl.getDefault().addInstance(hudsonInstanceImpl)) {
            return null;
        }
        return hudsonInstanceImpl;
    }

    public void terminate() {
        this.synchronization.stop();
        this.terminated = true;
        this.connected = false;
        this.version = null;
        this.jobs.clear();
        this.views.clear();
        this.fireStateChanges();
        this.fireContentChanges();
    }

    public HudsonConnector getConnector() {
        return this.connector;
    }

    @Override
    public HudsonVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public HudsonInstanceProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return (String)this.getProperties().get("name");
    }

    @Override
    public String getUrl() {
        String string = (String)this.getProperties().get("url");
        assert (string.endsWith("/")) : string;
        return string;
    }

    @Override
    public synchronized Collection<HudsonJob> getJobs() {
        return this.jobs;
    }

    boolean isSalient(HudsonJobImpl hudsonJobImpl) {
        HudsonInstanceProperties hudsonInstanceProperties = this.getProperties();
        if (HudsonInstanceProperties.split((String)hudsonInstanceProperties.get("suppressed_jobs")).contains(hudsonJobImpl.getName())) {
            return false;
        }
        List<String> list = HudsonInstanceProperties.split((String)hudsonInstanceProperties.get("pref_jobs"));
        if (!list.isEmpty()) {
            return list.contains(hudsonJobImpl.getName());
        }
        return true;
    }

    void setSalient(HudsonJobImpl hudsonJobImpl, boolean bl) {
        HudsonInstanceProperties hudsonInstanceProperties = this.getProperties();
        ArrayList<String> arrayList = new ArrayList<String>(HudsonInstanceProperties.split((String)hudsonInstanceProperties.get("suppressed_jobs")));
        if (bl) {
            arrayList.remove(hudsonJobImpl.getName());
        } else if (!arrayList.contains(hudsonJobImpl.getName())) {
            arrayList.add(hudsonJobImpl.getName());
        }
        hudsonInstanceProperties.put("suppressed_jobs", HudsonInstanceProperties.join(arrayList));
    }

    @Override
    public synchronized Collection<HudsonView> getViews() {
        return this.views;
    }

    public synchronized void setViews(Collection<HudsonView> collection) {
        this.views = collection;
    }

    public synchronized void synchronize() {
        if (this.semaphore.tryAcquire()) {
            final AtomicReference atomicReference = new AtomicReference();
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(HudsonInstanceImpl.class, (String)"MSG_Synchronizing", (Object)this.getName()), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    Thread thread = (Thread)atomicReference.get();
                    if (thread != null) {
                        LOG.fine("Cancelling synchronization of " + HudsonInstanceImpl.this.getUrl());
                        thread.interrupt();
                        return true;
                    }
                    return false;
                }
            });
            progressHandle.start();
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    atomicReference.set(Thread.currentThread());
                    try {
                        Collection<HudsonView> collection = HudsonInstanceImpl.this.getViews();
                        Collection<HudsonJob> collection2 = HudsonInstanceImpl.this.getConnector().getAllJobs();
                        if (HudsonInstanceImpl.this.terminated) {
                            return;
                        }
                        HudsonInstanceImpl.this.connected = HudsonInstanceImpl.this.getConnector().isConnected();
                        HudsonInstanceImpl.this.version = HudsonInstanceImpl.this.getConnector().getHudsonVersion();
                        HudsonInstanceImpl.this.fireStateChanges();
                        Map map = HudsonInstanceImpl.this.workspaces;
                        synchronized (map) {
                            Iterator iterator = HudsonInstanceImpl.this.workspaces.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                RemoteFileSystem remoteFileSystem = (RemoteFileSystem)((Object)((Reference)entry.getValue()).get());
                                if (remoteFileSystem != null) {
                                    remoteFileSystem.refreshAll();
                                    continue;
                                }
                                iterator.remove();
                            }
                        }
                        Collections.sort(Arrays.asList(collection2.toArray(new HudsonJob[0])));
                        if (((Object)HudsonInstanceImpl.this.getJobs()).equals(collection2) && ((Object)collection).equals(HudsonInstanceImpl.this.getViews())) {
                            return;
                        }
                        HudsonInstanceImpl.this.jobs = collection2;
                        HudsonInstanceImpl.this.fireContentChanges();
                    }
                    finally {
                        progressHandle.finish();
                        HudsonInstanceImpl.this.semaphore.release();
                    }
                }
            });
        }
    }

    @Override
    public void addHudsonChangeListener(HudsonChangeListener hudsonChangeListener) {
        this.listeners.add(hudsonChangeListener);
    }

    @Override
    public void removeHudsonChangeListener(HudsonChangeListener hudsonChangeListener) {
        this.listeners.remove(hudsonChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanges() {
        ArrayList<HudsonChangeListener> arrayList;
        Collection<HudsonChangeListener> collection = this.listeners;
        synchronized (collection) {
            arrayList = new ArrayList<HudsonChangeListener>(this.listeners);
        }
        for (HudsonChangeListener hudsonChangeListener : arrayList) {
            hudsonChangeListener.stateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContentChanges() {
        ArrayList<HudsonChangeListener> arrayList;
        Collection<HudsonChangeListener> collection = this.listeners;
        synchronized (collection) {
            arrayList = new ArrayList<HudsonChangeListener>(this.listeners);
        }
        for (HudsonChangeListener hudsonChangeListener : arrayList) {
            hudsonChangeListener.contentChanged();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof HudsonInstance)) {
            return false;
        }
        HudsonInstance hudsonInstance = (HudsonInstance)object;
        return this.getUrl() == hudsonInstance.getUrl() || this.getUrl() != null && this.getUrl().equals(hudsonInstance.getUrl());
    }

    public int hashCode() {
        return this.getUrl() == null ? 445 : this.getUrl().hashCode();
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public int compareTo(HudsonInstance hudsonInstance) {
        return this.getName().compareTo(hudsonInstance.getName());
    }

    FileSystem getRemoteWorkspace(final HudsonJob hudsonJob) {
        return HudsonInstanceImpl.getFileSystemFromCache(this.workspaces, hudsonJob.getName(), new Callable<RemoteFileSystem>(){

            @Override
            public RemoteFileSystem call() throws Exception {
                return new RemoteFileSystem(hudsonJob);
            }
        });
    }

    FileSystem getArtifacts(final HudsonJobBuild hudsonJobBuild) {
        return HudsonInstanceImpl.getFileSystemFromCache(this.artifacts, hudsonJobBuild.getJob().getName() + "/" + hudsonJobBuild.getNumber(), new Callable<RemoteFileSystem>(){

            @Override
            public RemoteFileSystem call() throws Exception {
                return new RemoteFileSystem(hudsonJobBuild);
            }
        });
    }

    FileSystem getArtifacts(final HudsonMavenModuleBuild hudsonMavenModuleBuild) {
        return HudsonInstanceImpl.getFileSystemFromCache(this.artifacts, hudsonMavenModuleBuild.getBuild().getJob().getName() + "/" + hudsonMavenModuleBuild.getBuild().getNumber() + "/" + hudsonMavenModuleBuild.getName(), new Callable<RemoteFileSystem>(){

            @Override
            public RemoteFileSystem call() throws Exception {
                return new RemoteFileSystem(hudsonMavenModuleBuild);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getFileSystemFromCache(Map<String, Reference<RemoteFileSystem>> map, String string, Callable<RemoteFileSystem> callable) {
        Map<String, Reference<RemoteFileSystem>> map2 = map;
        synchronized (map2) {
            RemoteFileSystem remoteFileSystem;
            RemoteFileSystem remoteFileSystem2 = remoteFileSystem = map.containsKey(string) ? map.get(string).get() : null;
            if (remoteFileSystem == null) {
                try {
                    remoteFileSystem = callable.call();
                    map.put(string, new WeakReference<RemoteFileSystem>(remoteFileSystem));
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                    return FileUtil.createMemoryFileSystem();
                }
            }
            return remoteFileSystem;
        }
    }

    private class Synchronization
    implements Runnable {
        private final RequestProcessor processor;
        private final RequestProcessor.Task task;

        private Synchronization() {
            this.processor = new RequestProcessor(HudsonInstanceImpl.this.getUrl(), 1, true);
            this.task = this.processor.create((Runnable)this);
        }

        public synchronized void start() {
            this.task.schedule(0);
        }

        public synchronized void stop() {
            this.task.cancel();
        }

        public void run() {
            HudsonInstanceImpl.this.synchronize();
            String string = (String)HudsonInstanceImpl.this.getProperties().get("sync_time");
            int n = Integer.parseInt(string) * 60 * 1000;
            if (n > 0) {
                this.task.schedule(n);
            }
        }
    }
}

