/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.AbstractComponent;
import org.netbeans.modules.xml.xam.EmbeddableRoot;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.AbstractNamedComponentReference;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentComponent<C extends DocumentComponent<C>>
extends AbstractComponent<C>
implements DocumentComponent<C>,
DocumentModelAccess.NodeUpdater {
    private Element node;

    @Override
    protected abstract void populateChildren(List<C> var1);

    public AbstractDocumentComponent(AbstractDocumentModel abstractDocumentModel, Element element) {
        super(abstractDocumentModel);
        this.setRef(element);
    }

    private void setRef(Element element) {
        assert (element != null) : "n must not be null";
        this.node = element;
    }

    @Override
    public synchronized Element getPeer() {
        return this.node;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        Attr attr = this.getPeer().getAttributeNode(attribute.getName());
        if (attr == null) {
            return null;
        }
        return this.normalizeUndefinedAttributeValue(attr.getValue());
    }

    @Override
    public void setAttribute(String string, Attribute attribute, Object object) {
        this.verifyWrite();
        Object object2 = null;
        String string2 = this.getAttribute(attribute);
        if (string2 != null) {
            try {
                object2 = this.getAttributeValueOf(attribute, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.setAttributeQuietly(attribute, object);
        this.firePropertyChange(string, object2, object);
        this.fireValueChanged();
    }

    protected abstract Object getAttributeValueOf(Attribute var1, String var2);

    public String getAnyAttribute(QName qName) {
        assert (qName != null);
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        String string3 = string2 == null ? null : this.lookupPrefix(string2);
        String string4 = string3 == null ? string : string3 + ":" + string;
        Attr attr = this.getPeer().getAttributeNode(string4);
        if (attr == null) {
            return null;
        }
        return this.normalizeUndefinedAttributeValue(attr.getValue());
    }

    private String normalizeUndefinedAttributeValue(String string) {
        String string2 = string;
        if (this.getModel() != null) {
            string2 = this.getAccess().normalizeUndefinedAttributeValue(string);
        }
        return string2;
    }

    public void setAnyAttribute(QName qName, String string) {
        this.setQNameAttribute(qName.getLocalPart(), qName, string);
    }

    protected void setQNameAttribute(String string, QName qName, String string2) {
        assert (qName != null);
        this.verifyWrite();
        String string3 = this.getPrefixedName(qName, string2 != null);
        String string4 = this.getAnyAttribute(qName);
        if (string2 == null) {
            this.removeAttribute(this.getPeer(), string3);
        } else {
            this.setAttribute(this.getPeer(), string3, string2);
        }
        this.firePropertyChange(string, string4, string2);
        this.fireValueChanged();
    }

    protected String getPrefixedName(QName qName, boolean bl) {
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getPrefix();
        return this.getPrefixedName(string2, string, string3, bl);
    }

    protected String getPrefixedName(String string, String string2) {
        return this.getPrefixedName(string, string2, null, false);
    }

    protected String getPrefixedName(String string, String string2, String string3, boolean bl) {
        String string4;
        if (string == null || string.length() == 0) {
            bl = false;
        }
        String string5 = this.lookupPrefix(string);
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)this.getModel().getRootComponent();
        if (string5 == null) {
            string5 = abstractDocumentComponent.lookupPrefix(string);
        }
        if (string5 != null && (string4 = this.lookupNamespaceURI(string5)) != null && !string4.equals(string)) {
            string5 = null;
        }
        if (string5 != null) {
            string3 = string5;
        } else if (bl) {
            if (string3 == null) {
                string3 = "ns";
            }
            if (string3.length() > 0) {
                string3 = abstractDocumentComponent.ensureUnique(string3, string);
            }
            if (this.isInDocumentModel()) {
                abstractDocumentComponent.addPrefix(string3, string);
            } else {
                this.addPrefix(string3, string);
            }
        }
        if (string3 != null && string3.length() > 0) {
            string2 = string3 + ":" + string2;
        }
        return string2;
    }

    protected String ensureUnique(String string, String string2) {
        assert (string2 != null);
        int n = 0;
        String string3 = string;
        String string4 = this.lookupNamespaceURI(string3);
        while (string4 != null && n < 100 && !string4.equals(string2)) {
            string3 = string + ++n;
            string4 = this.lookupNamespaceURI(string + n);
        }
        if (n >= 100) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Failed to generate unique prefix for " + string2);
        }
        return string3;
    }

    protected void setAttributeQuietly(Attribute attribute, Object object) {
        if (object == null) {
            this.removeAttribute(this.node, attribute.getName());
        } else {
            String string = null;
            if (object instanceof NamedComponentReference) {
                NamedComponentReference namedComponentReference = (NamedComponentReference)object;
                QName qName = namedComponentReference.getQName();
                string = this.getPrefixedName(qName.getNamespaceURI(), qName.getLocalPart(), null, true);
                if (this.getEffectiveParent() == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Referencing while not in tree yet could result in unwanted prefix declaration");
                }
                ((AbstractNamedComponentReference)namedComponentReference).refresh();
            }
            string = string == null ? object.toString() : string;
            this.setAttribute(this.node, attribute.getName(), string);
        }
    }

    protected void removeAttributeQuietly(Element element, String string) {
        this.getAccess().removeAttribute(element, string, this);
    }

    @Override
    protected void appendChildQuietly(C c, List<C> list) {
        this.fixupPrefix(c);
        this.getAccess().appendChild(this.getPeer(), c.getPeer(), this);
        list.add(c);
    }

    @Override
    protected void insertAtIndexQuietly(C c, List<C> list, int n) {
        if (n >= 0 && list.size() > 0 && n < list.size()) {
            this.fixupPrefix(c);
            Element element = ((DocumentComponent)list.get(n)).getPeer();
            this.insertBefore(c.getPeer(), element);
            list.add(n, c);
        } else {
            this.appendChildQuietly(c, list);
        }
    }

    @Override
    protected void removeChildQuietly(C c, List<C> list) {
        this.removeChild(c.getPeer());
        list.remove(c);
    }

    protected String getNamespaceURI() {
        String string = this.getPeer().getNamespaceURI();
        if (string == null && this.getEffectiveParent() != null) {
            String string2 = this.getPeer().getPrefix();
            string = this.lookupNamespaceURI(string2);
        }
        return string;
    }

    public String lookupNamespaceURI(String string, boolean bl) {
        if (bl) {
            String string2 = this.getPrefixes().get(string == null ? "" : string);
            if (string2 == null && this.getEffectiveParent() != null) {
                string2 = this.getEffectiveParent().lookupNamespaceURI(string, true);
            }
            return string2;
        }
        return this.lookupNamespaceURI(string);
    }

    public String lookupNamespaceURI(String string) {
        String string2 = this.getPeer().lookupNamespaceURI(string);
        if (string2 == null && this.getEffectiveParent() != null) {
            string2 = this.getEffectiveParent().lookupNamespaceURI(string);
        }
        return string2;
    }

    public String lookupPrefix(String string) {
        String string2 = this.getPeer().lookupPrefix(string);
        if (string2 == null && this.getEffectiveParent() != null) {
            string2 = this.getEffectiveParent().lookupPrefix(string);
        }
        return string2;
    }

    protected String getXmlFragment() {
        return this.getAccess().getXmlFragment(this.getPeer());
    }

    public String getXmlFragmentInclusive() {
        return this.getModel().getAccess().getXmlFragmentInclusive(this.getPeer());
    }

    protected synchronized void setXmlFragment(String string, String string2) throws IOException {
        this.verifyWrite();
        String string3 = this.getText();
        this.getAccess().setXmlFragment(this.getPeer(), string2, this);
        this.firePropertyChange(string, string3, string2);
        this.fireValueChanged();
    }

    protected synchronized void setText(String string, String string2) {
        this.verifyWrite();
        String string3 = this.getText();
        this.getAccess().setText(this.getPeer(), string2, this);
        this.firePropertyChange(string, string3, string2);
        this.fireValueChanged();
    }

    protected String getText() {
        return AbstractDocumentComponent.getText(this.getPeer());
    }

    public static String getText(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Text)) continue;
            stringBuilder.append(node.getNodeValue());
        }
        return stringBuilder.toString();
    }

    @Override
    public AbstractDocumentModel getModel() {
        return (AbstractDocumentModel)super.getModel();
    }

    @Override
    public boolean referencesSameNode(Node node) {
        return this.getModel().areSameNodes(this.getPeer(), node);
    }

    @Override
    public synchronized void updateReference(Element element) {
        this.node = element;
    }

    public synchronized <N extends Node> void updateReference(List<N> list) {
        AbstractDocumentComponent abstractDocumentComponent = this;
        assert (list != null && list.size() > 0);
        for (int i = 0; i < list.size(); ++i) {
            assert (list.get(i) instanceof Element);
            Element element = (Element)list.get(i);
            if (abstractDocumentComponent.referencesSameNode(element)) {
                abstractDocumentComponent.updateReference(element, list);
                if (abstractDocumentComponent.getEffectiveParent() == null) break;
                abstractDocumentComponent = abstractDocumentComponent.getEffectiveParent();
                continue;
            }
            if (i != list.size() - 1) continue;
            throw new IllegalArgumentException("Expect new reference node has same Id as current");
        }
    }

    protected <N extends Node> void updateReference(Element element, List<N> list) {
        this.updateReference(element);
    }

    protected DocumentModelAccess getAccess() {
        this.getChildren();
        return this.getModel().getAccess();
    }

    @Override
    public int findPosition() {
        if (this.getModel() == null) {
            return 0;
        }
        return this.getAccess().findPosition(this.getPeer());
    }

    private void removeAttribute(Element element, String string) {
        this.getAccess().removeAttribute(element, string, this);
    }

    private void setAttribute(Element element, String string, String string2) {
        this.getAccess().setAttribute(element, string, string2, this);
    }

    private void insertBefore(Node node, Node node2) {
        this.getAccess().insertBefore(this.node, node, node2, this);
    }

    private void removeChild(Node node) {
        this.getAccess().removeChild(this.node, node, this);
    }

    protected void updatePeer(String string, Element element) {
        AbstractDocumentComponent abstractDocumentComponent = this.getEffectiveParent();
        Element element2 = abstractDocumentComponent.getPeer();
        Element element3 = this.getPeer();
        this.getAccess().replaceChild(element2, this.getPeer(), element, abstractDocumentComponent);
        this.updateReference(element);
        this.firePropertyChange(string, element3, element);
        this.fireValueChanged();
    }

    protected Attribute createPrefixAttribute(String string) {
        assert (string != null);
        if (string.length() == 0) {
            return new PrefixAttribute("xmlns");
        }
        return new PrefixAttribute("xmlns:" + string);
    }

    public void addPrefix(String string, String string2) {
        if (string2 == null) {
            return;
        }
        Attribute attribute = this.createPrefixAttribute(string);
        this.setAttribute(attribute.getName(), attribute, (Object)string2);
    }

    public void removePrefix(String string) {
        this.setAttribute(string, this.createPrefixAttribute(string), null);
    }

    public Map<String, String> getPrefixes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = this.getPeer().getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string = node.getLocalName();
            String string2 = node.getPrefix();
            if (!"xmlns".equals(string) && !"xmlns".equals(string2)) continue;
            String string3 = node.getNodeValue();
            hashMap.put(string, string3);
        }
        String string = (String)hashMap.remove("xmlns");
        if (string != null) {
            hashMap.put("", string);
        }
        return hashMap;
    }

    private void fixupPrefix(C c) {
        if (this.getModel().inSync() || this.getModel().inUndoRedo()) {
            return;
        }
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)c;
        Element element = abstractDocumentComponent.getPeer();
        String string = abstractDocumentComponent.getNamespaceURI();
        if (string == null || string.equals("")) {
            return;
        }
        if (string.equals(this.getNamespaceURI())) {
            element.setPrefix(this.getPeer().getPrefix());
        } else if (string.equals(this.lookupNamespaceURI(""))) {
            element.setPrefix(null);
        } else {
            this.ensurePrefixDeclaredFor(element, string);
        }
        for (DocumentComponent documentComponent : c.getChildren()) {
            this.fixupPrefix(documentComponent);
        }
    }

    private void ensurePrefixDeclaredFor(Element element, String string) {
        String string2 = this.lookupPrefix(string);
        String string3 = element.getPrefix();
        if (string2 == null) {
            if (string3 == null) {
                string3 = "ns";
            }
            string3 = this.ensureUnique(string3, string);
            ((AbstractDocumentComponent)this.getModel().getRootComponent()).addPrefix(string3, string);
            element.setPrefix(string3);
        } else {
            element.setPrefix(string2);
        }
    }

    protected void ensureValueNamespaceDeclared(String string, String string2, String string3) {
        String string4 = null;
        if (string2 != null) {
            string4 = this.lookupPrefix(string2);
        }
        if (string4 == null) {
            String string5 = this.lookupNamespaceURI(string3);
            string4 = string5 == null ? string3 : this.ensureUnique(string3, string);
            this.addPrefix(string4, string);
        } else {
            this.removePrefix(string4);
            this.addPrefix(string4, string);
        }
    }

    @Override
    public C findChildComponent(Element element) {
        for (DocumentComponent documentComponent : this.getChildren()) {
            if (!documentComponent.referencesSameNode(element)) continue;
            return (C)documentComponent;
        }
        return null;
    }

    public C findChildComponentByIdentity(Element element) {
        ElementIdentity elementIdentity = this.getModel().getAccess().getElementIdentity();
        Document document = this.getModel().getDocument();
        for (DocumentComponent documentComponent : this.getChildren()) {
            if (!elementIdentity.compareElement(documentComponent.getPeer(), element, document, document)) continue;
            return (C)documentComponent;
        }
        return null;
    }

    @Override
    public DocumentComponent copy(C c) {
        if (this.getModel() == null) {
            throw new IllegalStateException("Cannot copy component already removed from model");
        }
        Element element = this.getAccess().duplicate(this.getPeer());
        DocumentModel documentModel = c == null ? this.getModel() : (DocumentModel)c.getModel();
        return documentModel.createComponent(c, element);
    }

    @Override
    protected void verifyWrite() {
        if (this.getModel() == null) {
            throw new IllegalStateException("Cannot mutate a component already removed from model.");
        }
        if (this.isInDocumentModel()) {
            this.getModel().validateWrite();
        }
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.isInDocumentModel()) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    protected void fireValueChanged() {
        if (this.isInDocumentModel()) {
            super.fireValueChanged();
        }
    }

    @Override
    protected void fireChildRemoved() {
        if (this.isInDocumentModel()) {
            super.fireChildRemoved();
        }
    }

    @Override
    protected void fireChildAdded() {
        if (this.isInDocumentModel()) {
            super.fireChildAdded();
        }
    }

    @Override
    public boolean isInDocumentModel() {
        if (this.getModel() == null) {
            return false;
        }
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)this.getModel().getRootComponent();
        if (abstractDocumentComponent == null) {
            return false;
        }
        if (abstractDocumentComponent == this) {
            return true;
        }
        AbstractDocumentComponent abstractDocumentComponent2 = this.getEffectiveParent();
        if (abstractDocumentComponent2 == null) {
            return false;
        }
        while (abstractDocumentComponent2 != null && abstractDocumentComponent2.getEffectiveParent() != null) {
            if (abstractDocumentComponent2 instanceof EmbeddableRoot) {
                abstractDocumentComponent = (AbstractDocumentComponent)abstractDocumentComponent2.getEffectiveParent().getModel().getRootComponent();
            }
            abstractDocumentComponent2 = abstractDocumentComponent2.getEffectiveParent();
        }
        return abstractDocumentComponent == abstractDocumentComponent2;
    }

    @Override
    public int findAttributePosition(String string) {
        Attr attr = this.getPeer().getAttributeNode(string);
        if (attr != null) {
            return this.getAccess().findPosition(attr);
        }
        return -1;
    }

    public QName getQName() {
        return AbstractDocumentComponent.getQName(this.getPeer());
    }

    public static QName getQName(Node node) {
        String string = node.getNamespaceURI();
        String string2 = node.getLocalName();
        String string3 = node.getPrefix();
        assert (string2 != null);
        if (string == null && string3 == null) {
            return new QName(string2);
        }
        if (string != null && string3 == null) {
            return new QName(string, string2);
        }
        return new QName(string, string2, string3);
    }

    private ModelSource resolveModelSource(String string, ModelSource modelSource, CatalogModel catalogModel) {
        ModelSource modelSource2 = null;
        try {
            if (string != null) {
                modelSource2 = catalogModel.getModelSource(AbstractDocumentComponent.getURI(string), modelSource);
            }
        }
        catch (CatalogModelException catalogModelException) {
            Logger logger = Logger.getLogger(AbstractDocumentComponent.class.getName());
            logger.log(Level.FINE, catalogModelException.getMessage());
        }
        return modelSource2;
    }

    protected ModelSource resolveModel(String string) throws CatalogModelException {
        return this._resolveModel(string, null);
    }

    private ModelSource _resolveModel(String string, String string2) throws CatalogModelException {
        CatalogModel catalogModel = (CatalogModel)this.getModel().getModelSource().getLookup().lookup(CatalogModel.class);
        ModelSource modelSource = this.resolveModelSource(string, this.getModel().getModelSource(), catalogModel);
        if (modelSource == null) {
            modelSource = this.resolveModelSource(string2, this.getModel().getModelSource(), catalogModel);
        }
        if (modelSource == null) {
            String string3 = "Cannot resolve file using hint = " + string + " backup = " + string2;
            throw new CatalogModelException(string3);
        }
        return modelSource;
    }

    private static URI getURI(String string) throws CatalogModelException {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CatalogModelException(uRISyntaxException);
        }
    }

    public Map<QName, String> getAttributeMap() {
        return this.getModel().getAccess().getAttributeMap(this.getPeer());
    }

    protected int findDomainIndex(Element element) {
        if (!this.getModel().isDomainElement(element)) {
            return -1;
        }
        int n = 0;
        NodeList nodeList = this.getPeer().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) == element) {
                return n;
            }
            if (!this.getModel().isDomainElement(nodeList.item(i))) continue;
            ++n;
        }
        return -1;
    }

    protected AbstractDocumentComponent getEffectiveParent() {
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)this.getParent();
        if (abstractDocumentComponent == null && this instanceof EmbeddableRoot) {
            abstractDocumentComponent = (AbstractDocumentComponent)((EmbeddableRoot)((Object)this)).getForeignParent();
        }
        return abstractDocumentComponent;
    }

    protected Element getChildElement(QName qName) {
        NodeList nodeList = this.getPeer().getElementsByTagName(qName.getLocalPart());
        Element element = null;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!qName.equals(AbstractDocumentComponent.getQName(nodeList.item(i)))) continue;
                element = (Element)nodeList.item(i);
                break;
            }
        }
        return element;
    }

    protected String getChildElementText(QName qName) {
        Element element = this.getChildElement(qName);
        return element == null ? null : AbstractDocumentComponent.getText(element);
    }

    protected void setChildElementText(String string, String string2, QName qName) {
        String string3;
        this.verifyWrite();
        Element element = this.getChildElement(qName);
        String string4 = string3 = element == null ? null : AbstractDocumentComponent.getText(element);
        if (string2 == null) {
            if (element == null) {
                return;
            }
            this.removeChild(element);
            if (string3 == null) {
                return;
            }
        } else if (string2.length() == 0) {
            if (element != null) {
                this.removeChild(element);
            }
            element = this.getModel().getDocument().createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
            this.getModel().getAccess().appendChild(this.getPeer(), element, this);
        } else {
            if (string2.equals(string3)) {
                return;
            }
            if (element == null) {
                element = this.getModel().getDocument().createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
                this.getModel().getAccess().appendChild(this.getPeer(), element, this);
            }
            this.getModel().getAccess().setText(element, string2, this);
        }
        this.firePropertyChange(string, string3, string2);
        this.fireValueChanged();
    }

    protected String getLeadingText(C c) {
        return this.getText(c, true, true);
    }

    protected void setLeadingText(String string, String string2, C c) {
        this.setText(string, string2, c, true, true);
    }

    protected String getTrailingText(C c) {
        return this.getText(c, false, true);
    }

    protected void setTrailingText(String string, String string2, C c) {
        this.setText(string, string2, c, false, true);
    }

    protected String getText(C c, boolean bl, boolean bl2) {
        Node node;
        int n;
        int n2 = this.getNodeIndexOf(this.getPeer(), c.getPeer());
        if (n2 < 0) {
            throw new IllegalArgumentException("Child peer node is not part of children nodes");
        }
        StringBuilder stringBuilder = null;
        NodeList nodeList = this.getPeer().getChildNodes();
        int n3 = n = bl ? n2 - 1 : n2 + 1;
        while (n > -1 && n < nodeList.getLength() && !((node = nodeList.item(n)) instanceof Element)) {
            if (node instanceof Text && (bl2 || node.getNodeType() != 8)) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                if (bl) {
                    stringBuilder.insert(0, node.getNodeValue());
                } else {
                    stringBuilder.append(node.getNodeValue());
                }
            }
            n = bl ? --n : ++n;
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    protected void setText(String string, String string2, C c, boolean bl, boolean bl2) {
        int n;
        this.verifyWrite();
        StringBuilder stringBuilder = null;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = this.getPeer().getChildNodes();
        int n2 = this.getNodeIndexOf(this.getPeer(), c.getPeer());
        if (n2 < 0) {
            throw new IllegalArgumentException("Child peer node is not part of children nodes");
        }
        Element element = bl ? c.getPeer() : null;
        int n3 = n = bl ? n2 - 1 : n2 + 1;
        while (n > -1 && n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node != null && node.getNodeType() == 1) {
                if (bl) {
                    element = c.getPeer();
                    break;
                }
                element = (Element)node;
                break;
            }
            if (node instanceof Text && (bl2 || node.getNodeType() != 8)) {
                arrayList.add(node);
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                if (bl) {
                    stringBuilder.insert(0, node.getNodeValue());
                } else {
                    stringBuilder.append(node.getNodeValue());
                }
            }
            n = bl ? --n : ++n;
        }
        this.getModel().getAccess().removeChildren(this.getPeer(), arrayList, this);
        if (string2 != null) {
            Text text = this.getModel().getDocument().createTextNode(string2);
            if (element != null) {
                this.getModel().getAccess().insertBefore(this.getPeer(), text, element, this);
            } else {
                this.getModel().getAccess().appendChild(this.getPeer(), text, this);
            }
        }
        this.firePropertyChange(string, stringBuilder == null ? null : stringBuilder.toString(), string2);
        this.fireValueChanged();
    }

    protected int getNodeIndexOf(Node node, Node node2) {
        if (node2 == null) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node node3 = node.getChildNodes().item(i);
            ++n;
            if (!this.getAccess().areSameNodes(node3, node2)) continue;
            return n;
        }
        return -1;
    }

    public static class PrefixAttribute
    implements Attribute {
        private String prefix;

        public PrefixAttribute(String string) {
            this.prefix = string;
        }

        public Class getType() {
            return String.class;
        }

        public String getName() {
            return this.prefix;
        }

        public Class getMemberType() {
            return null;
        }
    }
}

