/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTabbedPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardAction;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardIterator;
import org.netbeans.modules.cnd.discovery.wizard.SimpleConfigurationWizard;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildActionsProviderImpl
extends BuildActionsProvider {
    public List<BuildActionsProvider.BuildAction> getActions(String string, ProjectActionEvent[] projectActionEventArray) {
        ArrayList<BuildActionsProvider.BuildAction> arrayList = new ArrayList<BuildActionsProvider.BuildAction>();
        if (projectActionEventArray != null && projectActionEventArray.length == 2 && projectActionEventArray[0].getType() == ProjectActionEvent.Type.CLEAN && projectActionEventArray[1].getType() == ProjectActionEvent.Type.BUILD && projectActionEventArray[1].getConfiguration() instanceof MakeConfiguration && projectActionEventArray[1].getConfiguration().getConfigurationType().getValue() == 0) {
            arrayList.add(new ConfigureAction(string, projectActionEventArray));
        }
        return arrayList;
    }

    private static final class ConfigureAction
    extends AbstractAction
    implements BuildActionsProvider.BuildAction {
        private String ioTabName;
        private ProjectActionEvent[] events;
        private int step = -1;

        public ConfigureAction(String string, ProjectActionEvent[] projectActionEventArray) {
            this.ioTabName = string;
            this.events = projectActionEventArray;
        }

        public Object getValue(String string) {
            if (string.equals("SmallIcon")) {
                return new ImageIcon(BuildActionsProviderImpl.class.getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/configure.png"));
            }
            if (string.equals("ShortDescription")) {
                return NbBundle.getBundle(BuildActionsProviderImpl.class).getString("OUTPUT_LOG_ACTION_TEXT");
            }
            return super.getValue(string);
        }

        public void executionStarted() {
            this.setEnabled(false);
        }

        public void executionFinished(int n) {
            if (this.step == 1 && n == 0) {
                this.setEnabled(true);
            }
        }

        public void setStep(int n) {
            this.step = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            JEditorPane jEditorPane = this.findPane();
            if (jEditorPane != null && this.step >= 0 && this.step < this.events.length) {
                Project project = this.events[this.step].getProject();
                String string = this.saveLog(jEditorPane);
                if (string != null) {
                    this.invokeWizard(project, string);
                }
            }
        }

        private String saveLog(JEditorPane jEditorPane) {
            BufferedWriter bufferedWriter = null;
            String string = null;
            try {
                File file = File.createTempFile("tmplog", ".log");
                if (file.exists()) {
                    file.delete();
                }
                file.deleteOnExit();
                string = file.getAbsolutePath();
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                Document document = jEditorPane.getDocument();
                int n = document.getLength();
                Segment segment = new Segment();
                int n2 = 0;
                segment.setPartialReturn(true);
                while (n > 0) {
                    try {
                        document.getText(n2, n, segment);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                    for (char c : segment.array) {
                        if (c == '\u0000') continue;
                        bufferedWriter.append(c);
                    }
                    n -= segment.count;
                    n2 += segment.count;
                }
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException2) {
                        Exceptions.printStackTrace((Throwable)iOException2);
                    }
                }
                string = null;
            }
            return string;
        }

        private void invokeWizard(Project project, String string) {
            boolean bl;
            DiscoveryProvider discoveryProvider = DiscoveryExtension.findProvider("make-log");
            if (discoveryProvider == null) {
                return;
            }
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.getString("OUTPUT_LOG_DILOG_COMTENT_TEXT"), this.getString("OUTPUT_LOG_DILOG_TITLE_TEXT"), 0)) != NotifyDescriptor.YES_OPTION) {
                return;
            }
            DiscoveryWizardDescriptor discoveryWizardDescriptor = new DiscoveryWizardDescriptor((WizardDescriptor.Iterator)this.getPanels());
            discoveryWizardDescriptor.setSimpleMode(true);
            discoveryWizardDescriptor.setProvider(discoveryProvider);
            discoveryWizardDescriptor.setProject(project);
            discoveryWizardDescriptor.setRootFolder(DiscoveryWizardAction.findSourceRoot(project));
            discoveryWizardDescriptor.setBuildLog(string);
            discoveryWizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
            discoveryWizardDescriptor.setTitle(this.getString("WIZARD_TITLE_TXT"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)discoveryWizardDescriptor);
            dialog.setVisible(true);
            dialog.toFront();
            boolean bl2 = bl = discoveryWizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
            if (!bl) {
                // empty if block
            }
            dialog.dispose();
        }

        private String getString(String string) {
            return NbBundle.getBundle(BuildActionsProviderImpl.class).getString(string);
        }

        private WizardDescriptor.InstantiatingIterator getPanels() {
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new SimpleConfigurationWizard()};
            String[] stringArray = new String[panelArray.length];
            for (int i = 0; i < panelArray.length; ++i) {
                Component component = panelArray[i].getComponent();
                stringArray[i] = component.getName();
                DiscoveryWizardAction.setupComponent(stringArray, null, i, component);
            }
            return new DiscoveryWizardIterator(panelArray, panelArray);
        }

        private JEditorPane findPane() {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            return this.findPane((Container)topComponent);
        }

        private JEditorPane findPane(Container container) {
            for (Component component : container.getComponents()) {
                JComponent jComponent;
                if (component instanceof JEditorPane) {
                    return (JEditorPane)component;
                }
                if (component instanceof JTabbedPane) {
                    JEditorPane jEditorPane;
                    jComponent = (JTabbedPane)component;
                    if (jComponent.getComponentCount() <= 0) continue;
                    Component component2 = jComponent.getSelectedComponent();
                    if (component2 instanceof JEditorPane) {
                        return (JEditorPane)component2;
                    }
                    if (!(component2 instanceof Container) || (jEditorPane = this.findPane((Container)component2)) == null) continue;
                    return jEditorPane;
                }
                if (!(component instanceof Container) || (jComponent = this.findPane((Container)component)) == null) continue;
                return jComponent;
            }
            return null;
        }
    }
}

