/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.actions.MakeAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.utils.AllSourceFileFilter;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.projectimport.FollowUp;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.bridge.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.discovery.wizard.bridge.ProjectBridge;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProject
implements PropertyChangeListener {
    private static boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    private Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportProject");
    private File nativeProjectFolder;
    private File projectFolder;
    private String projectName;
    private String makefileName = "Makefile";
    private String makefilePath;
    private String configurePath;
    private String configureArguments;
    private boolean runConfigure = false;
    private boolean manualCA = false;
    private boolean setAsMain;
    private String workingDir;
    private String buildCommand = "$(MAKE) -f Makefile";
    private String cleanCommand = "$(MAKE) -f Makefile clean";
    private String buildResult = "";
    private Project makeProject;
    private boolean runMake;
    private String includeDirectories = "";
    private String macros = "";
    private String consolidationStrategy = "file";
    private Iterator<SourceFolderInfo> sources;
    private String sourceFoldersFilter = null;
    private File configureFile;
    private File makefileFile;
    private Map<Step, State> importResult = new HashMap<Step, State>();
    private Map<String, Item> normalizedItems;
    private static final Map<CsmProject, CsmProgressListener> listeners = new WeakHashMap<CsmProject, CsmProgressListener>();

    public ImportProject(WizardDescriptor wizardDescriptor) {
        if (TRACE) {
            this.logger.setLevel(Level.ALL);
        }
        if (Boolean.TRUE.equals(wizardDescriptor.getProperty("simpleMode"))) {
            this.simpleSetup(wizardDescriptor);
        } else {
            this.customSetup(wizardDescriptor);
        }
    }

    private void simpleSetup(WizardDescriptor wizardDescriptor) {
        Serializable serializable;
        String string = (String)wizardDescriptor.getProperty("path");
        this.nativeProjectFolder = this.projectFolder = new File(string);
        this.projectName = this.projectFolder.getName();
        this.makefileName = "Makefile-" + this.projectName + ".mk";
        this.workingDir = string;
        this.makefilePath = (String)wizardDescriptor.getProperty("makefileName");
        if (this.makefilePath == null) {
            this.configurePath = (String)wizardDescriptor.getProperty("configureName");
            this.configureArguments = (String)wizardDescriptor.getProperty("realFlags");
            this.runConfigure = true;
            serializable = new File(string + "/Makefile");
            this.makefilePath = ((File)serializable).getAbsolutePath();
        }
        this.runMake = Boolean.TRUE.equals(wizardDescriptor.getProperty("buildProject"));
        this.setAsMain = Boolean.TRUE.equals(wizardDescriptor.getProperty("setMain"));
        serializable = new ArrayList<1>();
        serializable.add(new SourceFolderInfo(){

            public File getFile() {
                return ImportProject.this.projectFolder;
            }

            public String getFolderName() {
                return ImportProject.this.projectFolder.getName();
            }

            public boolean isAddSubfoldersSelected() {
                return true;
            }

            public FileFilter getFileFilter() {
                return AllSourceFileFilter.getInstance();
            }
        });
        this.sources = serializable.iterator();
    }

    private void customSetup(WizardDescriptor wizardDescriptor) {
        Iterator iterator;
        String string = (String)wizardDescriptor.getProperty("simpleModeFolder");
        this.nativeProjectFolder = new File(string);
        this.projectFolder = (File)wizardDescriptor.getProperty("projdir");
        this.projectName = (String)wizardDescriptor.getProperty("name");
        this.makefileName = (String)wizardDescriptor.getProperty("makefilename");
        this.workingDir = (String)wizardDescriptor.getProperty("buildCommandWorkingDirTextField");
        this.buildCommand = (String)wizardDescriptor.getProperty("buildCommandTextField");
        this.cleanCommand = (String)wizardDescriptor.getProperty("cleanCommandTextField");
        this.buildResult = (String)wizardDescriptor.getProperty("outputTextField");
        this.includeDirectories = (String)wizardDescriptor.getProperty("includeTextField");
        this.macros = (String)wizardDescriptor.getProperty("macroTextField");
        this.makefilePath = (String)wizardDescriptor.getProperty("makefileName");
        this.configurePath = (String)wizardDescriptor.getProperty("configureName");
        this.configureArguments = (String)wizardDescriptor.getProperty("configureArguments");
        this.runConfigure = "true".equals(wizardDescriptor.getProperty("runConfigure"));
        this.consolidationStrategy = (String)wizardDescriptor.getProperty("consolidationLevel");
        this.sources = iterator = (Iterator)wizardDescriptor.getProperty("sourceFolders");
        this.sourceFoldersFilter = (String)wizardDescriptor.getProperty("sourceFoldersFilter");
        this.runConfigure = "true".equals(wizardDescriptor.getProperty("runConfigure"));
        this.runMake = this.runConfigure ? true : "true".equals(wizardDescriptor.getProperty("makeProject"));
        this.manualCA = "true".equals(wizardDescriptor.getProperty("manualCA"));
        this.setAsMain = Boolean.TRUE.equals(wizardDescriptor.getProperty("setAsMain"));
    }

    public Set<FileObject> create() throws IOException {
        String string;
        ArrayList<String> arrayList;
        Object object;
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        this.projectFolder = CndFileUtils.normalizeFile((File)this.projectFolder);
        MakeConfiguration makeConfiguration = new MakeConfiguration(this.projectFolder.getPath(), "Default", 0);
        String string2 = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.workingDir)) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.workingDir)) : IpeUtils.toAbsolutePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.workingDir)));
        string2 = FilePathAdaptor.normalize((String)string2);
        makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(string2);
        makeConfiguration.getMakefileConfiguration().getBuildCommand().setValue(this.buildCommand);
        makeConfiguration.getMakefileConfiguration().getCleanCommand().setValue(this.cleanCommand);
        if (this.buildResult != null && this.buildResult.length() > 0) {
            this.buildResult = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.buildResult)) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.buildResult)) : IpeUtils.toAbsolutePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.buildResult)));
            this.buildResult = FilePathAdaptor.normalize((String)this.buildResult);
            makeConfiguration.getMakefileConfiguration().getOutput().setValue(this.buildResult);
        }
        if (this.includeDirectories != null && this.includeDirectories.length() > 0) {
            object = new StringTokenizer(this.includeDirectories, ";");
            arrayList = new ArrayList();
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                string = IpeUtils.toRelativePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)string));
                string = FilePathAdaptor.normalize((String)string);
                arrayList.add(string);
            }
            makeConfiguration.getCCompilerConfiguration().getIncludeDirectories().setValue(arrayList);
            makeConfiguration.getCCCompilerConfiguration().getIncludeDirectories().setValue(new ArrayList(arrayList));
        }
        if (this.macros != null && this.macros.length() > 0) {
            object = new StringTokenizer(this.macros, "; ");
            arrayList = new ArrayList<String>();
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
            makeConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(arrayList);
            makeConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(arrayList);
        }
        object = new ArrayList();
        if (this.makefilePath != null && this.makefilePath.length() > 0) {
            this.makefileFile = CndFileUtils.normalizeFile((File)new File(this.makefilePath));
            this.makefilePath = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.makefilePath)) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.makefilePath)) : IpeUtils.toAbsolutePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.makefilePath)));
            this.makefilePath = FilePathAdaptor.normalize((String)this.makefilePath);
            ((ArrayList)object).add(this.makefilePath);
        }
        if (this.configurePath != null && this.configurePath.length() > 0) {
            this.configureFile = CndFileUtils.normalizeFile((File)new File(this.configurePath));
            this.configurePath = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.configurePath)) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.configurePath)) : IpeUtils.toAbsolutePath((String)this.projectFolder.getPath(), (String)FilePathAdaptor.naturalize((String)this.configurePath)));
            this.configurePath = FilePathAdaptor.normalize((String)this.configurePath);
            ((ArrayList)object).add(this.configurePath);
        }
        if (!(arrayList = ((ArrayList)object).iterator()).hasNext()) {
            arrayList = null;
        }
        this.makeProject = ProjectGenerator.createProject((File)this.projectFolder, (String)this.projectName, (String)this.makefileName, (MakeConfiguration[])new MakeConfiguration[]{makeConfiguration}, this.sources, (String)this.sourceFoldersFilter, arrayList);
        string = FileUtil.toFileObject((File)this.projectFolder);
        this.importResult.put(Step.Project, State.Successful);
        this.switchModel(false);
        hashSet.add((FileObject)string);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        return hashSet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("openProjects")) {
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ImportProject.this.doWork();
                }
            });
        }
    }

    boolean isProjectOpened() {
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            if (project != this.makeProject) continue;
            return true;
        }
        return false;
    }

    private void doWork() {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        configurationDescriptorProvider.getConfigurationDescriptor();
        if (configurationDescriptorProvider.gotDescriptor()) {
            if (this.configurePath != null && this.configurePath.length() > 0) {
                this.postConfigure();
            } else if (this.runMake) {
                this.makeProject(true);
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ImportProject.this.discovery(0, null);
                    }
                });
            }
        }
    }

    private File createTempFile(String string) {
        try {
            File file = File.createTempFile(string, ".log");
            file.deleteOnExit();
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void postConfigure() {
        try {
            Object object;
            if (!this.isProjectOpened()) {
                return;
            }
            FileObject fileObject = FileUtil.toFileObject((File)this.configureFile);
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            Node node = dataObject.getNodeDelegate();
            if (this.configureArguments != null) {
                object = (ShellExecSupport)node.getCookie(ShellExecSupport.class);
                try {
                    object.setArguments(new String[]{this.configureArguments});
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (this.runConfigure) {
                object = new ExecutionListener(){

                    public void executionStarted() {
                    }

                    public void executionFinished(int n) {
                        if (n == 0) {
                            ImportProject.this.importResult.put(Step.Configure, State.Successful);
                        } else {
                            ImportProject.this.importResult.put(Step.Configure, State.Fail);
                        }
                        if (ImportProject.this.runMake && n == 0) {
                            ImportProject.this.makeProject(false);
                        } else {
                            ImportProject.this.switchModel(true);
                            ImportProject.this.postModelDiscovery(true);
                        }
                    }
                };
                if (TRACE) {
                    this.logger.log(Level.INFO, "#configure " + this.configureArguments);
                }
                ShellRunAction.performAction((Node)node, (ExecutionListener)object, null, (Project)this.makeProject);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    private void makeProject(boolean bl) {
        block9: {
            if (!this.isProjectOpened()) {
                return;
            }
            if (this.makefileFile != null && this.makefileFile.exists()) {
                FileObject fileObject = FileUtil.toFileObject((File)this.makefileFile);
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    Node node = dataObject.getNodeDelegate();
                    if (bl) {
                        this.postClean(node);
                        break block9;
                    }
                    this.postMake(node);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            } else {
                String string = this.nativeProjectFolder.getAbsolutePath();
                File file = new File(string + "/Makefile");
                if (file.exists() && file.isFile() && file.canRead()) {
                    this.makefilePath = file.getAbsolutePath();
                } else {
                    file = new File(string + "/makefile");
                    if (file.exists() && file.isFile() && file.canRead()) {
                        this.makefilePath = file.getAbsolutePath();
                    }
                }
                this.switchModel(true);
                this.postModelDiscovery(true);
            }
        }
    }

    private void postClean(final Node node) {
        if (!this.isProjectOpened()) {
            return;
        }
        ExecutionListener executionListener = new ExecutionListener(){

            public void executionStarted() {
            }

            public void executionFinished(int n) {
                if (n == 0) {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Fail);
                }
                ImportProject.this.postMake(node);
            }
        };
        if (TRACE) {
            this.logger.log(Level.INFO, "#make clean");
        }
        MakeAction.execute((Node)node, (String)"clean", (ExecutionListener)executionListener, null, (Project)this.makeProject);
    }

    private void postMake(Node node) {
        if (!this.isProjectOpened()) {
            return;
        }
        final File file = this.createTempFile("make");
        ExecutionListener executionListener = new ExecutionListener(){

            public void executionStarted() {
            }

            public void executionFinished(int n) {
                if (n == 0) {
                    ImportProject.this.importResult.put(Step.Make, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.Make, State.Fail);
                }
                ImportProject.this.discovery(n, file);
            }
        };
        BufferedWriter bufferedWriter = null;
        if (file != null) {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (TRACE) {
            this.logger.log(Level.INFO, "#make > " + file.getAbsolutePath());
        }
        MakeAction.execute((Node)node, (String)"", (ExecutionListener)executionListener, (Writer)bufferedWriter, (Project)this.makeProject);
    }

    private DiscoveryProvider getProvider(String string) {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(DiscoveryProvider.class));
        for (DiscoveryProvider discoveryProvider : result.allInstances()) {
            discoveryProvider.clean();
            if (!string.equals(discoveryProvider.getID())) continue;
            return discoveryProvider;
        }
        return null;
    }

    private void waitConfigurationDescriptor() {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        configurationDescriptorProvider.getConfigurationDescriptor(true);
    }

    private void discovery(int n, File file) {
        if (!this.isProjectOpened()) {
            return;
        }
        this.waitConfigurationDescriptor();
        boolean bl = false;
        if (!this.manualCA) {
            Object object;
            HashMap<String, String> hashMap;
            IteratorExtension iteratorExtension;
            block31: {
                iteratorExtension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
                if (n == 0 && iteratorExtension != null) {
                    hashMap = new HashMap<String, String>();
                    hashMap.put("DW:rootFolder", this.nativeProjectFolder.getAbsolutePath());
                    hashMap.put("DW:consolidationLevel", this.consolidationStrategy);
                    if (iteratorExtension.canApply(hashMap, this.makeProject)) {
                        object = (DiscoveryProvider)hashMap.get("DW:provider");
                        if (object != null && "make-log".equals(object.getID())) {
                            if (TRACE) {
                                this.logger.log(Level.INFO, "#start discovery by log file " + object.getProperty("make-log-file").getValue());
                            }
                        } else if (TRACE) {
                            this.logger.log(Level.INFO, "#start discovery by object files");
                        }
                        try {
                            bl = true;
                            iteratorExtension.apply(hashMap, this.makeProject);
                            if (object != null && "make-log".equals(object.getID())) {
                                this.importResult.put(Step.DiscoveryLog, State.Successful);
                                break block31;
                            }
                            this.importResult.put(Step.DiscoveryDwarf, State.Successful);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else if (TRACE) {
                        this.logger.log(Level.INFO, "#no dwarf information found in object files");
                    }
                }
            }
            if (!bl && file != null) {
                if (iteratorExtension != null) {
                    hashMap = new HashMap();
                    hashMap.put("DW:rootFolder", this.nativeProjectFolder.getAbsolutePath());
                    hashMap.put("DW:logFile", file.getAbsolutePath());
                    hashMap.put("DW:consolidationLevel", this.consolidationStrategy);
                    if (iteratorExtension.canApply(hashMap, this.makeProject)) {
                        if (TRACE) {
                            this.logger.log(Level.INFO, "#start discovery by log file " + file.getAbsolutePath());
                        }
                        try {
                            bl = true;
                            iteratorExtension.apply(hashMap, this.makeProject);
                            this.importResult.put(Step.DiscoveryLog, State.Successful);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else if (TRACE) {
                        this.logger.log(Level.INFO, "#discovery cannot be done by log file " + file.getAbsolutePath());
                    }
                }
            } else if (bl && file != null) {
                if (!this.isProjectOpened()) {
                    return;
                }
                if (iteratorExtension != null) {
                    hashMap = new HashMap();
                    hashMap.put("DW:rootFolder", this.nativeProjectFolder.getAbsolutePath());
                    hashMap.put("DW:logFile", file.getAbsolutePath());
                    hashMap.put("DW:consolidationLevel", this.consolidationStrategy);
                    if (iteratorExtension.canApply(hashMap, this.makeProject)) {
                        if (TRACE) {
                            this.logger.log(Level.INFO, "#start fix macros by log file " + file.getAbsolutePath());
                        }
                        object = (List)hashMap.get("DW:configurations");
                        this.fixMacros((List<ProjectConfiguration>)object);
                        this.importResult.put(Step.FixMacros, State.Successful);
                    } else if (TRACE) {
                        this.logger.log(Level.INFO, "#fix macros cannot be done by log file " + file.getAbsolutePath());
                    }
                }
            }
        }
        this.switchModel(true);
        if (!bl) {
            this.postModelDiscovery(true);
        } else {
            this.postModelDiscovery(false);
        }
    }

    private void fixMacros(List<ProjectConfiguration> list) {
        for (ProjectConfiguration projectConfiguration : list) {
            List<FileConfiguration> list2 = projectConfiguration.getFiles();
            for (FileConfiguration fileConfiguration : list2) {
                Item item;
                if (fileConfiguration.getUserMacros().size() <= 0 || !((item = this.findByNormalizedName(new File(fileConfiguration.getFilePath()))) instanceof Item)) continue;
                if (TRACE) {
                    this.logger.log(Level.FINE, "#fix macros for file " + fileConfiguration.getFilePath());
                }
                ProjectBridge.fixFileMacros(fileConfiguration.getUserMacros(), item);
            }
        }
        this.saveMakeConfigurationDescriptor();
    }

    private void saveMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        final MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        makeConfigurationDescriptor.setModified();
        makeConfigurationDescriptor.save();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                makeConfigurationDescriptor.checkForChangedItems(ImportProject.this.makeProject, null, null);
                if (TRACE) {
                    ImportProject.this.logger.log(Level.INFO, "#save configuration descriptor");
                }
            }
        });
    }

    private void postModelDiscovery(final boolean bl) {
        if (!this.isProjectOpened()) {
            return;
        }
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel instanceof ModelImpl && this.makeProject != null) {
            final NativeProject nativeProject = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            final CsmProject csmProject = csmModel.getProject((Object)nativeProject);
            if (csmProject == null && TRACE) {
                this.logger.log(Level.INFO, "#discovery cannot be done by model");
            }
            CsmProgressAdapter csmProgressAdapter = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject csmProject2) {
                    if (csmProject2.equals(csmProject)) {
                        listeners.remove(csmProject);
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        if (TRACE) {
                            ImportProject.this.logger.log(Level.INFO, "#start discovery by model");
                        }
                        if (bl) {
                            ImportProject.this.modelDiscovery();
                        } else {
                            ImportProject.this.fixExcludedHeaderFiles();
                        }
                        ImportProject.this.showFollwUp(nativeProject);
                    }
                }
            };
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)csmProgressAdapter);
            listeners.put(csmProject, (CsmProgressListener)csmProgressAdapter);
        }
    }

    private void showFollwUp(final NativeProject nativeProject) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FollowUp.showFollowUp(ImportProject.this, nativeProject);
            }
        });
    }

    Project getMakeProject() {
        return this.makeProject;
    }

    Map<Step, State> getImportResult() {
        return this.importResult;
    }

    private void fixExcludedHeaderFiles() {
        NativeProject nativeProject;
        CsmProject csmProject;
        if (!this.isProjectOpened()) {
            return;
        }
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel instanceof ModelImpl && this.makeProject != null && (csmProject = csmModel.getProject((Object)(nativeProject = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class)))) != null && nativeProject != null) {
            if (TRACE) {
                this.logger.log(Level.INFO, "#start fixing excluded header files by model");
            }
            HashSet<String> hashSet = new HashSet<String>();
            Object object = csmProject.getAllFiles().iterator();
            while (object.hasNext()) {
                CsmFile csmFile = (CsmFile)object.next();
                if (!(csmFile instanceof FileImpl)) continue;
                FileImpl fileImpl = (FileImpl)csmFile;
                NativeFileItem nativeFileItem = fileImpl.getNativeFileItem();
                if (nativeFileItem == null) {
                    nativeFileItem = this.findByNormalizedName(fileImpl.getFile());
                }
                if (nativeFileItem == null || !nativeProject.equals(nativeFileItem.getNativeProject()) || !nativeFileItem.isExcluded() || !(nativeFileItem instanceof Item)) continue;
                if (TRACE) {
                    this.logger.log(Level.FINE, "#fix excluded header for file " + fileImpl.getAbsolutePath());
                }
                ProjectBridge.setExclude((Item)nativeFileItem, false);
                if (!csmFile.isHeaderFile()) continue;
                hashSet.add(nativeFileItem.getFile().getAbsolutePath());
            }
            if (hashSet.size() > 0 && ((ProjectBridge)(object = new ProjectBridge(this.makeProject))).isValid()) {
                ((ProjectBridge)object).checkForNewExtensions(hashSet);
            }
            this.saveMakeConfigurationDescriptor();
            this.importResult.put(Step.FixExcluded, State.Successful);
        }
    }

    private Item findByNormalizedName(File file) {
        String string;
        if (this.normalizedItems == null) {
            MakeConfigurationDescriptor makeConfigurationDescriptor;
            this.normalizedItems = new HashMap<String, Item>();
            string = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (string != null && (makeConfigurationDescriptor = string.getConfigurationDescriptor()) != null) {
                for (Item item : makeConfigurationDescriptor.getProjectItems()) {
                    this.normalizedItems.put(item.getNormalizedFile().getAbsolutePath(), item);
                }
            }
        }
        string = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
        return this.normalizedItems.get(string);
    }

    private void modelDiscovery() {
        Object object;
        if (!this.isProjectOpened()) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("DW:rootFolder", this.nativeProjectFolder.getAbsolutePath());
        hashMap.put("DW:invokeProvider", Boolean.TRUE);
        hashMap.put("DW:consolidationLevel", this.consolidationStrategy);
        boolean bl = false;
        if (!this.manualCA && (object = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class)) != null) {
            if (object.canApply(hashMap, this.makeProject)) {
                if (TRACE) {
                    this.logger.log(Level.INFO, "#start discovery by object files");
                }
                try {
                    object.apply(hashMap, this.makeProject);
                    this.importResult.put(Step.DiscoveryDwarf, State.Successful);
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (TRACE) {
                this.logger.log(Level.INFO, "#no dwarf information found in object files");
            }
        }
        if (!bl) {
            if (TRACE) {
                this.logger.log(Level.INFO, "#start discovery by model");
            }
            hashMap.put("DW:rootFolder", this.nativeProjectFolder.getAbsolutePath());
            object = this.getProvider("model-folder");
            object.getProperty("folder").setValue(this.nativeProjectFolder.getAbsolutePath());
            if (this.manualCA) {
                object.getProperty("prefer-local").setValue(Boolean.TRUE);
            }
            hashMap.put("DW:provider", object);
            hashMap.put("DW:invokeProvider", Boolean.TRUE);
            DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(hashMap);
            discoveryDescriptor.setProject(this.makeProject);
            SelectConfigurationPanel.buildModel(discoveryDescriptor);
            try {
                DiscoveryProjectGenerator discoveryProjectGenerator = new DiscoveryProjectGenerator(discoveryDescriptor);
                discoveryProjectGenerator.makeProject();
                this.importResult.put(Step.DiscoveryModel, State.Successful);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void switchModel(boolean bl) {
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel instanceof ModelImpl && this.makeProject != null) {
            NativeProject nativeProject = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            if (bl) {
                if (TRACE) {
                    this.logger.log(Level.INFO, "#enable model for " + nativeProject.getProjectDisplayName());
                }
                ((ModelImpl)csmModel).enableProject(nativeProject);
            } else {
                if (TRACE) {
                    this.logger.log(Level.INFO, "#disable model for " + nativeProject.getProjectDisplayName());
                }
                ((ModelImpl)csmModel).disableProject(nativeProject);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Step {
        Project,
        Configure,
        MakeClean,
        Make,
        DiscoveryDwarf,
        DiscoveryLog,
        FixMacros,
        DiscoveryModel,
        FixExcluded;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        Successful,
        Fail,
        Skiped;

    }
}

