/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.openide.util.Lookup;

public abstract class PkgConfigManager {
    private static PkgConfigManager DEFAULT = new Default();

    public abstract PkgConfig getPkgConfig(Project var1);

    protected PkgConfigManager() {
    }

    public static synchronized PkgConfigManager getDefault() {
        return DEFAULT;
    }

    private static final class Default
    extends PkgConfigManager {
        private final Lookup.Result<PkgConfigManager> res = Lookup.getDefault().lookupResult(PkgConfigManager.class);
        private static final boolean FIX_SERVICE = true;
        private PkgConfigManager fixedSelector;

        Default() {
        }

        private PkgConfigManager getService() {
            PkgConfigManager pkgConfigManager = this.fixedSelector;
            if (pkgConfigManager == null) {
                Iterator iterator = this.res.allInstances().iterator();
                if (iterator.hasNext()) {
                    PkgConfigManager pkgConfigManager2;
                    pkgConfigManager = pkgConfigManager2 = (PkgConfigManager)iterator.next();
                }
                if (pkgConfigManager != null) {
                    this.fixedSelector = pkgConfigManager;
                }
            }
            return pkgConfigManager;
        }

        public PkgConfig getPkgConfig(Project project) {
            PkgConfigManager pkgConfigManager = this.getService();
            if (pkgConfigManager != null) {
                return pkgConfigManager.getPkgConfig(project);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResolvedPath {
        public String getIncludePath();

        public Collection<PackageConfiguration> getPackages();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PackageConfiguration {
        public String getName();

        public Collection<String> getIncludePaths();

        public Collection<String> getMacros();
    }

    public static interface PkgConfig {
        public PackageConfiguration getPkgConfig(String var1);

        public ResolvedPath getResolvedPath(String var1);
    }
}

