/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rubyforge.debugcommons.ClassicDebuggerCommandFactory;
import org.rubyforge.debugcommons.ICommandFactory;
import org.rubyforge.debugcommons.ReadersSupport;
import org.rubyforge.debugcommons.RubyDebugCommandFactory;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.ExceptionSuspensionPoint;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.IRubyExceptionBreakpoint;
import org.rubyforge.debugcommons.model.IRubyLineBreakpoint;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyVariable;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebuggerProxy {
    private static final Logger LOGGER = Logger.getLogger(RubyDebuggerProxy.class.getName());
    public static final DebuggerType CLASSIC_DEBUGGER = DebuggerType.CLASSIC_DEBUGGER;
    public static final DebuggerType RUBY_DEBUG = DebuggerType.RUBY_DEBUG;
    public static final List<RubyDebuggerProxy> PROXIES = new CopyOnWriteArrayList<RubyDebuggerProxy>();
    private final List<RubyDebugEventListener> listeners;
    private final Map<Integer, IRubyLineBreakpoint> breakpointsIDs;
    private final int timeout;
    private final DebuggerType debuggerType;
    private RubyDebugTarget debugTarget;
    private Socket commandSocket;
    private boolean finished;
    private PrintWriter commandWriter;
    private ICommandFactory commandFactory;
    private ReadersSupport readersSupport;
    private boolean supportsCondition;
    private Set<String> removedCatchpoints;

    public RubyDebuggerProxy(DebuggerType debuggerType) {
        this(debuggerType, 10);
    }

    public RubyDebuggerProxy(DebuggerType debuggerType, int timeout) {
        this.debuggerType = debuggerType;
        this.listeners = new CopyOnWriteArrayList<RubyDebugEventListener>();
        this.breakpointsIDs = new HashMap<Integer, IRubyLineBreakpoint>();
        this.removedCatchpoints = new HashSet<String>();
        this.timeout = timeout;
        this.readersSupport = new ReadersSupport(timeout);
    }

    public void setDebugTarget(RubyDebugTarget debugTarget) throws IOException, RubyDebuggerException {
        this.debugTarget = debugTarget;
        LOGGER.fine("Proxy target: " + debugTarget);
    }

    public RubyDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    ReadersSupport getReadersSupport() {
        return this.readersSupport;
    }

    public void attach(IRubyBreakpoint[] initialBreakpoints) throws RubyDebuggerException {
        try {
            switch (this.debuggerType) {
                case CLASSIC_DEBUGGER: {
                    this.attachToClassicDebugger(initialBreakpoints);
                    break;
                }
                case RUBY_DEBUG: {
                    this.attachToRubyDebug(initialBreakpoints);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled debugger type: " + (Object)((Object)this.debuggerType));
                }
            }
        }
        catch (RubyDebuggerException e) {
            PROXIES.remove(this);
            throw e;
        }
        this.startSuspensionReaderLoop();
    }

    public synchronized boolean isReady() {
        return !this.finished && this.commandWriter != null && this.debugTarget.isAvailable();
    }

    private synchronized void attachToClassicDebugger(IRubyBreakpoint[] initialBreakpoints) throws RubyDebuggerException {
        try {
            this.commandFactory = new ClassicDebuggerCommandFactory();
            this.readersSupport.startCommandLoop(this.getCommandSocket().getInputStream());
            this.commandWriter = new PrintWriter(this.getCommandSocket().getOutputStream(), true);
            this.setBreakpoints(initialBreakpoints);
            this.sendCommand("cont");
        }
        catch (IOException ex) {
            throw new RubyDebuggerException(ex);
        }
    }

    private synchronized void attachToRubyDebug(IRubyBreakpoint[] initialBreakpoints) throws RubyDebuggerException {
        try {
            this.commandFactory = new RubyDebugCommandFactory();
            this.readersSupport.startCommandLoop(this.getCommandSocket().getInputStream());
            this.commandWriter = new PrintWriter(this.getCommandSocket().getOutputStream(), true);
            this.setBreakpoints(initialBreakpoints);
            this.sendCommand("start");
        }
        catch (IOException ex) {
            throw new RubyDebuggerException(ex);
        }
    }

    public void fireDebugEvent(RubyDebugEvent e) {
        for (RubyDebugEventListener listener : this.listeners) {
            listener.onDebugEvent(e);
        }
    }

    public void addRubyDebugEventListener(RubyDebugEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeRubyDebugEventListener(RubyDebugEventListener listener) {
        this.listeners.remove(listener);
    }

    private PrintWriter getCommandWriter() throws RubyDebuggerException {
        assert (this.commandWriter != null) : "Proxy has to be started, before using the writer";
        return this.commandWriter;
    }

    protected void setBreakpoints(IRubyBreakpoint[] breakpoints) throws RubyDebuggerException {
        for (IRubyBreakpoint breakpoint : breakpoints) {
            this.addBreakpoint(breakpoint);
        }
    }

    public synchronized void addBreakpoint(IRubyBreakpoint breakpoint) {
        block11: {
            LOGGER.fine("Adding breakpoint: " + breakpoint);
            if (!this.isReady()) {
                LOGGER.fine("Session and/or debuggee is not ready, skipping addition of breakpoint: " + breakpoint);
                return;
            }
            assert (breakpoint != null) : "breakpoint cannot be null";
            if (breakpoint.isEnabled()) {
                try {
                    if (breakpoint instanceof IRubyLineBreakpoint) {
                        IRubyLineBreakpoint lineBreakpoint = (IRubyLineBreakpoint)breakpoint;
                        String command = this.commandFactory.createAddBreakpoint(lineBreakpoint.getFilePath(), lineBreakpoint.getLineNumber());
                        this.sendCommand(command);
                        Integer id = this.getReadersSupport().readAddedBreakpointNo();
                        String condition = lineBreakpoint.getCondition();
                        if (condition != null && this.supportsCondition) {
                            command = this.commandFactory.createSetCondition(id, condition);
                            if (command != null) {
                                this.sendCommand(command);
                                this.getReadersSupport().readConditionSet();
                            } else {
                                LOGGER.info("conditional breakpoints are not supported by backend");
                            }
                        }
                        this.breakpointsIDs.put(id, lineBreakpoint);
                        break block11;
                    }
                    if (breakpoint instanceof IRubyExceptionBreakpoint) {
                        IRubyExceptionBreakpoint excBreakpoint = (IRubyExceptionBreakpoint)breakpoint;
                        if (!this.removedCatchpoints.remove(excBreakpoint.getException())) {
                            String command = this.commandFactory.createCatchOn(excBreakpoint);
                            this.sendCommand(command);
                            this.getReadersSupport().readCatchpointSet();
                        }
                        break block11;
                    }
                    throw new IllegalArgumentException("Unknown breakpoint type: " + breakpoint);
                }
                catch (RubyDebuggerException ex) {
                    if (!this.isReady()) break block11;
                    LOGGER.log(Level.WARNING, "Cannot add breakpoint to: " + this.getDebugTarget(), ex);
                }
            }
        }
    }

    public synchronized void removeBreakpoint(IRubyBreakpoint breakpoint) {
        this.removeBreakpoint(breakpoint, false);
    }

    public synchronized void removeBreakpoint(IRubyBreakpoint breakpoint, boolean silent) {
        LOGGER.fine("Removing breakpoint: " + breakpoint);
        if (!this.isReady()) {
            LOGGER.fine("Session and/or debuggee is not ready, skipping removing of breakpoint: " + breakpoint);
            return;
        }
        if (breakpoint instanceof IRubyLineBreakpoint) {
            IRubyLineBreakpoint lineBreakpoint = (IRubyLineBreakpoint)breakpoint;
            Integer id = this.findBreakpointId(lineBreakpoint);
            if (id != null) {
                String command = this.commandFactory.createRemoveBreakpoint(id);
                try {
                    this.sendCommand(command);
                    this.getReadersSupport().waitForRemovedBreakpoint(id);
                    this.breakpointsIDs.remove(id);
                    LOGGER.fine("Breakpoint " + breakpoint + " with id " + id + " successfully removed");
                }
                catch (RubyDebuggerException e) {
                    LOGGER.log(Level.SEVERE, "Exception during removing breakpoint.", e);
                }
            } else if (!silent) {
                LOGGER.fine("Breakpoint [" + breakpoint + "] cannot be removed since " + "its ID cannot be found. Might have been already removed.");
            }
        } else if (breakpoint instanceof IRubyExceptionBreakpoint) {
            IRubyExceptionBreakpoint catchpoint = (IRubyExceptionBreakpoint)breakpoint;
            this.removedCatchpoints.add(catchpoint.getException());
        } else {
            throw new IllegalArgumentException("Unknown breakpoint type: " + breakpoint);
        }
    }

    public void updateBreakpoint(IRubyBreakpoint breakpoint) throws RubyDebuggerException {
        this.removeBreakpoint(breakpoint, true);
        this.addBreakpoint(breakpoint);
    }

    private synchronized Integer findBreakpointId(IRubyLineBreakpoint wantedBP) {
        for (Map.Entry<Integer, IRubyLineBreakpoint> breakpointID : this.breakpointsIDs.entrySet()) {
            IRubyLineBreakpoint bp = breakpointID.getValue();
            int id = breakpointID.getKey();
            if (!wantedBP.getFilePath().equals(bp.getFilePath()) || wantedBP.getLineNumber() != bp.getLineNumber()) continue;
            return id;
        }
        return null;
    }

    private void startSuspensionReaderLoop() {
        new SuspensionReaderLoop().start();
    }

    public Socket getCommandSocket() throws RubyDebuggerException {
        if (this.commandSocket == null) {
            this.commandSocket = this.attach();
        }
        return this.commandSocket;
    }

    public void resume(RubyThread thread) {
        try {
            this.sendCommand(this.commandFactory.createResume(thread));
        }
        catch (RubyDebuggerException e) {
            LOGGER.log(Level.SEVERE, "resuming of " + thread.getId() + " failed", e);
        }
    }

    private void sendCommand(String s) throws RubyDebuggerException {
        LOGGER.fine("Sending command debugger: " + s);
        if (!this.isReady()) {
            throw new RubyDebuggerException("Trying to send a command [" + s + "] to non-started or finished proxy (debuggee: " + this.getDebugTarget() + ", output: \n\n" + Util.dumpAndDestroyProcess(this.debugTarget));
        }
        this.getCommandWriter().println(s);
    }

    public void sendStepOver(RubyFrame frame, boolean forceNewLine) {
        try {
            if (forceNewLine) {
                this.sendCommand(this.commandFactory.createForcedStepOver(frame));
            } else {
                this.sendCommand(this.commandFactory.createStepOver(frame));
            }
        }
        catch (RubyDebuggerException e) {
            LOGGER.log(Level.SEVERE, "Stepping failed", e);
        }
    }

    public void sendStepReturnEnd(RubyFrame frame) {
        try {
            this.sendCommand(this.commandFactory.createStepReturn(frame));
        }
        catch (RubyDebuggerException e) {
            LOGGER.log(Level.SEVERE, "Stepping failed", e);
        }
    }

    public void sendStepIntoEnd(RubyFrame frame, boolean forceNewLine) {
        try {
            if (forceNewLine) {
                this.sendCommand(this.commandFactory.createForcedStepInto(frame));
            } else {
                this.sendCommand(this.commandFactory.createStepInto(frame));
            }
        }
        catch (RubyDebuggerException e) {
            LOGGER.log(Level.SEVERE, "Stepping failed", e);
        }
    }

    public RubyThreadInfo[] readThreadInfo() throws RubyDebuggerException {
        this.sendCommand(this.commandFactory.createReadThreads());
        return this.getReadersSupport().readThreads();
    }

    public RubyFrame[] readFrames(RubyThread thread) throws RubyDebuggerException {
        RubyFrameInfo[] infos;
        try {
            this.sendCommand(this.commandFactory.createReadFrames(thread));
            infos = this.getReadersSupport().readFrames();
        }
        catch (RubyDebuggerException e) {
            if (this.isReady()) {
                throw e;
            }
            LOGGER.fine("Session and/or debuggee is not ready, returning empty thread list.");
            infos = new RubyFrameInfo[]{};
        }
        RubyFrame[] frames = new RubyFrame[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyFrameInfo info = infos[i];
            frames[i] = new RubyFrame(thread, info);
        }
        return frames;
    }

    public RubyVariable[] readVariables(RubyFrame frame) throws RubyDebuggerException {
        this.sendCommand(this.commandFactory.createReadLocalVariables(frame));
        RubyVariableInfo[] infos = this.getReadersSupport().readVariables();
        RubyVariable[] variables = new RubyVariable[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyVariableInfo info = infos[i];
            variables[i] = new RubyVariable(info, frame);
        }
        return variables;
    }

    public RubyVariable[] readInstanceVariables(RubyVariable variable) throws RubyDebuggerException {
        this.sendCommand(this.commandFactory.createReadInstanceVariable(variable));
        RubyVariableInfo[] infos = this.getReadersSupport().readVariables();
        RubyVariable[] variables = new RubyVariable[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyVariableInfo info = infos[i];
            variables[i] = new RubyVariable(info, variable);
        }
        return variables;
    }

    public RubyVariable[] readGlobalVariables() throws RubyDebuggerException {
        this.sendCommand(this.commandFactory.createReadGlobalVariables());
        RubyVariableInfo[] infos = this.getReadersSupport().readVariables();
        RubyVariable[] variables = new RubyVariable[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyVariableInfo info = infos[i];
            variables[i] = new RubyVariable(this, info);
        }
        return variables;
    }

    public RubyVariable inspectExpression(RubyFrame frame, String expression) throws RubyDebuggerException {
        expression = expression.replaceAll("\n", "\\\\n");
        this.sendCommand(this.commandFactory.createInspect(frame, expression));
        RubyVariableInfo[] infos = this.getReadersSupport().readVariables();
        return infos.length == 0 ? null : new RubyVariable(infos[0], frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(boolean forced) {
        RubyDebuggerProxy rubyDebuggerProxy = this;
        synchronized (rubyDebuggerProxy) {
            if (this.finished) {
                LOGGER.fine("Trying to finish the same proxy more than once: " + this);
                return;
            }
            if (this.getDebugTarget().isRemote()) {
                this.sendExit();
            }
            PROXIES.remove(this);
            if (forced) {
                this.sendExit();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.INFO, "Interrupted during IO readers waiting", e);
                }
                RubyDebugTarget target = this.getDebugTarget();
                if (!target.isRemote()) {
                    LOGGER.fine("Destroying process: " + target);
                    target.getProcess().destroy();
                }
            }
            this.finished = true;
        }
        this.fireDebugEvent(RubyDebugEvent.createTerminateEvent());
    }

    private synchronized void sendExit() {
        block3: {
            if (this.commandSocket != null && this.debugTarget.isAvailable()) {
                try {
                    this.sendCommand("exit");
                }
                catch (RubyDebuggerException ex) {
                    LOGGER.fine("'exit' command failed. Remote process? -> " + this.debugTarget.isRemote());
                    if (this.debugTarget.isRemote()) break block3;
                    LOGGER.fine("'exit' command failed. Process running? -> " + this.debugTarget.isRunning());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket attach() throws RubyDebuggerException {
        int port = this.debugTarget.getPort();
        String host = this.debugTarget.getHost();
        Socket socket = null;
        int tryCount = this.timeout * 2;
        for (int i = 0; i < tryCount && socket == null; ++i) {
            try {
                socket = new Socket(host, port);
                LOGGER.finest("Successfully attached to " + host + ':' + port);
                continue;
            }
            catch (ConnectException e) {
                RubyDebuggerProxy rubyDebuggerProxy = this;
                synchronized (rubyDebuggerProxy) {
                    if (this.finished) {
                        throw new RubyDebuggerException("Process was terminated before debugger connection was established.");
                    }
                    if (i == tryCount - 1) {
                        this.failWithInfo(e);
                    }
                }
                try {
                    if (this.debugTarget.isAvailable()) {
                        LOGGER.finest("Cannot connect to " + host + ':' + port + ". Trying again...(" + (tryCount - i - 1) + ')');
                        Thread.sleep(500L);
                        continue;
                    }
                    this.failWithInfo(e);
                }
                catch (InterruptedException e1) {
                    LOGGER.log(Level.SEVERE, "Interrupted during attaching.", e1);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (IOException e) {
                throw new RubyDebuggerException(e);
            }
        }
        return socket;
    }

    private void failWithInfo(ConnectException e) throws RubyDebuggerException {
        String info = this.debugTarget.isRemote() ? "[Remote Process at " + this.debugTarget.getHost() + ':' + this.debugTarget.getPort() + "]" : Util.dumpAndDestroyProcess(this.debugTarget);
        throw new RubyDebuggerException("Cannot connect to the debugged process at port " + this.debugTarget.getPort() + " in " + this.timeout + "s:\n\n" + info, e);
    }

    void setConditionSupport(boolean supportsCondition) {
        this.supportsCondition = supportsCondition;
    }

    private class SuspensionReaderLoop
    extends Thread {
        SuspensionReaderLoop() {
            this.setName("RubyDebuggerLoop [" + System.currentTimeMillis() + ']');
        }

        public void suspensionOccurred(final SuspensionPoint hit) {
            new Thread(){

                public void run() {
                    RubyDebuggerProxy.this.debugTarget.suspensionOccurred(hit);
                }
            }.start();
        }

        public void run() {
            SuspensionPoint sp;
            LOGGER.finest("Waiting for breakpoints.");
            while ((sp = RubyDebuggerProxy.this.getReadersSupport().readSuspension()) != SuspensionPoint.END) {
                LOGGER.finest(sp.toString());
                if (sp.isException()) {
                    RubyThread thread;
                    ExceptionSuspensionPoint exceptionSP = (ExceptionSuspensionPoint)sp;
                    if (RubyDebuggerProxy.this.removedCatchpoints.contains(exceptionSP.getExceptionType()) && (thread = RubyDebuggerProxy.this.getDebugTarget().getThreadById(sp.getThreadId())) != null) {
                        RubyDebuggerProxy.this.resume(thread);
                        continue;
                    }
                }
                if (!RubyDebuggerProxy.this.isReady()) {
                    LOGGER.info("Session and/or debuggee is not ready, ignoring backend event - suspension point: " + sp);
                    continue;
                }
                this.suspensionOccurred(sp);
            }
            boolean unexpectedFail = RubyDebuggerProxy.this.getReadersSupport().isUnexpectedFail();
            if (unexpectedFail) {
                LOGGER.warning("Unexpected fail. Debuggee: " + RubyDebuggerProxy.this.getDebugTarget() + ", output: \n\n" + Util.dumpAndDestroyProcess(RubyDebuggerProxy.this.debugTarget));
            }
            RubyDebuggerProxy.this.finish(unexpectedFail);
            LOGGER.finest("Socket reader loop finished.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebuggerType {
        CLASSIC_DEBUGGER,
        RUBY_DEBUG;

    }
}

