/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandSameLineDef
extends RubyAstRule {
    public boolean appliesTo(RuleContext ruleContext) {
        ParserResult parserResult = ruleContext.parserResult;
        return RubyUtils.getFileObject((Parser.Result)parserResult).getMIMEType().equals("text/x-ruby");
    }

    @Override
    public Set<NodeType> getKinds() {
        HashSet<NodeType> hashSet = new HashSet<NodeType>();
        hashSet.add(NodeType.CLASSNODE);
        hashSet.add(NodeType.DEFNNODE);
        hashSet.add(NodeType.DEFSNODE);
        return hashSet;
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        Node node = rubyRuleContext.node;
        AstPath astPath = rubyRuleContext.path;
        ParserResult parserResult = rubyRuleContext.parserResult;
        BaseDocument baseDocument = rubyRuleContext.doc;
        if (node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE || node.getNodeType() == NodeType.CLASSNODE) {
            SourcePosition sourcePosition = node.getPosition();
            try {
                if (baseDocument == null) {
                    return;
                }
                int n = sourcePosition.getStartOffset();
                int n2 = sourcePosition.getEndOffset();
                int n3 = baseDocument.getLength();
                if (Utilities.getRowEnd((BaseDocument)baseDocument, (int)Math.min(n, n3)) == Utilities.getRowEnd((BaseDocument)baseDocument, (int)Math.min(n2, n3))) {
                    Node node2 = AstUtilities.getRoot((Parser.Result)parserResult);
                    if (astPath.leaf() != node) {
                        astPath = new AstPath(node2, node);
                    }
                    List<ExpandLineFix> list2 = Collections.singletonList(new ExpandLineFix(rubyRuleContext, astPath));
                    OffsetRange offsetRange = new OffsetRange(sourcePosition.getStartOffset(), sourcePosition.getEndOffset());
                    Hint hint = new Hint((Rule)this, this.getDisplayName(), RubyUtils.getFileObject((Parser.Result)parserResult), offsetRange, list2, 150);
                    list.add(hint);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    public void cancel() {
    }

    public String getId() {
        return "Expand_Same_Line_Def";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ExpandSameLineDef.class, (String)"ExpandLine");
    }

    public String getDescription() {
        return NbBundle.getMessage(ExpandSameLineDef.class, (String)"ExpandLineDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    public boolean showInTasklist() {
        return false;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpandLineFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final AstPath path;

        ExpandLineFix(RubyRuleContext rubyRuleContext, AstPath astPath) {
            this.context = rubyRuleContext;
            this.path = astPath;
        }

        public String getDescription() {
            String string = this.path.leaf().getNodeType() == NodeType.DEFNNODE ? "def" : "class";
            return NbBundle.getMessage(ExpandSameLineDef.class, (String)"ExpandLineFix", (Object)string);
        }

        private void findLineBreaks(Node node, Set<Integer> set) {
            if (node.getNodeType() == NodeType.NEWLINENODE) {
                set.add(node.getPosition().getStartOffset());
            }
            List list = node.childNodes();
            for (Node node2 : list) {
                if (node2.isInvisible()) continue;
                this.findLineBreaks(node2, set);
            }
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            EditList editList;
            Token token;
            BaseDocument baseDocument = this.context.doc;
            SourcePosition sourcePosition = this.path.leaf().getPosition();
            int n = sourcePosition.getStartOffset();
            int n2 = sourcePosition.getEndOffset();
            if (n2 > baseDocument.getLength()) {
                if (n > baseDocument.getLength()) {
                    n = baseDocument.getLength();
                }
                n2 = baseDocument.getLength();
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            this.findLineBreaks(this.path.leaf(), hashSet);
            TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence((BaseDocument)baseDocument, (int)n2);
            if (tokenSequence != null) {
                tokenSequence.move(n2);
                while (tokenSequence.movePrevious() && tokenSequence.offset() > n) {
                    token = tokenSequence.token();
                    editList = token.id();
                    if (editList == RubyTokenId.IDENTIFIER && ";".equals(((Object)token.text()).toString())) {
                        hashSet.add(tokenSequence.offset());
                        continue;
                    }
                    if (editList != RubyTokenId.CLASS && editList != RubyTokenId.DEF && editList != RubyTokenId.END) continue;
                    hashSet.add(tokenSequence.offset());
                }
            }
            token = new ArrayList(hashSet);
            Collections.sort(token);
            Collections.reverse(token);
            editList = new EditList(baseDocument);
            if (token.size() > 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                try {
                    int n3 = -1;
                    Iterator iterator = token.iterator();
                    while (iterator.hasNext()) {
                        int n4 = (Integer)iterator.next();
                        if (n4 == n3) continue;
                        n3 = n4;
                        if (";".equals(baseDocument.getText(n4, 1))) {
                            editList.replace(n4, 1, null, false, 1);
                            if (arrayList.contains(n4 + 2)) continue;
                        }
                        if (arrayList.contains(n4 + 1) || arrayList.contains(n4)) continue;
                        editList.replace(n4, 0, "\n", false, 2);
                        arrayList.add(n4);
                    }
                    editList.setFormatAll(true);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            return editList;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

