/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalBindingTablePanel
extends DefaultTablePanel {
    private static final String[] columnName = new String[]{NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"TITLE_CUSTOMIZATION_FILES")};
    private EBTableModel model;
    private String previousDirectory = "";
    private static final FileFilter XML_FILE_FILTER = new XmlFileFilter();
    private Node node;
    private Map<String, FileObject> addedBindings;
    private RemoveActionListener removeActionListener;
    private AddActionListener addActionListener;

    public ExternalBindingTablePanel(EBTableModel eBTableModel, Node node) {
        super((AbstractTableModel)eBTableModel);
        this.getTable().getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"TITLE_CUSTOMIZATION_FILES"));
        this.getTable().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"TITLE_CUSTOMIZATION_FILES"));
        this.model = eBTableModel;
        this.node = node;
        this.editButton.setVisible(false);
        this.addedBindings = new HashMap<String, FileObject>();
        this.addActionListener = new AddActionListener();
        ActionListener actionListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.addActionListener, (Object)this.addButton);
        this.addButton.addActionListener(actionListener);
        this.removeActionListener = new RemoveActionListener();
        ActionListener actionListener2 = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.removeActionListener, (Object)this.removeButton);
        this.removeButton.addActionListener(actionListener2);
    }

    public String getRelativePathToWsdl() {
        String string = "";
        FileObject fileObject = (FileObject)this.node.getLookup().lookup(FileObject.class);
        FileObject fileObject2 = null;
        FileObject fileObject3 = null;
        Client client = (Client)this.node.getLookup().lookup(Client.class);
        if (client != null) {
            JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)fileObject);
            fileObject3 = jAXWSClientSupport.getLocalWsdlFolderForClient(client.getName(), false);
            fileObject2 = fileObject3.getFileObject(client.getLocalWsdlFile());
        } else {
            JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
            Service service = (Service)this.node.getLookup().lookup(Service.class);
            fileObject3 = jAXWSSupport.getLocalWsdlFolderForService(service.getName(), false);
            fileObject2 = fileObject3.getFileObject(service.getLocalWsdlFile());
        }
        try {
            string = Utilities.relativize((URI)FileUtil.toFile((FileObject)fileObject3).toURI(), (URI)new URI(fileObject2.getURL().toExternalForm()));
        }
        catch (Exception exception) {
            return "Unable to obtain relative path";
        }
        return "../wsdl/" + string;
    }

    public Map<String, FileObject> getAddedBindings() {
        return this.addedBindings;
    }

    public Set<String> getRemovedBindings() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        Binding[] bindingArray = null;
        Client client = (Client)this.node.getLookup().lookup(Client.class);
        if (client != null) {
            bindingArray = client.getBindings();
        } else {
            object = (Service)this.node.getLookup().lookup(Service.class);
            if (object != null) {
                bindingArray = object.getBindings();
            }
        }
        if (bindingArray == null) {
            return Collections.emptySet();
        }
        object = this.model.getChildren();
        for (int i = 0; i < bindingArray.length; ++i) {
            String string = bindingArray[i].getFileName();
            boolean bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public List getChildren() {
        return this.model.getChildren();
    }

    void populateModel() {
        this.model.setData(this.node);
    }

    private static class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        public boolean accept(File file) {
            boolean bl = file.isDirectory() || "xml".equalsIgnoreCase(FileUtil.getExtension((String)file.getName())) || "jxb".equalsIgnoreCase(FileUtil.getExtension((String)file.getName())) || "xjb".equalsIgnoreCase(FileUtil.getExtension((String)file.getName()));
            return bl;
        }

        public String getDescription() {
            return NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"DESC_CUSTOMIZATION_FILE_FILTER");
        }
    }

    public static class EBTableModel
    extends AbstractTableModel {
        List<String> children;

        public Object getValueAt(int n, int n2) {
            return this.children.get(n);
        }

        public int getRowCount() {
            if (this.children != null) {
                return this.children.size();
            }
            return 0;
        }

        public int getColumnCount() {
            return columnName.length;
        }

        public void removeRow(int n) {
            this.children.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public void addRow(String string) {
            this.children.add(string);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }

        public void setData(Node node) {
            this.children = new ArrayList<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            Client client = (Client)node.getLookup().lookup(Client.class);
            if (client != null) {
                Binding[] bindingArray = client.getBindings();
                for (int i = 0; i < bindingArray.length; ++i) {
                    arrayList.add(bindingArray[i].getFileName());
                }
            } else {
                Service service = (Service)node.getLookup().lookup(Service.class);
                if (service != null) {
                    Binding[] bindingArray = service.getBindings();
                    for (int i = 0; i < bindingArray.length; ++i) {
                        arrayList.add(bindingArray[i].getFileName());
                    }
                }
            }
            this.children.addAll(arrayList);
            this.fireTableDataChanged();
        }

        public String getColumnName(int n) {
            return columnName[n];
        }

        public List getChildren() {
            return this.children;
        }
    }

    class AddActionListener
    implements ActionListener {
        AddActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"MSG_EXTERNAL_BINDING", (Object)ExternalBindingTablePanel.this.getRelativePathToWsdl()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (confirmation.getValue() == NotifyDescriptor.NO_OPTION) {
                return;
            }
            JFileChooser jFileChooser = new JFileChooser(ExternalBindingTablePanel.this.previousDirectory);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(XML_FILE_FILTER);
            jFileChooser.setFileFilter(XML_FILE_FILTER);
            if (jFileChooser.showOpenDialog((Component)((Object)ExternalBindingTablePanel.this)) == 0 && (file = jFileChooser.getSelectedFile()).exists()) {
                FileObject fileObject = FileUtil.toFileObject((File)file);
                String string = fileObject.getName();
                string = FileUtil.findFreeFileName((FileObject)this.getBindingsFolder(ExternalBindingTablePanel.this.node), (String)string, (String)fileObject.getExt());
                string = fileObject.getExt().equals("") ? string : string + "." + fileObject.getExt();
                ExternalBindingTablePanel.this.addedBindings.put(string, fileObject);
                ExternalBindingTablePanel.this.model.addRow(string);
                ExternalBindingTablePanel.this.previousDirectory = file.getPath();
            }
        }

        private FileObject getBindingsFolder(Node node) {
            FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
            assert (fileObject != null) : "Cannot find srcRoot";
            FileObject fileObject2 = null;
            Client client = (Client)node.getLookup().lookup(Client.class);
            if (client != null) {
                JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)fileObject);
                fileObject2 = jAXWSClientSupport.getBindingsFolderForClient(node.getName(), true);
            } else {
                Service service = (Service)node.getLookup().lookup(Service.class);
                if (service != null) {
                    JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
                    fileObject2 = jAXWSSupport.getBindingsFolderForService(node.getName(), true);
                }
            }
            return fileObject2;
        }
    }

    class RemoveActionListener
    implements ActionListener {
        RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ExternalBindingTablePanel.this.getTable().getSelectedRow();
            if (n == -1) {
                return;
            }
            String string = (String)ExternalBindingTablePanel.this.getTable().getValueAt(n, 0);
            if (this.confirmDeletion(string)) {
                ExternalBindingTablePanel.this.addedBindings.remove(string);
                ExternalBindingTablePanel.this.model.removeRow(n);
            }
        }

        private boolean confirmDeletion(String string) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"MSG_CONFIRM_DELETE", (Object)string), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            return confirmation.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

