/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.NbBundle;

public abstract class RemoteConnectionSupport {
    protected final ExecutionEnvironment executionEnvironment;
    private int exit_status;
    private boolean cancelled = false;
    private boolean failed = false;
    private String failureReason;
    protected static final Logger log = Logger.getLogger("cnd.remote.logger");

    public RemoteConnectionSupport(ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        this.exit_status = -1;
        this.failureReason = "";
        log.finest("RCS<Init>: Starting " + this.getClass().getName() + " on " + this.executionEnvironment);
        if (!ConnectionManager.getInstance().isConnectedTo(this.executionEnvironment)) {
            try {
                ConnectionManager.getInstance().connectTo(this.executionEnvironment);
            }
            catch (IOException iOException) {
                log.warning("RCS<Init>: Got " + iOException.getClass().getSimpleName() + " [" + iOException.getMessage() + "]");
                log.log(Level.FINE, "Caused by:", iOException);
            }
            catch (CancellationException cancellationException) {
                this.cancelled = true;
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.executionEnvironment)) {
                log.fine("RCS<Init>: Connection failed on " + this.executionEnvironment);
            }
        }
    }

    public static String getMessage(IOException iOException) {
        String string = iOException.getMessage();
        String string2 = iOException instanceof UnknownHostException ? NbBundle.getMessage(RemoteConnectionSupport.class, (String)"REASON_UnknownHost", (Object)iOException.getMessage()) : (string.startsWith("Auth fail") ? NbBundle.getMessage(RemoteConnectionSupport.class, (String)"REASON_AuthFailed") : string);
        return string2;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public int getExitStatus() {
        return this.exit_status;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isFailedOrCancelled() {
        return this.failed || this.cancelled;
    }

    public void setFailed(String string) {
        this.failed = true;
        this.failureReason = string;
    }

    protected void setExitStatus(int n) {
        this.exit_status = n;
    }

    public String getUser() {
        return this.executionEnvironment.getUser();
    }

    public String getHost() {
        return this.executionEnvironment.getHost();
    }
}

