/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.SystemIncludesUtils;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.ServerListImplementation;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerList
implements ServerListImplementation {
    private static final String CND_REMOTE = "cnd.remote";
    private static final String REMOTE_SERVERS = "cnd.remote.servers";
    private static final char SERVER_RECORD_SEPARATOR = '|';
    private static final String SERVER_LIST_SEPARATOR = ",";
    private static final String DEFAULT_INDEX = "cnd.remote.default";
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private int defaultIndex;
    private final PropertyChangeSupport pcs;
    private final ChangeSupport cs;
    private final ArrayList<RemoteServerRecord> unlisted;
    private final ArrayList<RemoteServerRecord> items = new ArrayList();

    public RemoteServerList() {
        String string = RemoteServerList.getPreferences().get(REMOTE_SERVERS, null);
        this.defaultIndex = RemoteServerList.getPreferences().getInt(DEFAULT_INDEX, 0);
        this.pcs = new PropertyChangeSupport(this);
        this.cs = new ChangeSupport((Object)this);
        this.unlisted = new ArrayList();
        this.addServer(ExecutionEnvironmentFactory.getLocal(), null, RemoteSyncFactory.getDefault(), false, RemoteServerRecord.State.ONLINE);
        if (string != null) {
            for (String string2 : string.split(SERVER_LIST_SEPARATOR)) {
                ExecutionEnvironment executionEnvironment;
                String string3 = null;
                RemoteSyncFactory remoteSyncFactory = RemoteSyncFactory.getDefault();
                String[] stringArray = string2.split("\\|");
                CndUtils.assertTrue((stringArray.length > 0 ? 1 : 0) != 0);
                String string4 = stringArray[0];
                if (stringArray.length > 1) {
                    string3 = stringArray[1];
                }
                if (stringArray.length > 2) {
                    remoteSyncFactory = RemoteSyncFactory.fromID((String)stringArray[2]);
                }
                if (!(executionEnvironment = ExecutionEnvironmentFactory.fromUniqueID((String)string4)).isRemote()) continue;
                this.addServer(executionEnvironment, string3, remoteSyncFactory, false, RemoteServerRecord.State.OFFLINE);
            }
        }
        this.refresh();
    }

    public synchronized ServerRecord get(ExecutionEnvironment executionEnvironment) {
        for (RemoteServerRecord remoteServerRecord : this.items) {
            if (!executionEnvironment.equals(remoteServerRecord.getExecutionEnvironment())) continue;
            return remoteServerRecord;
        }
        for (RemoteServerRecord remoteServerRecord : this.unlisted) {
            if (!executionEnvironment.equals(remoteServerRecord.getExecutionEnvironment())) continue;
            return remoteServerRecord;
        }
        RemoteServerRecord remoteServerRecord = new RemoteServerRecord(executionEnvironment, null, RemoteSyncFactory.getDefault(), false);
        this.unlisted.add(remoteServerRecord);
        return remoteServerRecord;
    }

    public synchronized ServerRecord getDefaultRecord() {
        return this.items.get(this.defaultIndex);
    }

    public synchronized int getDefaultIndex() {
        return this.defaultIndex;
    }

    public synchronized void setDefaultIndex(int n) {
        this.defaultIndex = n;
        RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, n);
    }

    public synchronized List<ExecutionEnvironment> getEnvironments() {
        ArrayList<ExecutionEnvironment> arrayList = new ArrayList<ExecutionEnvironment>(this.items.size());
        for (RemoteServerRecord remoteServerRecord : this.items) {
            arrayList.add(remoteServerRecord.getExecutionEnvironment());
        }
        return arrayList;
    }

    private void addServer(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory, boolean bl, RemoteServerRecord.State state) {
        RemoteServerRecord remoteServerRecord = (RemoteServerRecord)this.addServer(executionEnvironment, string, remoteSyncFactory, bl, false);
        remoteServerRecord.setState(state);
    }

    public synchronized ServerRecord addServer(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory, boolean bl, boolean bl2) {
        RemoteServerRecord remoteServerRecord = null;
        for (RemoteServerRecord remoteServerRecord2 : this.items) {
            if (!remoteServerRecord2.getExecutionEnvironment().equals(executionEnvironment)) continue;
            if (bl) {
                this.defaultIndex = this.items.indexOf(remoteServerRecord2);
                RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
            }
            return remoteServerRecord2;
        }
        for (RemoteServerRecord remoteServerRecord2 : this.unlisted) {
            if (!remoteServerRecord2.getExecutionEnvironment().equals(executionEnvironment)) continue;
            remoteServerRecord = remoteServerRecord2;
            break;
        }
        if (remoteServerRecord == null) {
            remoteServerRecord = new RemoteServerRecord(executionEnvironment, string, remoteSyncFactory, bl2);
        } else {
            remoteServerRecord.setDeleted(false);
            remoteServerRecord.setDisplayName(string);
            remoteServerRecord.setSyncFactory(remoteSyncFactory);
            this.unlisted.remove(remoteServerRecord);
        }
        this.items.add(remoteServerRecord);
        if (bl) {
            this.defaultIndex = this.items.size() - 1;
        }
        this.refresh();
        RemoteServerList.storePreferences(remoteServerRecord);
        RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
        return remoteServerRecord;
    }

    public static void storePreferences(RemoteServerRecord remoteServerRecord) {
        String string = remoteServerRecord.getRawDisplayName();
        String string2 = RemoteServerList.getPreferences().get(REMOTE_SERVERS, null);
        String string3 = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)remoteServerRecord.getExecutionEnvironment());
        String string4 = string3 + '|' + (string == null ? "" : string) + '|' + remoteServerRecord.getSyncFactory().getID();
        if (string2 == null) {
            RemoteServerList.getPreferences().put(REMOTE_SERVERS, string4);
        } else {
            StringBuilder stringBuilder = new StringBuilder(string4);
            for (String string5 : string2.split(SERVER_LIST_SEPARATOR)) {
                String string6;
                int n = string5.indexOf(124);
                String string7 = string6 = n > 0 ? string5.substring(0, n) : string5;
                if (string6.equals(string3)) continue;
                stringBuilder.append(SERVER_LIST_SEPARATOR);
                stringBuilder.append(string5);
            }
            RemoteServerList.getPreferences().put(REMOTE_SERVERS, stringBuilder.toString());
        }
    }

    public synchronized void removeServer(ServerRecord serverRecord) {
        log.finest("ServerList: remove " + serverRecord);
        SystemIncludesUtils.cancel(serverRecord.getExecutionEnvironment());
        if (this.items.remove(serverRecord)) {
            this.removeFromPreferences(serverRecord);
            this.refresh();
        }
    }

    public synchronized void set(List<ServerRecord> list, int n) {
        log.finest("ServerList: set " + list);
        Collection<ExecutionEnvironment> collection = this.clear();
        for (ServerRecord serverRecord : list) {
            this.addServer(serverRecord.getExecutionEnvironment(), serverRecord.getDisplayName(), serverRecord.getSyncFactory(), false, false);
            collection.remove(serverRecord.getExecutionEnvironment());
        }
        this.setDefaultIndex(n);
        SystemIncludesUtils.cancel(collection);
    }

    private Collection<ExecutionEnvironment> clear() {
        ArrayList<ExecutionEnvironment> arrayList = new ArrayList<ExecutionEnvironment>();
        for (RemoteServerRecord remoteServerRecord : this.items) {
            remoteServerRecord.setDeleted(true);
            arrayList.add(remoteServerRecord.getExecutionEnvironment());
        }
        RemoteServerList.getPreferences().remove(REMOTE_SERVERS);
        this.unlisted.addAll(this.items);
        this.items.clear();
        return arrayList;
    }

    private void removeFromPreferences(ServerRecord serverRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RemoteServerRecord remoteServerRecord : this.items) {
            if (serverRecord.equals(remoteServerRecord)) continue;
            stringBuilder.append(remoteServerRecord.getDisplayName());
            stringBuilder.append(',');
        }
        RemoteServerList.getPreferences().put(REMOTE_SERVERS, stringBuilder.toString());
    }

    protected void refresh() {
        this.cs.fireChange();
    }

    public synchronized RemoteServerRecord getLocalhostRecord() {
        return this.items.get(0);
    }

    public boolean isValidExecutable(ExecutionEnvironment executionEnvironment, String string) {
        int n;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            log.warning("RemoteServerList.isValidExecutable from EDT");
        }
        if ((n = RemoteCommandSupport.run(executionEnvironment, "test", "-x", string)) != 0 && !IpeUtils.isPathAbsolute((String)string)) {
            n = RemoteCommandSupport.run(executionEnvironment, "test", "-x", "`which " + string + "`");
        }
        return n == 0;
    }

    public synchronized Collection<? extends ServerRecord> getRecords() {
        return new ArrayList<RemoteServerRecord>(this.items);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object) {
        this.pcs.firePropertyChange(string, null, object);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(RemoteServerList.class);
    }
}

