/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingsAnalyzer;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.ui.EditPathMapDialog;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotePathMap
extends PathMap {
    private static final Map<ExecutionEnvironment, RemotePathMap> pmtable = new HashMap<ExecutionEnvironment, RemotePathMap>();
    private final HashMap<String, String> map = new HashMap();
    private final ExecutionEnvironment execEnv;
    private static final String REMOTE_PATH_MAP = "remote-path-map";
    private static final String DELIMITER = "\n";
    public static final boolean useRsync = Boolean.getBoolean("cnd.remote.useRsync");
    public static final String REMOTE_BASE_PATH = "NetBeansProjects/remote";
    private static PathMap rsyncMapper = new RsyncPathMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemotePathMap getRemotePathMapInstance(ExecutionEnvironment executionEnvironment) {
        RemotePathMap remotePathMap = pmtable.get(executionEnvironment);
        if (remotePathMap == null) {
            Map<ExecutionEnvironment, RemotePathMap> map = pmtable;
            synchronized (map) {
                remotePathMap = new RemotePathMap(executionEnvironment);
                pmtable.put(executionEnvironment, remotePathMap);
            }
        }
        return remotePathMap;
    }

    public static boolean isReady(ExecutionEnvironment executionEnvironment) {
        return pmtable.get(executionEnvironment) != null;
    }

    private RemotePathMap(ExecutionEnvironment executionEnvironment) {
        this.execEnv = executionEnvironment;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            String string = RemotePathMap.getPreferences(this.execEnv);
            if (string == null) {
                String string2 = System.getProperty("cnd.remote.pmap");
                if (string2 != null) {
                    File file = new File(string2);
                    if (file.exists() && file.canRead()) {
                        try {
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                            try {
                                String string3;
                                while ((string3 = bufferedReader.readLine()) != null) {
                                    int n = string3.indexOf(32);
                                    if (n <= 0) continue;
                                    this.map.put(string3.substring(0, n), string3.substring(n + 1).trim());
                                }
                            }
                            finally {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    HostMappingsAnalyzer hostMappingsAnalyzer = new HostMappingsAnalyzer(this.execEnv);
                    this.map.putAll(hostMappingsAnalyzer.getMappings());
                }
            } else {
                String[] stringArray = string.split(DELIMITER);
                for (int i = 0; i < stringArray.length; i += 2) {
                    if (i + 1 < stringArray.length) {
                        this.map.put(stringArray[i], stringArray[i + 1]);
                        continue;
                    }
                    System.err.println("mapping serialization flaw. Was found: " + string);
                }
            }
        }
    }

    public String getRemotePath(String string, boolean bl) {
        String string2 = RemotePathMap.unifySeparators(string);
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String string3 = RemotePathMap.unifySeparators(entry.getKey());
            if (!string2.startsWith(string3)) continue;
            String string4 = entry.getValue();
            return string4 + string.substring(string3.length()).replace('\\', '/');
        }
        return bl ? string : null;
    }

    public String getLocalPath(String string, boolean bl) {
        String string2 = RemotePathMap.unifySeparators(string);
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String string3 = RemotePathMap.unifySeparators(entry.getValue());
            if (!string2.startsWith(string3)) continue;
            String string4 = entry.getKey();
            return string4 + string.substring(string3.length());
        }
        return bl ? string : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRemotePath(String string, boolean bl) {
        block8: {
            String string2 = RemotePathMap.unifySeparators(string);
            for (Map.Entry<String, String> object : this.map.entrySet()) {
                String string3 = RemotePathMap.unifySeparators(object.getValue());
                if (!string2.startsWith(string3)) continue;
                return true;
            }
            for (String string4 : this.map.keySet()) {
                if (!string2.startsWith(RemotePathMap.unifySeparators(string4))) continue;
                return true;
            }
            try {
                if (!RemotePathMap.validateMapping(this.execEnv, string, new File(string))) break block8;
                HashMap<String, String> hashMap = this.map;
                synchronized (hashMap) {
                    this.map.put(string, string);
                }
                return true;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        if (bl) {
            return EditPathMapDialog.showMe(this.execEnv, string) && this.checkRemotePath(string, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMapping(String string, String string2) {
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.map);
            linkedHashMap.put(string, string2);
            this.updatePathMap(linkedHashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePathMap(Map<String, String> map) {
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = RemotePathMap.fixEnding(entry.getValue());
                String string2 = RemotePathMap.fixEnding(entry.getKey());
                this.map.put(string2, string);
                stringBuilder.append(RemotePathMap.fixEnding(string2));
                stringBuilder.append(DELIMITER);
                stringBuilder.append(string);
                stringBuilder.append(DELIMITER);
            }
            this.setPreferences(stringBuilder.toString());
        }
    }

    public Map<String, String> getMap() {
        return (Map)this.map.clone();
    }

    private static String fixEnding(String string) {
        if (string.charAt(string.length() - 1) != '/' && string.charAt(string.length() - 1) != '\\') {
            return string + "/";
        }
        return string;
    }

    private static String unifySeparators(String string) {
        return string.replace('\\', '/').toLowerCase();
    }

    public static boolean isSubPath(String string, String string2) {
        return RemotePathMap.unifySeparators(string2).startsWith(RemotePathMap.unifySeparators(string));
    }

    private static String getPreferences(ExecutionEnvironment executionEnvironment) {
        return NbPreferences.forModule(RemotePathMap.class).get(REMOTE_PATH_MAP + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment), null);
    }

    private void setPreferences(String string) {
        NbPreferences.forModule(RemotePathMap.class).put(REMOTE_PATH_MAP + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.execEnv), string);
    }

    private static boolean validateMapping(ExecutionEnvironment executionEnvironment, String string, File file) throws InterruptedException {
        if (!PlatformInfo.getDefault((ExecutionEnvironment)executionEnvironment).isWindows() && !PlatformInfo.getDefault((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).isWindows()) {
            return RemotePathMap.isTheSame(executionEnvironment, string, file);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTheSame(ExecutionEnvironment executionEnvironment, String string, File file) throws InterruptedException {
        if (file.exists() && file.isDirectory()) {
            File file2 = null;
            try {
                file2 = File.createTempFile("cnd", "tmp", file);
                if (file2.exists()) {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                    String string2 = Double.toString(Math.random());
                    bufferedWriter.write(string2);
                    bufferedWriter.close();
                    RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(executionEnvironment, "grep", null, string2, string + "/" + file2.getName());
                    if (remoteCommandSupport.run() == 0) {
                        boolean bl = true;
                        return bl;
                    }
                    if (remoteCommandSupport.isCancelled() || remoteCommandSupport.isInterrupted()) {
                        throw new InterruptedException();
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
            }
        }
        return false;
    }

    public static PathMap getPathMap(ExecutionEnvironment executionEnvironment) {
        return useRsync ? rsyncMapper : RemotePathMap.getRemotePathMapInstance(executionEnvironment);
    }

    private static class RsyncPathMap
    extends PathMap {
        private RsyncPathMap() {
        }

        public boolean checkRemotePath(String string, boolean bl) {
            return true;
        }

        public String getLocalPath(String string, boolean bl) {
            return string;
        }

        public String getRemotePath(String string, boolean bl) {
            String string2 = string.substring(string.lastIndexOf("\\") + 1);
            return "NetBeansProjects/remote/" + string2;
        }
    }
}

