/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;

class CompilerSetScriptManager
extends RemoteConnectionSupport {
    private List<String> compilerSets = new ArrayList<String>();
    private int nextSet;
    private String platform;
    private static int emulateFailure = Integer.getInteger("cnd.remote.failure", 0);
    public static final String SCRIPT = ".netbeans/6.7/cnd2/scripts/getCompilerSets.bash";

    public CompilerSetScriptManager(ExecutionEnvironment executionEnvironment) {
        super(executionEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runScript() {
        if (this.isFailedOrCancelled()) return;
        this.nextSet = 0;
        this.compilerSets.clear();
        try {
            BufferedReader bufferedReader;
            block7: {
                block6: {
                    NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
                    nativeProcessBuilder.setExecutable(SCRIPT);
                    NativeProcess nativeProcess = nativeProcessBuilder.call();
                    bufferedReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
                    try {
                        String string;
                        if (0 < emulateFailure) {
                            log.warning("CSSM.runScript: failure emulation [" + emulateFailure + "]");
                            this.setFailed("failure emulation in CompilerSetScriptManager");
                            --emulateFailure;
                            Object var6_5 = null;
                            break block6;
                        }
                        this.platform = bufferedReader.readLine();
                        log.fine("CSSM.runScript: Reading input from getCompilerSets.bash");
                        log.fine("    platform [" + this.platform + "]");
                        while ((string = bufferedReader.readLine()) != null) {
                            log.fine("    line [" + string + "]");
                            this.compilerSets.add(string);
                        }
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        bufferedReader.close();
                        throw throwable;
                    }
                }
                bufferedReader.close();
                return;
            }
            Object var6_6 = null;
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            log.warning("CSSM.runScript: IOException [" + iOException.getMessage() + "]");
            this.setFailed(iOException.getMessage());
        }
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean hasMoreCompilerSets() {
        return this.nextSet < this.compilerSets.size();
    }

    public String getNextCompilerSetData() {
        return this.compilerSets.get(this.nextSet++);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.compilerSets) {
            stringBuilder.append(string).append('\n');
        }
        return stringBuilder.toString();
    }
}

