/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.project.uiapi.CategoryChangeSupport;
import org.netbeans.modules.project.uiapi.CategoryModel;
import org.netbeans.modules.project.uiapi.CategoryView;
import org.netbeans.modules.project.uiapi.CustomizerDialog;
import org.netbeans.modules.project.uiapi.CustomizerPane;
import org.netbeans.modules.project.uiapi.Utilities;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class ProjectCustomizer {
    private ProjectCustomizer() {
    }

    public static Dialog createCustomizerDialog(Category[] categoryArray, CategoryComponentProvider categoryComponentProvider, String string, ActionListener actionListener, HelpCtx helpCtx) {
        return ProjectCustomizer.createCustomizerDialog(categoryArray, categoryComponentProvider, string, actionListener, null, helpCtx);
    }

    public static Dialog createCustomizerDialog(Category[] categoryArray, CategoryComponentProvider categoryComponentProvider, String string, ActionListener actionListener, ActionListener actionListener2, HelpCtx helpCtx) {
        CustomizerPane customizerPane = ProjectCustomizer.createCustomizerPane(categoryArray, categoryComponentProvider, string);
        Dialog dialog = CustomizerDialog.createDialog(actionListener, actionListener2, customizerPane, helpCtx, categoryArray, categoryComponentProvider);
        return dialog;
    }

    public static Dialog createCustomizerDialog(String string, Lookup lookup, String string2, ActionListener actionListener, HelpCtx helpCtx) {
        return ProjectCustomizer.createCustomizerDialog(string, lookup, string2, actionListener, null, helpCtx);
    }

    public static Dialog createCustomizerDialog(String string, Lookup lookup, String string2, ActionListener actionListener, ActionListener actionListener2, HelpCtx helpCtx) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (fileObject == null) {
            throw new IllegalArgumentException("The designated path " + string + " doesn't exist. Cannot create customizer.");
        }
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        assert (dataFolder != null) : "Cannot find DataFolder for " + string;
        DelegateCategoryProvider delegateCategoryProvider = new DelegateCategoryProvider(dataFolder, lookup);
        return ProjectCustomizer.createCustomizerDialog(delegateCategoryProvider.getSubCategories(), delegateCategoryProvider, string2, actionListener, actionListener2, helpCtx);
    }

    private static CustomizerPane createCustomizerPane(Category[] categoryArray, CategoryComponentProvider categoryComponentProvider, String string) {
        Category category;
        CategoryChangeSupport categoryChangeSupport = new CategoryChangeSupport();
        ProjectCustomizer.registerCategoryChangeSupport(categoryChangeSupport, categoryArray);
        CategoryModel categoryModel = new CategoryModel(categoryArray);
        CategoryView categoryView = new CategoryView(categoryModel);
        CustomizerPane customizerPane = new CustomizerPane(categoryView, categoryModel, categoryComponentProvider);
        if (string == null) {
            string = categoryArray[0].getName();
        }
        if ((category = categoryModel.getCategory(string)) != null) {
            categoryModel.setCurrentCategory(category);
        }
        return customizerPane;
    }

    private static void registerCategoryChangeSupport(CategoryChangeSupport categoryChangeSupport, Category[] categoryArray) {
        for (int i = 0; i < categoryArray.length; ++i) {
            Utilities.putCategoryChangeSupport(categoryArray[i], categoryChangeSupport);
            Category[] categoryArray2 = categoryArray[i].getSubcategories();
            if (categoryArray2 == null) continue;
            ProjectCustomizer.registerCategoryChangeSupport(categoryChangeSupport, categoryArray2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegateCategoryProvider
    implements CategoryComponentProvider,
    CompositeCategoryProvider,
    Lookup.Provider {
        private final Lookup context;
        private final Map<Category, CompositeCategoryProvider> category2provider;
        private final DataFolder folder;
        private final CompositeCategoryProvider selfProvider;

        public DelegateCategoryProvider(DataFolder dataFolder, Lookup lookup) {
            this(dataFolder, lookup, new HashMap<Category, CompositeCategoryProvider>());
        }

        private DelegateCategoryProvider(DataFolder dataFolder, Lookup lookup, Map<Category, CompositeCategoryProvider> map) {
            this(dataFolder, lookup, map, null);
        }

        private DelegateCategoryProvider(DataFolder dataFolder, Lookup lookup, Map<Category, CompositeCategoryProvider> map, CompositeCategoryProvider compositeCategoryProvider) {
            this.context = lookup;
            this.folder = dataFolder;
            this.category2provider = map;
            this.selfProvider = compositeCategoryProvider;
        }

        @Override
        public JComponent create(Category category) {
            CompositeCategoryProvider compositeCategoryProvider = this.category2provider.get(category);
            assert (compositeCategoryProvider != null) : "Category doesn't have a provider associated.";
            return compositeCategoryProvider.createComponent(category, this.context);
        }

        public Category[] getSubCategories() {
            try {
                return this.readCategories(this.folder);
            }
            catch (IOException iOException) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Cannot construct Project UI panels", iOException);
                return new Category[0];
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Cannot construct Project UI panels", classNotFoundException);
                return new Category[0];
            }
        }

        Category[] readCategories(DataFolder dataFolder) throws IOException, ClassNotFoundException {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (DataObject dataObject : dataFolder.getChildren()) {
                Object object;
                Object object2;
                Object object3;
                if (dataObject instanceof DataFolder) {
                    object3 = null;
                    for (DataObject dataObject2 : object2 = ((DataFolder)dataObject).getChildren()) {
                        InstanceCookie instanceCookie;
                        if (!dataObject2.getName().equals("Self") || (instanceCookie = (InstanceCookie)dataObject2.getCookie(InstanceCookie.class)) == null || !CompositeCategoryProvider.class.isAssignableFrom(instanceCookie.instanceClass())) continue;
                        object3 = (CompositeCategoryProvider)instanceCookie.instanceCreate();
                    }
                    object = null;
                    object = object3 != null ? new DelegateCategoryProvider((DataFolder)dataObject, this.context, this.category2provider, (CompositeCategoryProvider)object3) : new DelegateCategoryProvider((DataFolder)dataObject, this.context, this.category2provider);
                    Category category = object.createCategory(this.context);
                    arrayList.add(category);
                    this.category2provider.put(category, (CompositeCategoryProvider)object);
                }
                if (dataObject.getName().equals("Self") || (object3 = (InstanceCookie)dataObject.getCookie(InstanceCookie.class)) == null || !CompositeCategoryProvider.class.isAssignableFrom(object3.instanceClass()) || (object2 = (CompositeCategoryProvider)object3.instanceCreate()) == null || (object = object2.createCategory(this.context)) == null) continue;
                arrayList.add(object);
                this.category2provider.put((Category)object, (CompositeCategoryProvider)object2);
                this.includeSubcats(((Category)object).getSubcategories(), (CompositeCategoryProvider)object2);
            }
            return arrayList.toArray(new Category[arrayList.size()]);
        }

        private void includeSubcats(Category[] categoryArray, CompositeCategoryProvider compositeCategoryProvider) {
            if (categoryArray != null) {
                for (Category category : categoryArray) {
                    this.category2provider.put(category, compositeCategoryProvider);
                    this.includeSubcats(category.getSubcategories(), compositeCategoryProvider);
                }
            }
        }

        @Override
        public Category createCategory(Lookup lookup) {
            FileObject fileObject = this.folder.getPrimaryFile();
            String string = fileObject.getNameExt();
            try {
                string = fileObject.getFileSystem().getStatus().annotateName(fileObject.getNameExt(), Collections.singleton(fileObject));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Cannot retrieve display name for folder " + fileObject.getPath(), fileStateInvalidException);
            }
            return Category.create(this.folder.getName(), string, null, this.getSubCategories());
        }

        @Override
        public JComponent createComponent(Category category, Lookup lookup) {
            if (this.selfProvider != null) {
                return this.selfProvider.createComponent(category, lookup);
            }
            return new JPanel();
        }

        public Lookup getLookup() {
            return this.context;
        }
    }

    public static final class Category {
        private String name;
        private String displayName;
        private Image icon;
        private Category[] subcategories;
        private boolean valid;
        private String errorMessage;
        private ActionListener okListener;
        private ActionListener storeListener;

        private Category(String string, String string2, Image image, Category[] categoryArray) {
            this.name = string;
            this.displayName = string2;
            this.icon = image;
            this.subcategories = categoryArray;
            this.valid = true;
        }

        public static Category create(String string, String string2, Image image, Category ... categoryArray) {
            return new Category(string, string2, image, categoryArray);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Image getIcon() {
            return this.icon;
        }

        public Category[] getSubcategories() {
            return this.subcategories;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean bl) {
            if (this.valid != bl) {
                this.valid = bl;
                Utilities.getCategoryChangeSupport(this).firePropertyChange("isCategoryValid", !bl, bl);
            }
        }

        public void setErrorMessage(String string) {
            if (string == null) {
                string = "";
            }
            if (!string.equals(this.errorMessage)) {
                String string2 = this.errorMessage;
                this.errorMessage = string;
                Utilities.getCategoryChangeSupport(this).firePropertyChange("categoryErrorMessage", string2, string);
            }
        }

        public void setOkButtonListener(ActionListener actionListener) {
            this.okListener = actionListener;
        }

        public ActionListener getOkButtonListener() {
            return this.okListener;
        }

        public void setStoreListener(ActionListener actionListener) {
            this.storeListener = actionListener;
        }

        public ActionListener getStoreListener() {
            return this.storeListener;
        }
    }

    public static interface CompositeCategoryProvider {
        public Category createCategory(Lookup var1);

        public JComponent createComponent(Category var1, Lookup var2);
    }

    public static interface CategoryComponentProvider {
        public JComponent create(Category var1);
    }
}

