/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import org.netbeans.modules.cnd.repository.queue.RepositoryQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryWriter;
import org.netbeans.modules.cnd.repository.queue.RepositoryWritingThread;
import org.netbeans.modules.cnd.repository.queue.TickingRepositoryQueue;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.openide.util.RequestProcessor;

public class RepositoryThreadManager {
    private static final String threadNameBase = "Repository writer";
    private RequestProcessor processor;
    private Set<Thread> threads = new CopyOnWriteArraySet<Thread>();
    private final Object threadsWaitLock = new String("threadsWaitLock");
    private boolean finished = false;
    private int currThread = 0;
    private RepositoryWriter writer;
    private RepositoryQueue queue;
    private static boolean proceed = true;
    private ReadWriteLock rwLock;

    public RepositoryThreadManager(RepositoryWriter repositoryWriter, ReadWriteLock readWriteLock) {
        this.writer = repositoryWriter;
        this.rwLock = readWriteLock;
        this.queue = Stats.queueUseTicking ? new TickingRepositoryQueue() : new RepositoryQueue();
    }

    public RepositoryQueue startup() {
        int n;
        if (Stats.queueTrace) {
            System.err.printf("RepositoryThreadManager.startup\n", new Object[0]);
        }
        if ((n = Integer.getInteger("cnd.repository.writer.threads", 1).intValue()) < 1) {
            n = 1;
        }
        this.processor = new RequestProcessor(threadNameBase, n);
        for (int i = 0; i < n; ++i) {
            Wrapper wrapper = new Wrapper(new RepositoryWritingThread(this.writer, this.queue, this.rwLock));
            this.processor.post((Runnable)wrapper);
        }
        return this.queue;
    }

    public int getCurrThread() {
        return this.currThread;
    }

    public void shutdown() {
        if (Stats.queueTrace) {
            System.err.printf("RepositoryThreadManager.shutdown\n", new Object[0]);
        }
        proceed = false;
        this.queue.shutdown();
        if (Stats.queueTrace) {
            System.err.printf("RepositoryThreadManager waiting for threads to finish...\n", new Object[0]);
        }
        this.waitFinished();
        if (Stats.queueTrace) {
            System.err.printf("RepositoryThreadManager threads have finished.\n", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFinished() {
        Object object = this.threadsWaitLock;
        synchronized (object) {
            while (!this.finished) {
                try {
                    this.threadsWaitLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    static boolean proceed() {
        return proceed;
    }

    private class Wrapper
    implements Runnable {
        private Runnable delegate;

        public Wrapper(Runnable runnable) {
            this.delegate = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.currentThread().setName("Repository writer " + RepositoryThreadManager.this.currThread++);
                RepositoryThreadManager.this.threads.add(Thread.currentThread());
                this.delegate.run();
            }
            finally {
                RepositoryThreadManager.this.threads.remove(Thread.currentThread());
                if (RepositoryThreadManager.this.threads.isEmpty()) {
                    RepositoryThreadManager.this.finished = true;
                    Object object = RepositoryThreadManager.this.threadsWaitLock;
                    synchronized (object) {
                        RepositoryThreadManager.this.threadsWaitLock.notifyAll();
                    }
                }
            }
        }
    }
}

