/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapRepository
implements Repository {
    private final Map<CharSequence, Unit> units;
    private final Object unitsLock = new Object();

    public void debugDistribution() {
    }

    public HashMapRepository() {
        this.units = new ConcurrentHashMap<CharSequence, Unit>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit getUnit(CharSequence charSequence) {
        assert (charSequence != null);
        Unit unit = this.units.get(charSequence);
        if (unit == null) {
            Object object = this.unitsLock;
            synchronized (object) {
                unit = this.units.get(charSequence);
                if (unit == null) {
                    unit = new Unit(charSequence);
                    this.units.put(charSequence, unit);
                }
            }
        }
        return unit;
    }

    public void put(Key key, Persistent persistent) {
        assert (persistent != null);
        this.getUnit(key.getUnit()).put(key, persistent);
    }

    public Persistent get(Key key) {
        return this.getUnit(key.getUnit()).get(key);
    }

    public Persistent tryGet(Key key) {
        return this.get(key);
    }

    public void remove(Key key) {
        this.getUnit(key.getUnit()).remove(key);
    }

    public void hang(Key key, Persistent persistent) {
        this.put(key, persistent);
    }

    public void debugClear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.unitsLock;
        synchronized (object) {
            this.units.clear();
        }
    }

    public void openUnit(int n, String string) {
    }

    public synchronized void closeUnit(String string, boolean bl, Set<String> set) {
        this.removeUnit(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeUnit(String string) {
        Iterator<CharSequence> iterator = this.units.keySet().iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence = iterator.next();
            if (!((Object)charSequence).toString().equals(string)) continue;
            Object object = this.unitsLock;
            synchronized (object) {
                iterator.remove();
                return;
            }
        }
    }

    public void cleanCaches() {
    }

    public void registerRepositoryListener(RepositoryListener repositoryListener) {
    }

    public void unregisterRepositoryListener(RepositoryListener repositoryListener) {
    }

    public void startup(int n) {
    }

    private static class Unit {
        private Map<Key, Persistent> map = new ConcurrentHashMap<Key, Persistent>();
        private CharSequence name;

        public Unit(CharSequence charSequence) {
            this.name = charSequence;
        }

        public void put(Key key, Persistent persistent) {
            assert (key.getUnit().equals(this.name));
            this.map.put(key, persistent);
        }

        public Persistent get(Key key) {
            assert (key.getUnit().equals(this.name));
            return this.map.get(key);
        }

        void remove(Key key) {
            assert (key.getUnit().equals(this.name));
            this.map.remove(key);
        }
    }
}

