/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl;

import java.util.Set;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.disk.DiskRepositoryManager;
import org.netbeans.modules.cnd.repository.impl.HashMapRepository;
import org.netbeans.modules.cnd.repository.impl.KeyValidatorRepository;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;
import org.netbeans.modules.cnd.repository.util.RepositoryListenersManager;
import org.netbeans.modules.cnd.utils.CndUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegateRepository
implements Repository {
    private Repository delegate;

    public void hang(Key key, Persistent persistent) {
        this.delegate.hang(key, persistent);
    }

    public void put(Key key, Persistent persistent) {
        this.delegate.put(key, persistent);
    }

    public Persistent get(Key key) {
        String string;
        Persistent persistent = this.delegate.get(key);
        if (persistent == null && Stats.useNullWorkaround && !(string = key.getClass().getName()).endsWith(".ProjectKey") && !string.endsWith(".OffsetableDeclarationKey")) {
            System.err.printf("NULL returned for key %s on attempt 1\n", key);
            persistent = this.delegate.get(key);
            System.err.printf("%s value returned for key %s on attempt 2\n", persistent == null ? "NULL" : "NON-NULL", key);
        }
        return persistent;
    }

    public Persistent tryGet(Key key) {
        return this.delegate.tryGet(key);
    }

    public void remove(Key key) {
        this.delegate.remove(key);
    }

    public void debugClear() {
        this.delegate.debugClear();
        this.delegate = null;
    }

    public void shutdown() {
        Repository repository = this.delegate;
        if (repository != null) {
            repository.shutdown();
        }
    }

    public void openUnit(int n, String string) {
        this.delegate.openUnit(n, string);
    }

    public void closeUnit(String string, boolean bl, Set<String> set) {
        this.delegate.closeUnit(string, bl, set);
    }

    public void removeUnit(String string) {
        this.delegate.removeUnit(string);
    }

    public void cleanCaches() {
        this.delegate.cleanCaches();
    }

    public void registerRepositoryListener(RepositoryListener repositoryListener) {
        RepositoryListenersManager.getInstance().registerListener(repositoryListener);
    }

    public void unregisterRepositoryListener(RepositoryListener repositoryListener) {
        RepositoryListenersManager.getInstance().unregisterListener(repositoryListener);
    }

    public void startup(int n) {
        this.initDelegate();
        RepositoryTranslatorImpl.startup(n);
        this.delegate.startup(n);
    }

    private synchronized void initDelegate() {
        if (this.delegate == null) {
            if (CndUtils.getBoolean((String)"cnd.repository.validate.keys", (boolean)false)) {
                Stats.log("Testing keys using KeyValidatorRepository.");
                this.delegate = new KeyValidatorRepository();
            } else if (CndUtils.getBoolean((String)"cnd.repository.hardrefs", (boolean)false)) {
                Stats.log("Using HashMapRepository.");
                this.delegate = new HashMapRepository();
            } else {
                Stats.log("by default using HybridRepository.");
                this.delegate = new DiskRepositoryManager();
            }
        }
    }

    public void debugDistribution() {
        this.delegate.debugDistribution();
    }
}

