/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.deployment.plugins.spi.support.LookupProviderSupport;
import org.netbeans.modules.j2ee.sun.api.Asenv;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformImpl
extends J2eePlatformImpl {
    private static final Set MODULE_TYPES = new HashSet();
    protected static final Set SPEC_VERSIONS = new HashSet();
    private static final Set SPEC_VERSIONS_WITH_5 = new HashSet();
    private static final String J2EE_14_JAR = "lib/j2ee.jar";
    private static final String JAVA_EE_JAR = "lib/javaee.jar";
    private static final String JSF_API_JAR = "lib/jsf-api.jar";
    private static final String JSF_IMPL_JAR = "lib/jsf-impl.jar";
    private static final String JAX_QNAME_JAR = "lib/jax-qname.jar";
    private static final String JAXRPC_API_JAR = "lib/jaxrpc-api.jar";
    private static final String JAXRPC_IMPL_JAR = "lib/jaxrpc-impl.jar";
    private static final String JAXR_API_JAR = "lib/jaxr-api.jar";
    private static final String JAXR_IMPL_JAR = "lib/jaxr-impl.jar";
    private static final String SAAJ_API_JAR = "lib/saaj-api.jar";
    private static final String SAAJ_IMPL_JAR = "lib/saaj-impl.jar";
    private static final String ACTIVATION_JAR = "lib/activation.jar";
    private static final String TAGS_JAR = "lib/appserv-tags.jar";
    private static final String MAIL_JAR = "lib/mail.jar";
    private static final String JSTL_JAR = "lib/appserv-jstl.jar";
    private static final String APPSERV_WS_JAR = "lib/appserv-ws.jar";
    private static final String TOOLS_JAR = "lib/tools.jar";
    private static final String JWSDP_JAR = "lib/appserv-ws-update.jar";
    private static final String JAXWSA_API_JAR = "lib/jaxwsa-api.jar";
    private static final String JAXWSA_RI_JAR = "lib/jaxwsa-ri.jar";
    private static final String WEBSERVICES_API_JAR = "lib/endorsed/webservices-api.jar";
    private static final String WEBSERVICES_RT_JAR = "lib/webservices-rt.jar";
    private static final String WEBSERVICES_TOOLS_JAR = "lib/webservices-tools.jar";
    private static final String[] SWDP_JARS = new String[]{"jersey.jar", "jsr311-api.jar", "wadl2java.jar"};
    private static final String[] TRUSTSTORE_LOCATION = new String[]{"config/cacerts.jks"};
    private static final String[] KEYSTORE_CLIENT_LOCATION = new String[]{"config/keystore.jks"};
    private static final String[] TRUSTSTORE_CLIENT_LOCATION = new String[]{"config/cacerts.jks"};
    private static final String PERSISTENCE_PROV_TOPLINK = "oracle.toplink.essentials.PersistenceProvider";
    private static final String PERSISTENCE_PROV_TOPLINK_DEFAULT = "toplinkPersistenceProviderIsDefault";
    private static String CONST_LOCATION = "LOCATION";
    private static String CONST_DOMAIN = "DOMAIN";
    private final File root;
    private final DeploymentManagerProperties dmProps;
    private LibraryImplementation[] libraries;

    public PlatformImpl(File file, DeploymentManagerProperties deploymentManagerProperties) {
        this.dmProps = deploymentManagerProperties;
        this.root = file;
    }

    private String isValidPlatformRoot(File file) {
        String string = "";
        if (file == null || "".equals(file.getPath())) {
            string = "Install directory cannot be empty.";
        } else if (!file.exists()) {
            string = "Directory '" + file.getAbsolutePath() + "' does not exist.";
        } else {
            File file2 = new File(file, "bin");
            if (!file2.exists()) {
                string = "'" + file.getAbsolutePath() + "' is not a SJSAS 8.1 installation directory.";
            }
            if (!(file2 = new File(file, "lib")).exists()) {
                string = "'" + file.getAbsolutePath() + "' is not a SJSAS 8.1 installation directory.";
            }
        }
        return string;
    }

    private void initLibraries() {
        ArrayList<LibraryImplementation> arrayList = new ArrayList<LibraryImplementation>();
        if ("".equals(this.isValidPlatformRoot(this.root))) {
            try {
                List<URL> list = this.dmProps.getSources();
                List<URL> list2 = this.dmProps.getJavadocs();
                J2eeLibraryTypeProvider j2eeLibraryTypeProvider = new J2eeLibraryTypeProvider();
                LibraryImplementation libraryImplementation = j2eeLibraryTypeProvider.createLibrary();
                List<URL> list3 = new ArrayList<URL>();
                libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"wsit-api"));
                list3.add(this.fileToUrl(new File(this.root, WEBSERVICES_API_JAR)));
                libraryImplementation.setContent("classpath", list3);
                libraryImplementation.setContent("src", list);
                libraryImplementation.setContent("javadoc", list2);
                arrayList.add(libraryImplementation);
                libraryImplementation = j2eeLibraryTypeProvider.createLibrary();
                libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"j2ee14"));
                list3 = new ArrayList();
                File file = new File(this.root, JAVA_EE_JAR);
                if (!file.exists()) {
                    list3.add(this.fileToUrl(new File(this.root, J2EE_14_JAR)));
                } else {
                    list3.add(this.fileToUrl(file));
                }
                libraryImplementation.setContent("classpath", list3);
                libraryImplementation.setContent("src", list);
                libraryImplementation.setContent("javadoc", list2);
                arrayList.add(libraryImplementation);
                libraryImplementation = j2eeLibraryTypeProvider.createLibrary();
                libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jsf11"));
                list3 = new ArrayList();
                list3.add(this.fileToUrl(new File(this.root, JSF_API_JAR)));
                list3.add(this.fileToUrl(new File(this.root, JSF_IMPL_JAR)));
                list3.add(this.fileToUrl(new File(this.root, ACTIVATION_JAR)));
                list3.add(this.fileToUrl(new File(this.root, TAGS_JAR)));
                list3.add(this.fileToUrl(new File(this.root, MAIL_JAR)));
                list3.add(this.fileToUrl(new File(this.root, JSTL_JAR)));
                libraryImplementation.setContent("classpath", list3);
                libraryImplementation.setContent("src", list);
                libraryImplementation.setContent("javadoc", list2);
                arrayList.add(libraryImplementation);
                libraryImplementation = j2eeLibraryTypeProvider.createLibrary();
                libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jwsdp"));
                list3 = new ArrayList();
                list3.add(this.fileToUrl(new File(this.root, JWSDP_JAR)));
                list3.add(this.fileToUrl(new File(this.root, JAXWSA_API_JAR)));
                list3.add(this.fileToUrl(new File(this.root, JAXWSA_RI_JAR)));
                libraryImplementation.setContent("classpath", list3);
                arrayList.add(libraryImplementation);
                list3 = new ArrayList();
                libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"wsit"));
                list3.add(this.fileToUrl(new File(this.root, WEBSERVICES_TOOLS_JAR)));
                list3.add(this.fileToUrl(new File(this.root, WEBSERVICES_RT_JAR)));
                libraryImplementation.setContent("classpath", list3);
                libraryImplementation.setContent("src", list);
                libraryImplementation.setContent("javadoc", list2);
                arrayList.add(libraryImplementation);
                libraryImplementation = j2eeLibraryTypeProvider.createLibrary();
                libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jaxqname"));
                list3 = new ArrayList();
                list3.add(this.fileToUrl(new File(this.root, JAX_QNAME_JAR)));
                list3.add(this.fileToUrl(new File(this.root, "lib/endorsed/jaxp-api.jar")));
                libraryImplementation.setContent("classpath", list3);
                libraryImplementation.setContent("src", list);
                libraryImplementation.setContent("javadoc", list2);
                arrayList.add(libraryImplementation);
                libraryImplementation = j2eeLibraryTypeProvider.createLibrary();
                libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jaxrpc11"));
                list3 = new ArrayList();
                list3.add(this.fileToUrl(new File(this.root, APPSERV_WS_JAR)));
                list3.add(this.fileToUrl(new File(this.root, JAXRPC_API_JAR)));
                list3.add(this.fileToUrl(new File(this.root, JAXRPC_IMPL_JAR)));
                libraryImplementation.setContent("classpath", list3);
                libraryImplementation.setContent("src", list);
                libraryImplementation.setContent("javadoc", list2);
                arrayList.add(libraryImplementation);
                libraryImplementation = j2eeLibraryTypeProvider.createLibrary();
                libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jaxr10"));
                list3 = new ArrayList();
                list3.add(this.fileToUrl(new File(this.root, JAXR_API_JAR)));
                list3.add(this.fileToUrl(new File(this.root, JAXR_IMPL_JAR)));
                libraryImplementation.setContent("classpath", list3);
                libraryImplementation.setContent("src", list);
                libraryImplementation.setContent("javadoc", list2);
                arrayList.add(libraryImplementation);
                libraryImplementation = j2eeLibraryTypeProvider.createLibrary();
                libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"saaj12"));
                list3 = new ArrayList();
                list3.add(this.fileToUrl(new File(this.root, SAAJ_API_JAR)));
                list3.add(this.fileToUrl(new File(this.root, SAAJ_IMPL_JAR)));
                libraryImplementation.setContent("classpath", list3);
                libraryImplementation.setContent("src", list);
                libraryImplementation.setContent("javadoc", list2);
                arrayList.add(libraryImplementation);
                list3 = this.getSwdpJarURLs();
                if (list3 != null) {
                    libraryImplementation = j2eeLibraryTypeProvider.createLibrary();
                    libraryImplementation.setName(NbBundle.getMessage(PlatformImpl.class, (String)"swdp"));
                    libraryImplementation.setContent("classpath", list3);
                    arrayList.add(libraryImplementation);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        this.libraries = arrayList.toArray(new LibraryImplementation[arrayList.size()]);
    }

    private List<URL> getSwdpJarURLs() throws MalformedURLException {
        List<URL> list = this.getSwdpJarURLs(new File(new File(this.dmProps.getLocation(), this.dmProps.getDomainName()), "lib"));
        if (list == null) {
            list = this.getSwdpJarURLs(new File(this.root, "lib/addons"));
        }
        return list;
    }

    private List<URL> getSwdpJarURLs(File file) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string : SWDP_JARS) {
            File file2 = new File(file, string);
            if (!file2.isFile()) {
                return null;
            }
            arrayList.add(this.fileToUrl(file2));
        }
        return arrayList;
    }

    public LibraryImplementation[] getLibraries() {
        if (this.libraries == null) {
            this.initLibraries();
        }
        return (LibraryImplementation[])this.libraries.clone();
    }

    public void notifyLibrariesChanged() {
        this.initLibraries();
        this.firePropertyChange("libraries", null, this.libraries);
    }

    public String getDisplayName() {
        return this.dmProps.getDisplayName();
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/sun/ide/resources/ServerInstanceIcon.png");
    }

    public File[] getPlatformRoots() {
        return new File[]{this.root};
    }

    public File[] getToolClasspathEntries(String string) {
        if ("wscompile".equals(string) && this.isValidPlatformRoot(this.root).equals("")) {
            return new File[]{new File(this.root, WEBSERVICES_API_JAR), new File(this.root, J2EE_14_JAR), new File(this.root, SAAJ_API_JAR), new File(this.root, SAAJ_IMPL_JAR), new File(this.root, JAXRPC_API_JAR), new File(this.root, JAXRPC_IMPL_JAR), new File(this.root, "lib/endorsed/jaxp-api.jar"), new File(this.root, APPSERV_WS_JAR), new File(this.root, WEBSERVICES_TOOLS_JAR), new File(this.root, WEBSERVICES_RT_JAR)};
        }
        if ("appClientRuntime".equals(string) && this.isValidPlatformRoot(this.root).equals("")) {
            return new File[]{new File(this.root, WEBSERVICES_API_JAR), new File(this.root, "lib/dom.jar"), new File(this.root, "lib/xalan.jar"), new File(this.root, "lib/xercesImpl.jar"), new File(this.root, "lib/appserv-rt.jar"), new File(this.root, JAVA_EE_JAR), new File(this.root, J2EE_14_JAR), new File(this.root, "lib/jmac-api.jar"), new File(this.root, "lib/appserv-ext.jar"), new File(this.root, MAIL_JAR), new File(this.root, ACTIVATION_JAR), new File(this.root, WEBSERVICES_RT_JAR), new File(this.root, WEBSERVICES_TOOLS_JAR), new File(this.root, APPSERV_WS_JAR), new File(this.root, JAXRPC_IMPL_JAR), new File(this.root, SAAJ_IMPL_JAR), new File(this.root, JAXR_IMPL_JAR), new File(this.root, "lib/relaxngDatatype.jar"), new File(this.root, "lib/xsdlib.jar"), new File(this.root, "lib/appserv-cmp.jar"), new File(this.root, "javadb/lib/derbyclient.jar"), new File(this.root, "lib/toplink-essentials.jar"), new File(this.root, "lib/dbschema.jar"), new File(this.root, "lib/appserv-admin.jar"), new File(this.root, "lib/install/applications/jmsra/imqjmsra.jar"), new File(this.root, "lib/fscontext.jar"), new File(this.root, "lib/dtds"), new File(this.root, "lib/schemas")};
        }
        if ("keystore".equals(string) && this.isValidPlatformRoot(this.root).equals("")) {
            File file = new File(new File(this.dmProps.getInstanceProperties().getProperty(CONST_LOCATION)), this.dmProps.getInstanceProperties().getProperty(CONST_DOMAIN) + File.separator + KEYSTORE_CLIENT_LOCATION[0]);
            return new File[]{file};
        }
        if ("keystoreClient".equals(string) && this.isValidPlatformRoot(this.root).equals("")) {
            File file = new File(new File(this.dmProps.getInstanceProperties().getProperty(CONST_LOCATION)), this.dmProps.getInstanceProperties().getProperty(CONST_DOMAIN) + File.separator + KEYSTORE_CLIENT_LOCATION[0]);
            return new File[]{file};
        }
        if ("truststore".equals(string) && this.isValidPlatformRoot(this.root).equals("")) {
            File file = new File(new File(this.dmProps.getInstanceProperties().getProperty(CONST_LOCATION)), this.dmProps.getInstanceProperties().getProperty(CONST_DOMAIN) + File.separator + TRUSTSTORE_LOCATION[0]);
            return new File[]{file};
        }
        if ("truststoreClient".equals(string) && this.isValidPlatformRoot(this.root).equals("")) {
            File file = new File(new File(this.dmProps.getInstanceProperties().getProperty(CONST_LOCATION)), this.dmProps.getInstanceProperties().getProperty(CONST_DOMAIN) + File.separator + TRUSTSTORE_CLIENT_LOCATION[0]);
            return new File[]{file};
        }
        if ("wsgen".equals(string) || "wsimport".equals(string)) {
            File file = new File(this.root, JWSDP_JAR);
            File file2 = new File(this.root, WEBSERVICES_TOOLS_JAR);
            File file3 = new File(this.root, WEBSERVICES_API_JAR);
            if (file2.exists()) {
                if (this.isValidPlatformRoot(this.root).equals("")) {
                    if (file3.exists()) {
                        return new File[]{new File(this.root, WEBSERVICES_API_JAR), new File(this.root, WEBSERVICES_TOOLS_JAR), new File(this.root, WEBSERVICES_RT_JAR), new File(this.root, TOOLS_JAR), new File(this.root, JSTL_JAR), new File(this.root, JAVA_EE_JAR), new File(this.root, APPSERV_WS_JAR), new File(this.root, MAIL_JAR), new File(this.root, ACTIVATION_JAR)};
                    }
                    return new File[]{new File(this.root, WEBSERVICES_TOOLS_JAR), new File(this.root, WEBSERVICES_RT_JAR), new File(this.root, TOOLS_JAR), new File(this.root, JSTL_JAR), new File(this.root, JAVA_EE_JAR), new File(this.root, APPSERV_WS_JAR), new File(this.root, MAIL_JAR), new File(this.root, ACTIVATION_JAR)};
                }
            } else if (file.exists()) {
                if (this.isValidPlatformRoot(this.root).equals("")) {
                    return new File[]{new File(this.root, JWSDP_JAR), new File(this.root, JAXWSA_API_JAR), new File(this.root, JAXWSA_RI_JAR), new File(this.root, TOOLS_JAR), new File(this.root, JSTL_JAR), new File(this.root, JAVA_EE_JAR), new File(this.root, APPSERV_WS_JAR), new File(this.root, MAIL_JAR), new File(this.root, ACTIVATION_JAR)};
                }
            } else if (this.isValidPlatformRoot(this.root).equals("")) {
                return new File[]{new File(this.root, TOOLS_JAR), new File(this.root, JSTL_JAR), new File(this.root, JAVA_EE_JAR), new File(this.root, APPSERV_WS_JAR), new File(this.root, MAIL_JAR), new File(this.root, ACTIVATION_JAR)};
            }
        }
        return new File[0];
    }

    public boolean isToolSupported(String string) {
        if ("wscompile".equals(string) || "appClientRuntime".equals(string)) {
            return true;
        }
        if ("wsgen".equals(string)) {
            return true;
        }
        if ("wsimport".equals(string)) {
            return true;
        }
        if ("jsr109".equals(string)) {
            return true;
        }
        if ("jwsdp".equals(string) && new File(this.root, JWSDP_JAR).exists()) {
            return true;
        }
        if ("wsit".equals(string) && new File(this.root, WEBSERVICES_TOOLS_JAR).exists()) {
            return true;
        }
        if ("keystore".equals(string)) {
            return true;
        }
        if ("keystoreClient".equals(string)) {
            return true;
        }
        if ("truststore".equals(string)) {
            return true;
        }
        if ("truststoreClient".equals(string)) {
            return true;
        }
        if ("jaxws-tester".equals(string)) {
            return true;
        }
        if (PERSISTENCE_PROV_TOPLINK.equals(string)) {
            return true;
        }
        if (PERSISTENCE_PROV_TOPLINK_DEFAULT.equals(string)) {
            return true;
        }
        if ("org.hibernate.ejb.HibernatePersistence".equals(string) || "kodo.persistence.PersistenceProviderImpl".equals(string) || "org.apache.openjpa.persistence.PersistenceProviderImpl".equals(string)) {
            return true;
        }
        return "defaultPersistenceProviderJavaEE5".equals(string);
    }

    public Set getSupportedSpecVersions() {
        return SPEC_VERSIONS_WITH_5;
    }

    public Set getSupportedModuleTypes() {
        return MODULE_TYPES;
    }

    public Set getSupportedJavaPlatformVersions() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("1.5");
        hashSet.add("1.6");
        return hashSet;
    }

    public JavaPlatform getJavaPlatform() {
        if (this.dmProps.getSunDeploymentManager().isLocal()) {
            Asenv asenv = new Asenv(this.root);
            File file = new File(asenv.get("AS_JAVA"));
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
            if (fileObject != null) {
                JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("J2SE", null));
                for (int i = 0; i < javaPlatformArray.length; ++i) {
                    JavaPlatform javaPlatform = javaPlatformArray[i];
                    for (FileObject fileObject2 : javaPlatform.getInstallFolders()) {
                        if (!fileObject2.equals(fileObject)) continue;
                        return javaPlatform;
                    }
                }
            }
        }
        return null;
    }

    private URL fileToUrl(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        }
        return uRL;
    }

    private String quotedString(String string) {
        return "\"" + string + "\"";
    }

    public String getToolProperty(String string, String string2) {
        if ("appClientRuntime".equals(string)) {
            if ("main.class".equals(string2)) {
                return "com.sun.enterprise.appclient.Main";
            }
            if ("main.class.args".equals(string2)) {
                return "-client ${dist.jar} ${j2ee.appclient.tool.args}";
            }
            if ("jvm.opts".equals(string2)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("-Dcom.sun.aas.configRoot=").append(this.quotedString(new File(this.root, "config").getAbsolutePath()));
                stringBuilder.append(" -Dcom.sun.aas.installRoot=").append(this.quotedString(this.root.getAbsolutePath()));
                stringBuilder.append(" -Dcom.sun.aas.imqLib=").append(this.quotedString(new File(this.root, "imq/lib").getAbsolutePath()));
                stringBuilder.append(" -Djava.security.policy=").append(this.quotedString(new File(this.root, "lib/appclient/client.policy").getAbsolutePath()));
                stringBuilder.append(" -Djava.security.auth.login.config=").append(this.quotedString(new File(this.root, "lib/appclient/appclientlogin.conf").getAbsolutePath()));
                stringBuilder.append(" -Djava.endorsed.dirs=").append(this.quotedString(new File(this.root, "lib/endorsed").getAbsolutePath()));
                stringBuilder.append(" -Djavax.xml.parsers.SAXParserFactory=com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
                stringBuilder.append(" -Djavax.xml.parsers.DocumentBuilderFactory=com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
                stringBuilder.append(" -Djavax.xml.transform.TransformerFactory=com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                stringBuilder.append(" -Dorg.xml.sax.parser=org.xml.sax.helpers.XMLReaderAdapter");
                stringBuilder.append(" -Dorg.xml.sax.driver=com.sun.org.apache.xerces.internal.parsers.SAXParser");
                stringBuilder.append(" -Djava.util.logging.manager=com.sun.enterprise.server.logging.ACCLogManager");
                return stringBuilder.toString();
            }
            if ("client.jar.location".equals(string2)) {
                File file = new File(this.root, JAVA_EE_JAR);
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.dmProps.getLocation())));
                if (fileObject == null) {
                    return null;
                }
                FileObject fileObject2 = fileObject.getFileObject(this.dmProps.getInstanceProperties().getProperty("DOMAIN"));
                if (fileObject2 == null) {
                    return null;
                }
                if (file.exists()) {
                    FileObject fileObject3 = fileObject2.getFileObject("generated/xml/j2ee-modules");
                    if (fileObject3 != null) {
                        return FileUtil.toFile((FileObject)fileObject3).getAbsolutePath();
                    }
                } else {
                    FileObject fileObject4 = fileObject2.getFileObject("applications/j2ee-modules");
                    if (fileObject4 != null) {
                        return FileUtil.toFile((FileObject)fileObject4).getAbsolutePath();
                    }
                }
                return null;
            }
            if ("j2ee.appclient.args".equals(string2)) {
                return "-configxml " + this.quotedString(new File(this.dmProps.getLocation(), this.dmProps.getDomainName() + "/config/sun-acc.xml").getAbsolutePath());
            }
        }
        return null;
    }

    public Lookup getLookup() {
        Lookup lookup = Lookups.fixed((Object[])new Object[]{this.root});
        return LookupProviderSupport.createCompositeLookup((Lookup)lookup, (String)"J2EE/DeploymentPlugins/J2EE/Lookup");
    }

    static {
        MODULE_TYPES.add(J2eeModule.WAR);
        MODULE_TYPES.add(J2eeModule.EAR);
        MODULE_TYPES.add(J2eeModule.EJB);
        MODULE_TYPES.add(J2eeModule.CONN);
        MODULE_TYPES.add(J2eeModule.CLIENT);
        SPEC_VERSIONS.add("1.4");
        SPEC_VERSIONS.add("1.3");
        SPEC_VERSIONS_WITH_5.add("1.5");
        SPEC_VERSIONS_WITH_5.add("1.4");
        SPEC_VERSIONS_WITH_5.add("1.3");
    }
}

