/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.DefaultTestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.openide.util.Parameters;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSession {
    private long failuresCount = 0L;
    private final LineConvertors.FileLocator fileLocator;
    private final SessionType sessionType;
    private final String name;
    private final SessionResult result;
    private final Project project;
    private final List<TestSuite> testSuites = new ArrayList<TestSuite>();
    private final List<String> output = new ArrayList<String>();
    private String startingMsg;
    private final TestRunnerNodeFactory nodeFactory;
    private RerunHandler rerunHandler;
    private OutputLineHandler lineHandler;
    private static final OutputLineHandler DEFAULT_LINE_HANDLER = new OutputLineHandler(){

        public void handleLine(OutputWriter outputWriter, String string) {
            outputWriter.println(string);
        }
    };

    public TestSession(String string, Project project, SessionType sessionType) {
        this(string, project, sessionType, new DefaultTestRunnerNodeFactory());
    }

    public TestSession(String string, Project project, SessionType sessionType, TestRunnerNodeFactory testRunnerNodeFactory) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"nodeFactory", (Object)testRunnerNodeFactory);
        this.name = string;
        this.project = project;
        this.fileLocator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        this.sessionType = sessionType;
        this.result = new SessionResult();
        this.nodeFactory = testRunnerNodeFactory;
    }

    public TestRunnerNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public RerunHandler getRerunHandler() {
        return this.rerunHandler;
    }

    public void setRerunHandler(RerunHandler rerunHandler) {
        Parameters.notNull((CharSequence)"rerunHandler", (Object)rerunHandler);
        this.rerunHandler = rerunHandler;
    }

    OutputLineHandler getOutputLineHandler() {
        return this.lineHandler != null ? this.lineHandler : DEFAULT_LINE_HANDLER;
    }

    public void setOutputLineHandler(OutputLineHandler outputLineHandler) {
        Parameters.notNull((CharSequence)"lineHandler", (Object)outputLineHandler);
        this.lineHandler = outputLineHandler;
    }

    public void setStartingMsg(String string) {
        this.startingMsg = string;
    }

    public String getStartingMsg() {
        return this.startingMsg;
    }

    public Project getProject() {
        return this.project;
    }

    public Testcase getCurrentTestCase() {
        if (this.getCurrentSuite() == null) {
            return null;
        }
        List<Testcase> list = this.getCurrentSuite().getTestcases();
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private List<Testcase> getAllTestCases() {
        ArrayList<Testcase> arrayList = new ArrayList<Testcase>();
        for (TestSuite testSuite : this.testSuites) {
            arrayList.addAll(testSuite.getTestcases());
        }
        return arrayList;
    }

    public void addSuite(TestSuite testSuite) {
        Testcase testcase;
        Parameters.notNull((CharSequence)"suite", (Object)testSuite);
        if (!this.output.isEmpty() && this.getCurrentSuite() != null && (testcase = this.getCurrentSuite().getLastTestCase()) != null) {
            testcase.addOutputLines(this.output);
            this.output.clear();
        }
        this.testSuites.add(testSuite);
    }

    public void addOutput(String string) {
        this.output.add(string);
    }

    public void addTestCase(Testcase testcase) {
        assert (!this.testSuites.isEmpty()) : "No suites running";
        if (testcase.getClassName() != null) {
            for (Testcase testcase2 : this.getAllTestCases()) {
                if (!testcase.getClassName().equals(testcase2.getClassName()) || !testcase.getName().equals(testcase2.getName())) continue;
                return;
            }
        }
        testcase.addOutputLines(this.output);
        this.output.clear();
        this.getCurrentSuite().addTestcase(testcase);
    }

    public TestSuite getCurrentSuite() {
        return this.testSuites.isEmpty() ? null : this.testSuites.get(this.testSuites.size() - 1);
    }

    public Report getReport(long l) {
        Report report = new Report(this.getCurrentSuite().getName(), this.project);
        report.setElapsedTimeMillis(l);
        for (Testcase testcase : this.getCurrentSuite().getTestcases()) {
            report.reportTest(testcase);
            report.setTotalTests(report.getTotalTests() + 1);
            if (testcase.getStatus() == Status.ERROR) {
                report.setErrors(report.getErrors() + 1);
                continue;
            }
            if (testcase.getStatus() == Status.FAILED) {
                report.setFailures(report.getFailures() + 1);
                continue;
            }
            if (testcase.getStatus() != Status.PENDING) continue;
            report.setPending(report.getPending() + 1);
        }
        this.addReportToSessionResult(report);
        return report;
    }

    private void addReportToSessionResult(Report report) {
        this.result.elapsedTime(report.getElapsedTimeMillis());
        this.result.failed(report.getFailures());
        this.result.passed(report.getDetectedPassedTests());
        this.result.pending(report.getPending());
        this.result.errors(report.getErrors());
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public synchronized long incrementFailuresCount() {
        return ++this.failuresCount;
    }

    public LineConvertors.FileLocator getFileLocator() {
        return this.fileLocator;
    }

    public String getName() {
        return this.name;
    }

    public SessionResult getSessionResult() {
        return this.result;
    }

    public static final class SessionResult {
        private int passed;
        private int failed;
        private int errors;
        private int pending;
        private long elapsedTime;

        private int failed(int n) {
            return this.failed += n;
        }

        private int errors(int n) {
            return this.errors += n;
        }

        private int passed(int n) {
            return this.passed += n;
        }

        private int pending(int n) {
            return this.pending += n;
        }

        private long elapsedTime(long l) {
            return this.elapsedTime += l;
        }

        public int getErrors() {
            return this.errors;
        }

        public int getFailed() {
            return this.failed;
        }

        public int getPassed() {
            return this.passed;
        }

        public int getPending() {
            return this.pending;
        }

        public int getTotal() {
            return this.getPassed() + this.getFailed() + this.getErrors() + this.getPending();
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionType {
        TEST,
        DEBUG;

    }
}

