/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RootNodeChildren
extends Children.Keys<TestsuiteNode> {
    private volatile boolean filtered;
    private Collection<Report> reports;
    private volatile int passedSuites;
    private volatile int failedSuites;
    private volatile boolean live = false;
    private String runningSuiteName;
    private TestsuiteNode runningSuiteNode;
    private final TestSession session;
    private List<TestsuiteNode> suiteNodes = new ArrayList<TestsuiteNode>();
    private static final TestsuiteNode[] EMPTY_NODE_ARRAY = new TestsuiteNode[0];

    RootNodeChildren(TestSession testSession, boolean bl) {
        this.filtered = bl;
        this.session = testSession;
    }

    void displaySuiteRunning(String string) {
        assert (EventQueue.isDispatchThread());
        this.runningSuiteName = string;
        if (this.live) {
            this.runningSuiteNode = this.session.getNodeFactory().createTestSuiteNode(string, this.filtered);
            this.suiteNodes.add(this.runningSuiteNode);
            this.addNotify();
        }
        assert (this.runningSuiteName != null);
        assert (this.runningSuiteNode != null == this.live);
    }

    void displaySuiteRunning(TestSuite testSuite) {
        assert (EventQueue.isDispatchThread());
        this.runningSuiteName = testSuite.getName();
        if (this.live) {
            this.runningSuiteNode = this.session.getNodeFactory().createTestSuiteNode(testSuite.getName(), this.filtered);
            this.runningSuiteNode.setSuite(testSuite);
            this.suiteNodes.add(this.runningSuiteNode);
            this.addNotify();
        }
        assert (this.runningSuiteName != null);
        assert (this.runningSuiteNode != null == this.live);
    }

    Collection<Report> getReports() {
        return this.reports;
    }

    public TestsuiteNode displayReport(Report report) {
        TestsuiteNode testsuiteNode;
        assert (EventQueue.isDispatchThread());
        assert (this.runningSuiteNode != null == (this.live && this.runningSuiteName != null)) : "runningSuiteNode: " + (Object)((Object)this.runningSuiteNode) + ", live: " + this.live + ", runningSuiteName: " + this.runningSuiteName;
        if (this.reports == null) {
            this.reports = new ArrayList<Report>(10);
        }
        if (!this.reports.contains(report)) {
            this.reports.add(report);
        }
        boolean bl = this.updateStatistics(report);
        if (this.runningSuiteName != null) {
            if (this.live) {
                testsuiteNode = this.runningSuiteNode;
                if (report.completed || !this.filtered || !bl) {
                    testsuiteNode.displayReport(report);
                }
                if (this.filtered && bl && report.completed) {
                    this.runningSuiteNode = null;
                    this.refreshKey((Object)testsuiteNode);
                }
            } else {
                testsuiteNode = null;
            }
        } else if (!(!this.live || this.filtered && bl && report.completed)) {
            testsuiteNode = this.getNode(report);
            this.refreshKey((Object)testsuiteNode);
        } else {
            testsuiteNode = null;
        }
        if (report.completed) {
            this.runningSuiteName = null;
            this.runningSuiteNode = null;
        }
        return testsuiteNode;
    }

    void displayReports(Collection<Report> collection) {
        assert (EventQueue.isDispatchThread());
        if (this.reports == null) {
            this.reports = new ArrayList<Report>(collection);
        } else {
            this.reports.addAll(collection);
        }
        if (!this.live) {
            for (Report report : this.reports) {
                this.updateStatistics(report);
            }
        } else {
            if (!this.filtered) {
                Node[] nodeArray = new Node[collection.size()];
                int n = 0;
                for (Report report : collection) {
                    this.updateStatistics(report);
                    nodeArray[n++] = this.getNode(report);
                }
            } else {
                ArrayList<TestsuiteNode> arrayList = new ArrayList<TestsuiteNode>(collection.size());
                for (Report report : collection) {
                    boolean bl = this.updateStatistics(report);
                    if (!bl) continue;
                    arrayList.add(this.getNode(report));
                }
                if (!arrayList.isEmpty()) {
                    Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
                }
            }
            this.addNotify();
        }
    }

    private boolean updateStatistics(Report report) {
        this.passedSuites = 0;
        this.failedSuites = 0;
        for (Report report2 : this.reports) {
            boolean bl;
            boolean bl2 = bl = !report2.containsFailed();
            if (bl) {
                ++this.passedSuites;
                continue;
            }
            ++this.failedSuites;
        }
        return !report.containsFailed();
    }

    protected void addNotify() {
        super.addNotify();
        this.live = true;
        this.setKeys(this.suiteNodes);
    }

    protected void removeNotify() {
        super.removeNotify();
        this.live = false;
        this.setKeys((Object[])EMPTY_NODE_ARRAY);
    }

    private TestsuiteNode getNode(Report report) {
        for (TestsuiteNode testsuiteNode : this.suiteNodes) {
            if (testsuiteNode.getReport() != report) continue;
            return testsuiteNode;
        }
        Object object = new TestsuiteNode(report, this.filtered);
        this.suiteNodes.add((TestsuiteNode)((Object)object));
        return object;
    }

    synchronized void setFiltered(boolean bl) {
        assert (EventQueue.isDispatchThread());
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        if (!this.live || this.reports == null) {
            return;
        }
        for (TestsuiteNode testsuiteNode : this.suiteNodes) {
            testsuiteNode.setFiltered(bl);
            this.refreshKey((Object)testsuiteNode);
        }
    }

    protected Node[] createNodes(TestsuiteNode testsuiteNode) {
        Report report = testsuiteNode.getReport();
        if (this.filtered && testsuiteNode != this.runningSuiteNode && report != null && !report.containsFailed()) {
            return EMPTY_NODE_ARRAY;
        }
        return new Node[]{testsuiteNode};
    }
}

