/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RootNodeChildren;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RootNode
extends AbstractNode {
    static final int ALL_PASSED_ABSENT = 0;
    static final int SOME_PASSED_ABSENT = 1;
    static final int ALL_PASSED_DISPLAYED = 2;
    private final RootNodeChildren children;
    private volatile boolean filtered;
    private volatile String message;
    private volatile int totalTests = 0;
    private volatile int failures = 0;
    private volatile int errors = 0;
    private volatile int pending = 0;
    private volatile long elapsedTimeMillis = 0L;
    private volatile int detectedPassedTests = 0;
    private boolean sessionFinished;
    private final TestSession session;
    private static final Logger LOGGER = Logger.getLogger(RootNode.class.getName());

    public RootNode(TestSession testSession, boolean bl) {
        super((Children)new RootNodeChildren(testSession, bl));
        this.session = testSession;
        this.filtered = bl;
        this.children = (RootNodeChildren)this.getChildren();
        this.setName(NbBundle.getMessage(RootNode.class, (String)"MSG_RunningTests"));
        this.setIconBaseWithExtension("org/netbeans/modules/gsf/testrunner/resources/empty.gif");
    }

    void displayMessage(String string) {
        assert (EventQueue.isDispatchThread());
        this.message = string;
        this.updateDisplayName();
    }

    void displayMessageSessionFinished(String string) {
        this.sessionFinished = true;
        this.displayMessage(string);
    }

    void displaySuiteRunning(String string) {
        assert (EventQueue.isDispatchThread());
        this.children.displaySuiteRunning(string);
    }

    void displaySuiteRunning(TestSuite testSuite) {
        assert (EventQueue.isDispatchThread());
        this.children.displaySuiteRunning(testSuite);
    }

    public TestsuiteNode displayReport(Report report) {
        assert (EventQueue.isDispatchThread());
        TestsuiteNode testsuiteNode = this.children.displayReport(report);
        this.updateStatistics();
        this.updateDisplayName();
        return testsuiteNode;
    }

    void displayReports(Collection<Report> collection) {
        assert (EventQueue.isDispatchThread());
        this.children.displayReports(collection);
        this.updateStatistics();
        this.updateDisplayName();
    }

    private synchronized void updateStatistics() {
        this.totalTests = 0;
        this.failures = 0;
        this.errors = 0;
        this.pending = 0;
        this.detectedPassedTests = 0;
        this.elapsedTimeMillis = 0L;
        for (Report report : this.children.getReports()) {
            this.totalTests += report.getTotalTests();
            this.failures += report.getFailures();
            this.errors += report.getErrors();
            this.pending += report.getPending();
            this.detectedPassedTests += report.getDetectedPassedTests();
            this.elapsedTimeMillis += report.getElapsedTimeMillis();
        }
    }

    float getPassedPercentage() {
        return (float)this.detectedPassedTests / (float)this.totalTests * 100.0f;
    }

    void setFiltered(boolean bl) {
        assert (EventQueue.isDispatchThread());
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((RootNodeChildren)children).setFiltered(bl);
        }
    }

    private void updateDisplayName() {
        String string;
        assert (EventQueue.isDispatchThread());
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (this.totalTests == 0) {
            string = this.sessionFinished ? NbBundle.getMessage(clazz, (String)"MSG_TestsInfoNoTests") : null;
        } else if (this.failures == 0 && this.errors == 0 && this.pending == 0) {
            string = NbBundle.getMessage(clazz, (String)"MSG_TestsInfoAllOK", (Object)new Integer(this.totalTests));
        } else {
            String string2 = NbBundle.getMessage(clazz, (String)"MSG_PassedTestsInfo", (Object)new Integer(this.totalTests - this.failures - this.errors - this.pending));
            String string3 = this.pending == 0 ? null : NbBundle.getMessage(clazz, (String)"MSG_PendingTestsInfo", (Object)new Integer(this.errors));
            String string4 = this.failures == 0 ? null : NbBundle.getMessage(clazz, (String)"MSG_FailedTestsInfo", (Object)new Integer(this.failures));
            String string5 = this.errors == 0 ? null : NbBundle.getMessage(clazz, (String)"MSG_ErrorTestsInfo", (Object)new Integer(this.errors));
            string = this.constructMessage(string2, string3, string4, string5);
        }
        if (this.totalTests != 0) {
            assert (string != null);
            int n = this.getSuccessDisplayedLevel();
            switch (n) {
                case 1: {
                    string = string + ' ';
                    string = string + NbBundle.getMessage(clazz, (String)"MSG_SomePassedNotDisplayed");
                    break;
                }
                case 0: {
                    string = string + ' ';
                    string = string + NbBundle.getMessage(clazz, (String)"MSG_PassedNotDisplayed");
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (string != null) {
            string = string + NbBundle.getMessage(clazz, (String)"MSG_TestSuiteElapsedTime", (Object)new Double((double)this.elapsedTimeMillis / 1000.0));
        }
        if (this.message != null) {
            string = string == null ? this.message : string + ' ' + this.message;
        }
        LOGGER.fine("Setting display name to: '" + string + "'. Total tests run: " + this.totalTests + ". Session finished: " + this.sessionFinished);
        this.setDisplayName(string);
    }

    String constructMessage(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string == null) continue;
            arrayList.add(string);
        }
        int n = arrayList.size();
        String string = "MSG_TestResultSummary" + (n - 1);
        return NbBundle.getMessage(RootNode.class, (String)string, (Object[])arrayList.toArray(new String[n]));
    }

    int getSuccessDisplayedLevel() {
        int n = this.totalTests - this.failures - this.errors;
        if (this.detectedPassedTests >= n) {
            return 2;
        }
        if (this.detectedPassedTests == 0) {
            return 0;
        }
        return 1;
    }

    public SystemAction[] getActions(boolean bl) {
        return new SystemAction[0];
    }
}

