/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.Testcase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Report {
    private String suiteClassName;
    private int totalTests;
    private int failures;
    private int errors;
    private int pending;
    private long elapsedTimeMillis;
    private int detectedPassedTests;
    private Collection<Testcase> tests;
    private LineConvertors.FileLocator fileLocator;
    private Project project;
    private boolean aborted;
    protected boolean completed;

    public Report(String string, Project project) {
        this.suiteClassName = string;
        this.project = project;
        this.fileLocator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        this.tests = new ArrayList<Testcase>(10);
        this.completed = true;
        this.aborted = false;
    }

    public LineConvertors.FileLocator getFileLocator() {
        return this.fileLocator;
    }

    public Project getProject() {
        return this.project;
    }

    public void reportTest(Testcase testcase) {
        this.tests.add(testcase);
        if (!Status.isFailure(testcase.getStatus())) {
            ++this.detectedPassedTests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Report report) {
        Report report2 = this;
        synchronized (report2) {
            this.suiteClassName = report.suiteClassName;
            this.totalTests = report.totalTests;
            this.failures = report.failures;
            this.errors = report.errors;
            this.pending = report.pending;
            this.elapsedTimeMillis = report.elapsedTimeMillis;
            this.detectedPassedTests = report.detectedPassedTests;
            this.tests = report.tests;
            this.completed = report.completed;
        }
    }

    public Status getStatus() {
        if (this.aborted) {
            return Status.ABORTED;
        }
        if (this.errors > 0) {
            return Status.ERROR;
        }
        if (this.failures > 0) {
            return Status.FAILED;
        }
        if (this.pending > 0) {
            return Status.PENDING;
        }
        return Status.PASSED;
    }

    public Collection<Testcase> getTests() {
        if (this.tests.isEmpty()) {
            List<Testcase> list = Collections.emptyList();
            return list;
        }
        return new ArrayList<Testcase>(this.tests);
    }

    public boolean containsFailed() {
        assert (EventQueue.isDispatchThread());
        return this.failures + this.errors != 0;
    }

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public void setSuiteClassName(String string) {
        this.suiteClassName = string;
    }

    public int getTotalTests() {
        return this.totalTests;
    }

    public void setTotalTests(int n) {
        this.totalTests = n;
    }

    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int n) {
        this.failures = n;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int n) {
        this.errors = n;
    }

    public int getPending() {
        return this.pending;
    }

    public void setPending(int n) {
        this.pending = n;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public void setElapsedTimeMillis(long l) {
        this.elapsedTimeMillis = l;
    }

    public int getDetectedPassedTests() {
        return this.detectedPassedTests;
    }

    public void setDetectedPassedTests(int n) {
        this.detectedPassedTests = n;
    }

    public void setTests(Collection<Testcase> collection) {
        this.tests = collection;
    }

    public void setFileLocator(LineConvertors.FileLocator fileLocator) {
        this.fileLocator = fileLocator;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean bl) {
        this.aborted = bl;
    }
}

