/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.TestHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizerHandler;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUnitHandlerFactory
implements TestHandlerFactory {
    private static final Logger LOGGER = Logger.getLogger(TestUnitHandlerFactory.class.getName());

    @Override
    public boolean printSummary() {
        return true;
    }

    @Override
    public List<TestRecognizerHandler> createHandlers() {
        ArrayList<TestRecognizerHandler> arrayList = new ArrayList<TestRecognizerHandler>();
        arrayList.add(new SuiteStartingHandler());
        arrayList.add(new SuiteStartedHandler());
        arrayList.add(new SuiteFinishedHandler());
        arrayList.add(new SuiteErrorOutputHandler());
        arrayList.add(new ShouldaTestStartedHandler());
        arrayList.add(new ShouldaTestFailedHandler());
        arrayList.add(new ShouldaTestErrorHandler());
        arrayList.add(new TestStartedHandler());
        arrayList.add(new TestFailedHandler());
        arrayList.add(new TestErrorHandler());
        arrayList.add(new ShouldaTestFinishedHandler());
        arrayList.add(new TestFinishedHandler());
        arrayList.add(new TestLoggerHandler());
        arrayList.add(new TestMiscHandler());
        arrayList.add(new SuiteMiscHandler());
        return arrayList;
    }

    private static String errorMsg(long l) {
        return NbBundle.getMessage(TestUnitHandlerFactory.class, (String)"MSG_Error", (Object)l);
    }

    private static String failureMsg(long l) {
        return NbBundle.getMessage(TestUnitHandlerFactory.class, (String)"MSG_Failure", (Object)l);
    }

    static String[] getStackTrace(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        for (String string3 : string2.split("%BR%")) {
            if (TestRunnerUtilities.filterOutFromStacktrace(string3)) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static class TestLoggerHandler
    extends TestRecognizerHandler {
        public TestLoggerHandler() {
            super("%TEST_LOGGER%\\slevel=(.+)\\smsg=(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Level level = Level.parse(this.matcher.group(1));
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, this.matcher.group(2));
            }
        }
    }

    static class SuiteMiscHandler
    extends TestRecognizerHandler {
        public SuiteMiscHandler() {
            super("%SUITE_.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class SuiteStartingHandler
    extends TestRecognizerHandler {
        private boolean firstSuite = true;

        public SuiteStartingHandler() {
            super("%SUITE_STARTING%\\s(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            if (this.firstSuite) {
                this.firstSuite = false;
                manager.testStarted(testSession);
            }
            String string = this.matcher.group(1);
            testSession.addSuite(new TestSuite(string));
            manager.displaySuiteRunning(testSession, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SuiteErrorOutputHandler
    extends TestRecognizerHandler {
        public SuiteErrorOutputHandler() {
            super("%SUITE_ERROR_OUTPUT%\\serror=(.*)");
        }

        @Override
        void updateUI(Manager manager, TestSession testSession) {
            manager.displayOutput(testSession, this.matcher.group(1), true);
            manager.displayOutput(testSession, "", false);
        }

        @Override
        List<String> getRecognizedOutput() {
            return Collections.singletonList(this.matcher.group(1));
        }
    }

    static class SuiteStartedHandler
    extends TestRecognizerHandler {
        public SuiteStartedHandler() {
            super("%SUITE_STARTED%\\s.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class SuiteFinishedHandler
    extends TestRecognizerHandler {
        public SuiteFinishedHandler() {
            super("%SUITE_FINISHED%\\stime=(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            manager.displayReport(testSession, testSession.getReport((long)SuiteFinishedHandler.toMillis(this.matcher.group(1))));
        }
    }

    static class TestMiscHandler
    extends TestRecognizerHandler {
        public TestMiscHandler() {
            super("%TEST_.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class ShouldaTestErrorHandler
    extends TestErrorHandler {
        public ShouldaTestErrorHandler() {
            super("%TEST_ERROR%\\stime=(.+)\\stestname=test:\\s(.+)\\.\\s\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }
    }

    static class ShouldaTestFinishedHandler
    extends TestFinishedHandler {
        public ShouldaTestFinishedHandler() {
            super("%TEST_FINISHED%\\stime=(.+)\\stest:\\s(.*)\\.\\s\\((.+)\\)");
        }
    }

    static class TestFinishedHandler
    extends TestRecognizerHandler {
        public TestFinishedHandler(String string) {
            super(string);
        }

        public TestFinishedHandler() {
            super("%TEST_FINISHED%\\stime=(.+)\\s(.+)\\((.+)\\)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.TEST_UNIT.name(), testSession);
            testcase.setTimeMillis((long)TestFinishedHandler.toMillis(this.matcher.group(1)));
            testcase.setClassName(this.matcher.group(3));
            testSession.addTestCase(testcase);
        }
    }

    static class ShouldaTestStartedHandler
    extends TestRecognizerHandler {
        public ShouldaTestStartedHandler() {
            super("%TEST_STARTED%\\stest:\\s(.*)\\.\\s\\((.+)\\)");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class TestStartedHandler
    extends TestRecognizerHandler {
        public TestStartedHandler() {
            super("%TEST_STARTED%\\s(.+)\\((.+)\\)");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestErrorHandler
    extends TestRecognizerHandler {
        private List<String> output;

        public TestErrorHandler() {
            this("%TEST_ERROR%\\stime=(.+)\\stestname=(.+)\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }

        public TestErrorHandler(String string) {
            super(string);
        }

        @Override
        void updateUI(Manager manager, TestSession testSession) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.TEST_UNIT.name(), testSession);
            testcase.setTimeMillis((long)TestErrorHandler.toMillis(this.matcher.group(1)));
            testcase.setClassName(this.matcher.group(3));
            testcase.setTrouble(new Trouble(true));
            testcase.getTrouble().setStackTrace(TestUnitHandlerFactory.getStackTrace(this.matcher.group(4), this.matcher.group(5)));
            testSession.addTestCase(testcase);
            String string = TestUnitHandlerFactory.errorMsg(testSession.incrementFailuresCount());
            String string2 = testcase.getName() + "(" + testcase.getClassName() + "):";
            this.output = new ArrayList<String>();
            this.output.add("");
            this.output.add(string);
            this.output.add(string2);
            this.output.addAll(Arrays.asList(testcase.getTrouble().getStackTrace()));
            this.output.add("");
            manager.displayOutput(testSession, "", false);
            manager.displayOutput(testSession, string, false);
            manager.displayOutput(testSession, string2, false);
            for (String string3 : testcase.getTrouble().getStackTrace()) {
                manager.displayOutput(testSession, string3, true);
            }
            manager.displayOutput(testSession, "", false);
            testcase.addOutputLines(this.output);
        }

        @Override
        List<String> getRecognizedOutput() {
            return new ArrayList<String>(this.output);
        }
    }

    static class ShouldaTestFailedHandler
    extends TestFailedHandler {
        public ShouldaTestFailedHandler() {
            super("%TEST_FAILED%\\stime=(.+)\\stestname=test:\\s(.*)\\.\\s\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestFailedHandler
    extends TestRecognizerHandler {
        private List<String> output;

        public TestFailedHandler(String string) {
            super(string);
        }

        public TestFailedHandler() {
            super("%TEST_FAILED%\\stime=(.+)\\stestname=(.+)\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }

        @Override
        void updateUI(Manager manager, TestSession testSession) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.TEST_UNIT.name(), testSession);
            testcase.setTimeMillis((long)TestFailedHandler.toMillis(this.matcher.group(1)));
            testcase.setClassName(this.matcher.group(3));
            testcase.setTrouble(new Trouble(false));
            String string = this.matcher.group(4);
            testcase.getTrouble().setComparisonFailure(TestFailedHandler.getComparisonFailure(string));
            String string2 = this.matcher.group(5);
            testcase.getTrouble().setStackTrace(TestUnitHandlerFactory.getStackTrace(string, string2));
            testSession.addTestCase(testcase);
            String string3 = TestUnitHandlerFactory.failureMsg(testSession.incrementFailuresCount());
            String string4 = testcase.getName() + "(" + testcase.getClassName() + "):";
            this.output = new ArrayList<String>();
            this.output.add("");
            this.output.add(string3);
            this.output.add(string4);
            this.output.addAll(Arrays.asList(testcase.getTrouble().getStackTrace()));
            this.output.add("");
            manager.displayOutput(testSession, "", false);
            manager.displayOutput(testSession, string3, false);
            manager.displayOutput(testSession, string4, false);
            for (String string5 : testcase.getTrouble().getStackTrace()) {
                manager.displayOutput(testSession, string5, false);
            }
            manager.displayOutput(testSession, "", false);
            testcase.addOutputLines(this.output);
        }

        @Override
        List<String> getRecognizedOutput() {
            return new ArrayList<String>(this.output);
        }
    }
}

