/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Trouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TestRecognizerHandler {
    private static final Logger LOGGER = Logger.getLogger(TestRecognizerHandler.class.getName());
    private static final Pattern[] STRING_COMPARISON = new Pattern[]{Pattern.compile("<\"(.*)\"> expected but was <\"(.*)\">.*"), Pattern.compile(".*expected \"(.*)\", got \"(.*)\".*")};
    protected final Pattern pattern;
    protected Matcher matcher;

    TestRecognizerHandler(String string) {
        if (!string.endsWith(".*")) {
            string = string + ".*";
        }
        if (!string.startsWith(".*")) {
            string = ".*" + string;
        }
        this.pattern = Pattern.compile(string, 32);
    }

    final boolean matches(String string) {
        return this.match(string).matches();
    }

    final Matcher match(String string) {
        this.matcher = this.pattern.matcher(string);
        return this.matcher;
    }

    abstract void updateUI(Manager var1, TestSession var2);

    List<String> getRecognizedOutput() {
        return Collections.emptyList();
    }

    protected static int toMillis(String string) {
        try {
            Double d = Double.parseDouble(string) * 1000.0;
            return d.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.log(Level.WARNING, "Could not parse time, returning 0", numberFormatException);
            return 0;
        }
    }

    protected static Trouble.ComparisonFailure getComparisonFailure(String string) {
        if (string == null) {
            return null;
        }
        for (Pattern pattern : STRING_COMPARISON) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            return new Trouble.ComparisonFailure(TestRecognizerHandler.toMultipleLines(matcher.group(1)), TestRecognizerHandler.toMultipleLines(matcher.group(2)));
        }
        return null;
    }

    private static String toMultipleLines(String string) {
        return string.replace("\\n", "\n");
    }
}

