/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.RubyTestingSettings;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.RubyOutputLineHandler;
import org.netbeans.modules.ruby.testrunner.RubyTestRunnerNodeFactory;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerInputProcessorFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerLineConvertor;
import org.netbeans.modules.ruby.testrunner.ui.TestUnitHandlerFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUnitRunner
implements TestRunner,
RakeTaskCustomizer {
    private static final Logger LOGGER = Logger.getLogger(TestUnitRunner.class.getName());
    private static final String NB_TEST_RUNNER = "NB_TEST_RUNNER";
    static final String MEDIATOR_SCRIPT_NAME = "nb_test_mediator.rb";
    static final String TEST_RUNNER_SCRIPT_NAME = "nb_test_runner.rb";
    static final String SUITE_RUNNER_SCRIPT_NAME = "nb_suite_runner.rb";
    private static final TestRunner INSTANCE = new TestUnitRunner();

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public void runSingleTest(FileObject fileObject, String string, boolean bl) {
        List<String> list = this.getTestFileArgs(fileObject);
        list.add("-m");
        list.add(string);
        this.run(FileOwnerQuery.getOwner((FileObject)fileObject), list, string, bl);
    }

    public void runTest(FileObject fileObject, boolean bl) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (!fileObject.isFolder()) {
            this.run(project, this.getTestFileArgs(fileObject), fileObject.getName(), bl);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-d");
            arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
            String string = ProjectUtils.getInformation((Project)project).getDisplayName();
            this.run(project, arrayList, string, bl);
        }
    }

    private List<String> getTestFileArgs(FileObject fileObject) {
        String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-f");
        arrayList.add(string);
        return arrayList;
    }

    private static File getScript(String string) {
        File file = InstalledFileLocator.getDefault().locate(string, "org.netbeans.modules.ruby.testrunner", false);
        if (file == null) {
            throw new IllegalStateException("Could not locate " + string);
        }
        return file;
    }

    static void addTestUnitRunnerToEnv(Map<String, String> map) {
        map.put(NB_TEST_RUNNER, TestUnitRunner.getScript(TEST_RUNNER_SCRIPT_NAME).getAbsolutePath());
    }

    public void runAllTests(Project project, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RubyBaseProject rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        for (FileObject fileObject : rubyBaseProject.getTestSourceRootFiles()) {
            arrayList.add("-d");
            arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        }
        String string = ProjectUtils.getInformation((Project)project).getDisplayName();
        this.run(project, arrayList, string, bl);
    }

    private void run(Project project, List<String> list, String string, boolean bl) {
        LineConvertors.FileLocator fileLocator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        String string2 = TestUnitRunner.getScript(MEDIATOR_SCRIPT_NAME).getAbsolutePath();
        RubyExecutionDescriptor rubyExecutionDescriptor = null;
        Object var9_9 = null;
        rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, string, FileUtil.toFile((FileObject)project.getProjectDirectory()), string2);
        rubyExecutionDescriptor.additionalArgs(list.toArray(new String[list.size()]));
        TestRunnerUtilities.addProperties(rubyExecutionDescriptor, project);
        rubyExecutionDescriptor.addInitialArgs(RubyProjectUtil.getLoadPath((Project)project));
        rubyExecutionDescriptor.debug(bl);
        rubyExecutionDescriptor.allowInput();
        rubyExecutionDescriptor.fileLocator(fileLocator);
        rubyExecutionDescriptor.addStandardRecognizers();
        RubyCoverageProvider rubyCoverageProvider = RubyCoverageProvider.get((Project)project);
        if (rubyCoverageProvider != null && rubyCoverageProvider.isEnabled()) {
            rubyExecutionDescriptor = rubyCoverageProvider.wrapWithCoverage(rubyExecutionDescriptor, false, null);
        }
        TestSession testSession = new TestSession(string, project, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        TestExecutionManager.getInstance().start(rubyExecutionDescriptor, new TestUnitHandlerFactory(), testSession);
    }

    public boolean supports(TestRunner.TestType testType) {
        return testType == TestRunner.TestType.TEST_UNIT;
    }

    public void customize(Project project, RakeTask rakeTask, RubyExecutionDescriptor rubyExecutionDescriptor, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = RubyTestingSettings.getDefault().useRunner(TestRunner.TestType.TEST_UNIT) && TestRunnerUtilities.useTestRunner(project, "test.tasks", rakeTask, TestUnitTaskEvaluator.INSTANCE);
        if (!bl2) {
            return;
        }
        TestExecutionManager.getInstance().reset();
        rakeTask.addRakeParameters(new String[]{"-r \"" + TestUnitRunner.getScript(TEST_RUNNER_SCRIPT_NAME).getAbsolutePath() + "\""});
        TestSession testSession = new TestSession(rakeTask.getDisplayName(), project, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        TestUnitRunner.addTestUnitRunnerToEnv(hashMap);
        rubyExecutionDescriptor.addAdditionalEnv(hashMap);
        Manager manager = Manager.getInstance();
        final TestRunnerLineConvertor testRunnerLineConvertor = new TestRunnerLineConvertor(manager, testSession, new TestUnitHandlerFactory());
        testSession.setOutputLineHandler((OutputLineHandler)new RubyOutputLineHandler(testSession.getFileLocator()));
        rubyExecutionDescriptor.addStandardRecognizers();
        rubyExecutionDescriptor.addOutConvertor((LineConvertor)testRunnerLineConvertor);
        rubyExecutionDescriptor.addErrConvertor((LineConvertor)testRunnerLineConvertor);
        rubyExecutionDescriptor.lineBased(true);
        rubyExecutionDescriptor.setOutProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new TestRunnerInputProcessorFactory(manager, testSession, true));
        rubyExecutionDescriptor.setErrProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new TestRunnerInputProcessorFactory(manager, testSession, false));
        rubyExecutionDescriptor.postBuild(new Runnable(){

            public void run() {
                TestExecutionManager.getInstance().finish();
                testRunnerLineConvertor.refreshSession();
            }
        });
        TestExecutionManager.getInstance().init(rubyExecutionDescriptor);
        testSession.setRerunHandler((RerunHandler)TestExecutionManager.getInstance());
    }

    static {
        System.setProperty(NB_TEST_RUNNER, TestUnitRunner.getScript(TEST_RUNNER_SCRIPT_NAME).getAbsolutePath());
    }

    private static class TestUnitTaskEvaluator
    implements TestRunnerUtilities.DefaultTaskEvaluator {
        static final TestUnitTaskEvaluator INSTANCE = new TestUnitTaskEvaluator();

        private TestUnitTaskEvaluator() {
        }

        public boolean isDefault(RakeTask rakeTask) {
            return "test".equals(rakeTask.getTask()) || rakeTask.getTask().startsWith("test:");
        }
    }
}

