/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.RubyTestingSettings;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.RubyOutputLineHandler;
import org.netbeans.modules.ruby.testrunner.RubyTestRunnerNodeFactory;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.RspecHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerInputProcessorFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerLineConvertor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RspecRunner
implements TestRunner,
RakeTaskCustomizer {
    private static final String PLUGIN_SPEC_PATH = "vendor/plugins/rspec/bin/spec";
    private static final String SCRIPT_SPEC_PATH = "script/spec";
    private static final String SPEC_BIN = "spec";
    private static final TestRunner INSTANCE = new RspecRunner();
    private static final String SPEC_OPTS = "spec/spec.opts";
    private static final String NETBEANS_SPEC_OPTS_SUFFIX = "netbeans";
    private static final String NETBEANS_SPEC_OPTS = "spec/spec.opts.netbeans";
    public static final String RSPEC_MEDIATOR_SCRIPT = "nb_rspec_mediator.rb";
    private static final String SPEC_OPTS_WARN_PROP = "ruby.rspec.specopts.warn";

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public boolean supports(TestRunner.TestType testType) {
        return TestRunner.TestType.RSPEC == testType;
    }

    private static boolean warnWhenUsingSpecOpts() {
        return Boolean.valueOf(System.getProperty(SPEC_OPTS_WARN_PROP, "true"));
    }

    public void runTest(FileObject fileObject, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        this.run(FileOwnerQuery.getOwner((FileObject)fileObject), arrayList2, fileObject.getName(), bl);
    }

    public void runSingleTest(FileObject fileObject, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--line");
        arrayList.add(string);
        arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        this.run(FileOwnerQuery.getOwner((FileObject)fileObject), arrayList, fileObject.getName(), bl);
    }

    public void runAllTests(Project project, boolean bl) {
        RubyBaseProject rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        FileObject[] fileObjectArray = rubyBaseProject.getTestSourceRootFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FileObject fileObject : fileObjectArray) {
            Enumeration enumeration = fileObject.getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.isFolder() || !"rb".equals(fileObject2.getExt()) || !fileObject2.getName().endsWith(SPEC_BIN)) continue;
                arrayList.add(FileUtil.toFile((FileObject)fileObject2).getAbsolutePath());
            }
        }
        this.run(project, arrayList, ProjectUtils.getInformation((Project)project).getDisplayName(), bl);
    }

    private void run(Project project, List<String> list, String string, boolean bl) {
        LineConvertors.FileLocator fileLocator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        if (list.isEmpty()) {
            TestSession testSession = new TestSession(string, project, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
            Manager.getInstance().emptyTestRun(testSession);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--require");
        arrayList.add(RspecRunner.getMediatorScript().getAbsolutePath());
        arrayList.add("--runner");
        arrayList.add("NbRspecMediator");
        FileObject fileObject = RspecRunner.addSpecOpts(project, list);
        arrayList.addAll(list);
        RubyExecutionDescriptor rubyExecutionDescriptor = null;
        Object var10_11 = null;
        File file = this.getSpec(project);
        if (file == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RspecRunner.class, (String)"MSG_SpecNotFound"), 0));
            return;
        }
        rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, string, FileUtil.toFile((FileObject)project.getProjectDirectory()), this.getSpec(project).getAbsolutePath());
        rubyExecutionDescriptor.additionalArgs(arrayList.toArray(new String[arrayList.size()]));
        TestRunnerUtilities.addProperties(rubyExecutionDescriptor, project);
        rubyExecutionDescriptor.addInitialArgs(RubyProjectUtil.getLoadPath((Project)project));
        rubyExecutionDescriptor.debug(bl);
        rubyExecutionDescriptor.allowInput();
        rubyExecutionDescriptor.fileLocator(fileLocator);
        rubyExecutionDescriptor.addStandardRecognizers();
        RubyCoverageProvider rubyCoverageProvider = RubyCoverageProvider.get((Project)project);
        if (rubyCoverageProvider != null && rubyCoverageProvider.isEnabled()) {
            rubyExecutionDescriptor = rubyCoverageProvider.wrapWithCoverage(rubyExecutionDescriptor, false, null);
        }
        TestSession testSession = new TestSession(string, project, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        RspecRunner.addSpecOptsWarningIfNeeded(testSession, fileObject);
        TestExecutionManager.getInstance().start(rubyExecutionDescriptor, new RspecHandlerFactory(), testSession);
    }

    private File getSpec(Project project) {
        RubyPlatform rubyPlatform;
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject(SCRIPT_SPEC_PATH);
        if (fileObject2 != null) {
            return FileUtil.toFile((FileObject)fileObject2);
        }
        if (fileObject != null && (rubyPlatform = fileObject.getFileObject(PLUGIN_SPEC_PATH)) != null) {
            return FileUtil.toFile((FileObject)rubyPlatform);
        }
        rubyPlatform = RubyPlatform.platformFor((Project)project);
        String string = rubyPlatform.findExecutable(SPEC_BIN);
        if (string != null) {
            return new File(string);
        }
        return null;
    }

    static File getMediatorScript() {
        File file = InstalledFileLocator.getDefault().locate(RSPEC_MEDIATOR_SCRIPT, "org.netbeans.modules.ruby.testrunner", false);
        if (file == null) {
            throw new IllegalStateException("Could not locate nb_rspec_mediator.rb");
        }
        return file;
    }

    private static FileObject addSpecOpts(Project project, List<String> list) {
        FileObject fileObject = RspecRunner.getSpecOpts(project);
        if (fileObject != null) {
            list.add("--options");
            list.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        }
        return fileObject;
    }

    private static FileObject getSpecOpts(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject(NETBEANS_SPEC_OPTS);
        if (fileObject2 == null) {
            fileObject2 = fileObject.getFileObject(SPEC_OPTS);
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSpecOptsContent(FileObject fileObject) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append(" ");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return stringBuilder.toString();
    }

    private static void addSpecOptsWarningIfNeeded(TestSession testSession, FileObject fileObject) {
        if (fileObject == null || !RspecRunner.warnWhenUsingSpecOpts()) {
            return;
        }
        if (!NETBEANS_SPEC_OPTS_SUFFIX.equals(fileObject.getExt())) {
            testSession.setStartingMsg(NbBundle.getMessage(RspecRunner.class, (String)"MSG_SpecOptsWarning", (Object)SPEC_OPTS, (Object)NETBEANS_SPEC_OPTS, (Object)SPEC_OPTS_WARN_PROP));
        }
    }

    public void customize(Project project, RakeTask rakeTask, RubyExecutionDescriptor rubyExecutionDescriptor, boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3 = bl2 = RubyTestingSettings.getDefault().useRunner(TestRunner.TestType.RSPEC) && TestRunnerUtilities.useTestRunner(project, "spec.tasks", rakeTask, RSpecTaskEvaluator.INSTANCE);
        if (!bl2) {
            return;
        }
        TestExecutionManager.getInstance().reset();
        String string = RspecRunner.getMediatorScript().getAbsolutePath();
        if (Utilities.isWindows() && (object = RubyPlatform.platformFor((Project)project)) != null && object.isJRuby()) {
            string = string.replace('\\', '/');
        }
        object = "--require '" + string + "' --runner NbRspecMediator";
        FileObject fileObject = RspecRunner.getSpecOpts(project);
        if (fileObject != null) {
            object = (String)object + " " + this.getSpecOptsContent(fileObject);
        }
        rakeTask.addTaskParameters(new String[]{"SPEC_OPTS=" + (String)object});
        TestSession testSession = new TestSession(rakeTask.getDisplayName(), project, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        RspecRunner.addSpecOptsWarningIfNeeded(testSession, fileObject);
        Manager manager = Manager.getInstance();
        final TestRunnerLineConvertor testRunnerLineConvertor = new TestRunnerLineConvertor(manager, testSession, new RspecHandlerFactory());
        testSession.setOutputLineHandler((OutputLineHandler)new RubyOutputLineHandler(testSession.getFileLocator()));
        rubyExecutionDescriptor.addOutConvertor((LineConvertor)testRunnerLineConvertor);
        rubyExecutionDescriptor.addErrConvertor((LineConvertor)testRunnerLineConvertor);
        rubyExecutionDescriptor.lineBased(true);
        rubyExecutionDescriptor.setOutProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new TestRunnerInputProcessorFactory(manager, testSession, false));
        rubyExecutionDescriptor.setErrProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new TestRunnerInputProcessorFactory(manager, testSession, false));
        rubyExecutionDescriptor.postBuild(new Runnable(){

            public void run() {
                TestExecutionManager.getInstance().finish();
                testRunnerLineConvertor.refreshSession();
            }
        });
        TestExecutionManager.getInstance().init(rubyExecutionDescriptor);
    }

    private static class RSpecTaskEvaluator
    implements TestRunnerUtilities.DefaultTaskEvaluator {
        static final RSpecTaskEvaluator INSTANCE = new RSpecTaskEvaluator();

        private RSpecTaskEvaluator() {
        }

        public boolean isDefault(RakeTask rakeTask) {
            return RspecRunner.SPEC_BIN.equals(rakeTask.getTask());
        }
    }
}

