/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.common.Profiler;

public final class SessionSettings {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.Bundle");
    private static final String INCORRECT_PORT_MSG = bundle.getString("SessionSettings_IncorrectPortMsg");
    private static final String INCORRECT_ARCH_MSG = bundle.getString("SessionSettings_IncorrectArchMsg");
    public static final String PROP_CLASS_NAME = "profiler.session.class.name";
    public static final String PROP_CLASS_PATH = "profiler.session.class.path";
    public static final String PROP_ARGS = "profiler.session.args";
    public static final String PROP_JVM_ARGS = "profiler.session.jvm.args";
    public static final String PROP_WORKING_DIR = "profiler.session.working.dir";
    public static final String PROP_JAVA_EXECUTABLE = "profiler.session.java.executable";
    public static final String PROP_JAVA_VERSION = "profiler.session.java.version";
    public static final String PROP_ARCHITECTURE = "profiler.session.java.architecture";
    public static final String PROP_PORT_NO = "profiler.session.port.no";
    private String javaExecutable = "";
    private String javaVersionString = "";
    private String jvmArgs = "";
    private String mainArgs = "";
    private String mainClass = "";
    private String mainClassPath = "";
    private String workingDir = System.getProperty("user.dir");
    private int architecture = 32;
    private int portNo = 5140;

    public void setJVMArgs(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.jvmArgs = string;
    }

    public String getJVMArgs() {
        return this.jvmArgs;
    }

    public void setJavaExecutable(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.javaExecutable = string;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public void setJavaVersionString(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.javaVersionString = string;
    }

    public String getJavaVersionString() {
        return this.javaVersionString;
    }

    public void setMainArgs(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mainArgs = string;
    }

    public String getMainArgs() {
        return this.mainArgs;
    }

    public void setMainClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mainClass = string;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClassPath(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mainClassPath = string;
    }

    public String getMainClassPath() {
        return this.mainClassPath;
    }

    public void setPortNo(int n) {
        this.portNo = n;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public void setSystemArchitecture(int n) {
        this.architecture = n;
    }

    public int getSystemArchitecture() {
        return this.architecture;
    }

    public void setWorkingDir(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.workingDir = string;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void applySettings(ProfilerEngineSettings profilerEngineSettings) {
        profilerEngineSettings.setMainClass(this.mainClass);
        profilerEngineSettings.setMainClassPath(this.mainClassPath);
        profilerEngineSettings.setMainArgs(this.mainArgs);
        profilerEngineSettings.setJVMArgs(this.jvmArgs);
        profilerEngineSettings.setWorkingDir(this.workingDir);
        profilerEngineSettings.setTargetJVMExeFile(this.javaExecutable);
        profilerEngineSettings.setTargetJDKVersionString(this.javaVersionString);
        profilerEngineSettings.setSystemArchitecture(this.architecture);
        profilerEngineSettings.setPortNo(this.portNo);
    }

    public String debug() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mainClass: " + this.mainClass);
        stringBuffer.append('\n');
        stringBuffer.append("mainClassPath: " + this.mainClassPath);
        stringBuffer.append('\n');
        stringBuffer.append("mainArgs: " + this.mainArgs);
        stringBuffer.append('\n');
        stringBuffer.append("jvmArgs =" + this.jvmArgs);
        stringBuffer.append('\n');
        stringBuffer.append("workingDir =" + this.workingDir);
        stringBuffer.append('\n');
        stringBuffer.append("javaExecutable =" + this.javaExecutable);
        stringBuffer.append('\n');
        stringBuffer.append("javaVersionString =" + this.javaVersionString);
        stringBuffer.append('\n');
        stringBuffer.append("architecture =" + this.architecture);
        stringBuffer.append('\n');
        stringBuffer.append("portNo =" + this.portNo);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public void load(Map map) {
        this.setMainClass(SessionSettings.getProperty(map, PROP_CLASS_NAME, ""));
        this.setMainClassPath(SessionSettings.getProperty(map, PROP_CLASS_PATH, ""));
        this.setMainArgs(SessionSettings.getProperty(map, PROP_ARGS, ""));
        this.setJVMArgs(SessionSettings.getProperty(map, PROP_JVM_ARGS, ""));
        this.setWorkingDir(SessionSettings.getProperty(map, PROP_WORKING_DIR, System.getProperty("user.home")));
        this.setJavaExecutable(SessionSettings.getProperty(map, PROP_JAVA_EXECUTABLE, ""));
        this.setJavaVersionString(SessionSettings.getProperty(map, PROP_JAVA_VERSION, ""));
        String string = SessionSettings.getProperty(map, PROP_ARCHITECTURE, String.valueOf(32));
        try {
            this.setSystemArchitecture(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            Profiler.getDefault().displayWarning(INCORRECT_ARCH_MSG);
            this.architecture = 32;
        }
        String string2 = SessionSettings.getProperty(map, PROP_PORT_NO, "5140");
        try {
            this.setPortNo(Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            Profiler.getDefault().displayWarning(INCORRECT_PORT_MSG);
            this.portNo = 5140;
        }
    }

    public void store(Map map) {
        map.put(PROP_CLASS_NAME, this.mainClass);
        map.put(PROP_CLASS_PATH, this.mainClassPath);
        map.put(PROP_ARGS, this.mainArgs);
        map.put(PROP_JVM_ARGS, this.jvmArgs);
        map.put(PROP_WORKING_DIR, this.workingDir);
        map.put(PROP_JAVA_EXECUTABLE, this.javaExecutable);
        map.put(PROP_JAVA_VERSION, this.javaVersionString);
        map.put(PROP_ARCHITECTURE, Integer.toString(this.architecture));
        map.put(PROP_PORT_NO, Integer.toString(this.portNo));
    }

    private static String getProperty(Map map, String string, String string2) {
        String string3 = (String)map.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }
}

