/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.Container;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.visualizers.SourceSupportProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class SourceSupportProviderImpl
implements SourceSupportProvider {
    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(SourceSupportProviderImpl.class, (String)string, (Object[])stringArray);
    }

    public void showSource(SourceFileInfoProvider.SourceFileInfo sourceFileInfo, boolean bl) {
        File file = new File(sourceFileInfo.getFileName());
        FileObject fileObject = FileUtil.toFileObject((File)file);
        try {
            new ROEditor(fileObject).open();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
    }

    public void showSource(SourceFileInfoProvider.SourceFileInfo sourceFileInfo) {
        if (sourceFileInfo == null) {
            StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.NoInfo", new String[0]));
            return;
        }
        if (!sourceFileInfo.isSourceKnown()) {
            StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.UnknownSource", new String[0]));
            return;
        }
        String string = sourceFileInfo.getFileName();
        try {
            URI uRI;
            Object object;
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
            if (fileObject == null) {
                object = null;
                try {
                    uRI = new URI(sourceFileInfo.getFileName());
                    if (uRI.getScheme() != null && uRI.getScheme().equals("file")) {
                        fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(uRI)));
                    }
                    if (fileObject == null) {
                        String string2 = uRI.getRawPath();
                        int n = string2.lastIndexOf(47);
                        if (n == -1) {
                            return;
                        }
                        String string3 = string2.substring(n, string2.length());
                        object = uRI.toURL().openStream();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                        String string4 = null;
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((string4 = bufferedReader.readLine()) != null) {
                            stringBuffer.append(string4 + "\n");
                        }
                        bufferedReader.close();
                        ((InputStream)object).close();
                        string = System.getProperty("java.io.tmpdir") + File.separator + string3;
                        File file = new File(string);
                        file.deleteOnExit();
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write(stringBuffer.toString());
                        bufferedWriter.flush();
                        bufferedWriter.close();
                        fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = ErrorManager.getDefault().annotate(throwable, SourceSupportProviderImpl.loc("SourceSupportProviderImpl.CannotOpenFile", string));
                    ErrorManager.getDefault().notify(16, throwable2);
                    StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.CannotOpenFile", string));
                }
            }
            if (fileObject == null) {
                StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.CannotOpenFile", string));
                return;
            }
            object = DataObject.find((FileObject)fileObject);
            uRI = (EditorCookie.Observable)object.getCookie(EditorCookie.Observable.class);
            if (uRI != null) {
                SwingUtilities.invokeLater(new Runnable((DataObject)object, (EditorCookie.Observable)uRI, sourceFileInfo){
                    final /* synthetic */ DataObject val$dob;
                    final /* synthetic */ EditorCookie.Observable val$ec;
                    final /* synthetic */ SourceFileInfoProvider.SourceFileInfo val$lineInfo;
                    {
                        this.val$dob = dataObject;
                        this.val$ec = observable;
                        this.val$lineInfo = sourceFileInfo;
                    }

                    public void run() {
                        NbEditorUtilities.addJumpListEntry((DataObject)this.val$dob);
                        JEditorPane[] jEditorPaneArray = this.val$ec.getOpenedPanes();
                        boolean bl = true;
                        if (jEditorPaneArray != null && jEditorPaneArray.length >= 0) {
                            bl = true;
                        } else {
                            bl = false;
                            this.val$ec.open();
                            jEditorPaneArray = this.val$ec.getOpenedPanes();
                        }
                        if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                            SourceSupportProviderImpl.jumpToLine(jEditorPaneArray[0], this.val$lineInfo, !bl);
                        }
                    }
                });
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace(System.err);
            StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.CannotOpenFile", string));
        }
    }

    private static void jumpToLine(final JEditorPane jEditorPane, final SourceFileInfoProvider.SourceFileInfo sourceFileInfo, boolean bl) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                SourceSupportProviderImpl.jumpToLine(jEditorPane, sourceFileInfo);
            }
        });
        Container container = jEditorPane;
        while (!(container instanceof TopComponent)) {
            container = container.getParent();
        }
        if (container instanceof TopComponent) {
            ((TopComponent)container).open();
            ((TopComponent)container).requestActive();
            ((TopComponent)container).requestVisible();
        }
    }

    private static void jumpToLine(JEditorPane jEditorPane, SourceFileInfoProvider.SourceFileInfo sourceFileInfo) {
        int n = jEditorPane.getCaretPosition();
        Container container = jEditorPane.getParent();
        Point point = container instanceof JViewport ? ((JViewport)container).getViewPosition() : null;
        long l = sourceFileInfo.hasOffset() ? sourceFileInfo.getOffset() : (long)Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)jEditorPane.getDocument()), (int)(sourceFileInfo.getLine() - 1));
        if (jEditorPane.getDocument() != null && l >= 0L && l < (long)jEditorPane.getDocument().getLength()) {
            jEditorPane.setCaretPosition((int)l);
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    private static final class E
    extends DataEditorSupport.Env {
        public E(DataObject dataObject) {
            super(dataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            throw new IOException("No way!");
        }
    }

    final class ROEditor
    extends DataEditorSupport {
        private ROEditor(DataObject dataObject) {
            super(dataObject, (CloneableEditorSupport.Env)new E(dataObject));
        }

        public ROEditor(FileObject fileObject) throws DataObjectNotFoundException {
            this(DataObject.find((FileObject)fileObject));
        }
    }
}

