/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionsListDataProvider;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.AdvancedTableViewVisualizer;
import org.netbeans.modules.dlight.visualizers.FunctionsListSheetCell;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.SourceSupportProvider;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.VisualizersSupport;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.FunctionsListViewVisualizerConfigurationAccessor;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionsListViewVisualizer
extends JPanel
implements Visualizer<FunctionsListViewVisualizerConfiguration>,
OnTimerTask,
ComponentListener,
ExplorerManager.Provider {
    private Future<Boolean> task;
    private final Object queryLock = new String(FunctionsListViewVisualizer.class + " query lock");
    private final Object uiLock = new String(FunctionsListViewVisualizer.class + " UI lock");
    private JToolBar buttonsToolbar;
    private JButton refresh;
    private boolean isEmptyContent;
    private boolean isLoadingContent;
    private boolean isShown = true;
    private final OutlineView outlineView;
    private final ExplorerManager explorerManager;
    private final FunctionDatatableDescription functionDatatableDescription;
    private final FunctionsListDataProvider dataProvider;
    private final DataTableMetadata metadata;
    private final ColumnsUIMapping columnsUIMapping;
    private final List<DataTableMetadata.Column> metrics;
    private final FunctionsListViewVisualizerConfiguration configuration;
    private final TableCellRenderer outlineNodePropertyDefault;
    private final VisualizersSupport visSupport;
    private FunctionCallChildren currentChildren;
    private ExecutorService sourcePrefetchExecutor;
    private final String sourcePrefetchExecutorLock = new String("sourcePrefetchExecutorLock");
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private JComponent lastFocusedComponent = null;
    private Map<Integer, Boolean> ascColumnValues = new HashMap<Integer, Boolean>();
    private final SourceSupportProvider sourceSupportProvider = (SourceSupportProvider)Lookup.getDefault().lookup(SourceSupportProvider.class);

    public FunctionsListViewVisualizer(FunctionsListDataProvider functionsListDataProvider, FunctionsListViewVisualizerConfiguration functionsListViewVisualizerConfiguration) {
        this.visSupport = new VisualizersSupport(new VisualizerImplSessionStateListener());
        this.explorerManager = new ExplorerManager();
        this.configuration = functionsListViewVisualizerConfiguration;
        this.functionDatatableDescription = FunctionsListViewVisualizerConfigurationAccessor.getDefault().getFunctionDatatableDescription(functionsListViewVisualizerConfiguration);
        this.metrics = FunctionsListViewVisualizerConfigurationAccessor.getDefault().getMetricsList(functionsListViewVisualizerConfiguration);
        this.columnsUIMapping = FunctionsListViewVisualizerConfigurationAccessor.getDefault().getColumnsUIMapping(functionsListViewVisualizerConfiguration);
        this.dataProvider = functionsListDataProvider;
        this.metadata = functionsListViewVisualizerConfiguration.getMetadata();
        this.setLoadingContent();
        this.addComponentListener(this);
        String string = this.columnsUIMapping == null || this.columnsUIMapping.getDisplayedName(this.functionDatatableDescription.getNameColumn()) == null ? this.metadata.getColumnByName(this.functionDatatableDescription.getNameColumn()).getColumnUName() : this.columnsUIMapping.getDisplayedName(this.functionDatatableDescription.getNameColumn());
        this.outlineView = new OutlineView(string);
        this.outlineView.setDragSource(false);
        this.outlineView.setDropTarget(false);
        this.outlineView.setAllowedDragActions(0);
        this.outlineView.setAllowedDropActions(0);
        final Outline outline = this.outlineView.getOutline();
        outline.getTableHeader().setReorderingAllowed(false);
        outline.setRootVisible(false);
        outline.setDefaultRenderer(Object.class, (TableCellRenderer)new ExtendedTableCellRendererForNode());
        this.outlineNodePropertyDefault = this.outlineView.getOutline().getDefaultRenderer(Node.Property.class);
        outline.setDefaultRenderer(Node.Property.class, (TableCellRenderer)new FunctionsListSheetCell.OutlineSheetCell(this.outlineView.getOutline(), this.metrics));
        outline.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Action action;
                FunctionCallNode functionCallNode;
                int n = outline.rowAtPoint(mouseEvent.getPoint());
                if (n != -1 && SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && outline.getSelectedColumn() == 0 && (functionCallNode = FunctionsListViewVisualizer.this.findNodeByName("" + outline.getValueAt(n, 0))) != null && (action = functionCallNode.getGoToSourceAction()) != null) {
                    if (action.isEnabled()) {
                        action.actionPerformed(new ActionEvent((Object)functionCallNode, 1001, ""));
                    } else {
                        Logger.getLogger(OutlineView.class.getName()).info("Action " + action + " on node " + (Object)((Object)functionCallNode) + " is disabled");
                    }
                    mouseEvent.consume();
                    return;
                }
                super.mouseClicked(mouseEvent);
            }
        });
        ArrayList<2> arrayList = new ArrayList<2>();
        for (DataTableMetadata.Column column : this.metrics) {
            String string2 = this.columnsUIMapping == null || this.columnsUIMapping.getDisplayedName(column.getColumnName()) == null ? column.getColumnUName() : this.columnsUIMapping.getDisplayedName(column.getColumnName());
            String string3 = this.columnsUIMapping == null || this.columnsUIMapping.getTooltip(column.getColumnName()) == null ? column.getColumnLongUName() : this.columnsUIMapping.getTooltip(column.getColumnName());
            arrayList.add(new PropertySupport(column.getColumnName(), column.getColumnClass(), string2, string3, true, false){

                public Object getValue() throws IllegalAccessException, InvocationTargetException {
                    return null;
                }

                public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                }
            });
        }
        int n = this.metrics.size() + 1;
        int n2 = 49;
        for (int i = 1; i <= n; ++i) {
            final int n3 = i - 1;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(n2++, 8, true);
            this.outlineView.getInputMap(1).put(keyStroke, "ascSortFor" + i);
            this.outlineView.getActionMap().put("ascSortFor" + i, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = n3;
                    ETableColumnModel eTableColumnModel = null;
                    if (outline.getColumnModel() instanceof ETableColumnModel) {
                        eTableColumnModel = (ETableColumnModel)outline.getColumnModel();
                        eTableColumnModel.clearSortedColumns();
                    }
                    boolean bl = !FunctionsListViewVisualizer.this.ascColumnValues.containsKey(n) ? true : (Boolean)FunctionsListViewVisualizer.this.ascColumnValues.get(n);
                    outline.setColumnSorted(n, bl, 1);
                    FunctionsListViewVisualizer.this.ascColumnValues.put(n, !bl);
                    outline.getTableHeader().resizeAndRepaint();
                }
            });
        }
        outline.getSelectionModel().setSelectionMode(0);
        this.outlineView.setProperties(arrayList.toArray(new Node.Property[0]));
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.outlineView.getOutline().getInputMap(1).put(keyStroke, "return");
        this.outlineView.getOutline().getActionMap().put("return", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionsListViewVisualizer.this.refresh.requestFocus(false);
            }
        });
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0, true);
        this.outlineView.getOutline().getInputMap(1).put(keyStroke2, "enter");
        this.outlineView.getOutline().getActionMap().put("enter", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = outline.getSelectedRow();
                if (n < 0) {
                    return;
                }
                FunctionCallNode functionCallNode = FunctionsListViewVisualizer.this.findNodeByName("" + outline.getValueAt(n, 0));
                if (functionCallNode == null) {
                    return;
                }
                functionCallNode.getGoToSourceAction().actionPerformed(null);
            }
        });
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.refresh != null) {
            this.refresh.requestFocus();
        }
    }

    public FunctionsListViewVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    public void refresh() {
        this.asyncFillModel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncFillModel(boolean bl) {
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null && !this.task.isDone()) {
                if (bl) {
                    this.task.cancel(true);
                } else {
                    return;
                }
            }
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    FunctionsListViewVisualizer.this.syncFillModel();
                    return Boolean.TRUE;
                }
            }, (String)("FunctionsListViewVisualizer Async data load for " + this.configuration.getID() + " from main table " + this.configuration.getMetadata().getName()));
        }
    }

    private void syncFillModel() {
        List list = this.dataProvider.getFunctionsList(this.metadata, this.functionDatatableDescription, this.metrics);
        this.updateList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList(final List<FunctionCall> list) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        final boolean bl = list == null || list.isEmpty();
        String string = this.sourcePrefetchExecutorLock;
        synchronized (string) {
            if (this.sourcePrefetchExecutor != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return FunctionsListViewVisualizer.this.sourcePrefetchExecutor.shutdownNow();
                    }
                });
                this.sourcePrefetchExecutor = null;
            }
            if (!this.isEmptyContent) {
                this.sourcePrefetchExecutor = Executors.newFixedThreadPool(2);
            }
        }
        UIThread.invoke((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = FunctionsListViewVisualizer.this.uiLock;
                synchronized (object) {
                    FunctionsListViewVisualizer.this.setContent(bl);
                    if (!bl) {
                        final FunctionCallChildren functionCallChildren = new FunctionCallChildren(list);
                        FunctionsListViewVisualizer.this.currentChildren = functionCallChildren;
                        if (!Children.MUTEX.isReadAccess()) {
                            Children.MUTEX.writeAccess(new Runnable(){

                                public void run() {
                                    FunctionsListViewVisualizer.this.explorerManager.setRootContext((Node)new AbstractNode((Children)functionCallChildren));
                                    FunctionsListViewVisualizer.this.setNonEmptyContent();
                                }
                            });
                        }
                    }
                }
            }
        });
    }

    private void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(20));
        JLabel jLabel = new JLabel(this.visSupport != null && this.visSupport.isSessionAnalyzed() ? FunctionsListViewVisualizerConfigurationAccessor.getDefault().getEmptyAnalyzeMessage(this.configuration) : FunctionsListViewVisualizerConfigurationAccessor.getDefault().getEmptyRunningMessage(this.configuration));
        jLabel.setAlignmentX(0.5f);
        this.add(jLabel);
        this.repaint();
        this.revalidate();
    }

    private void setLoadingContent() {
        this.isEmptyContent = false;
        this.isLoadingContent = true;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel(NbBundle.getMessage(AdvancedTableViewVisualizer.class, (String)"Loading"));
        jLabel.setAlignmentX(0.5f);
        this.add(jLabel);
        this.repaint();
        this.revalidate();
    }

    private void setContent(boolean bl) {
        if (this.isLoadingContent && bl) {
            this.isLoadingContent = false;
            this.setEmptyContent();
            return;
        }
        if (this.isLoadingContent && !bl) {
            this.isLoadingContent = false;
            this.setNonEmptyContent();
            return;
        }
        if (this.isEmptyContent && !bl) {
            this.setNonEmptyContent();
            return;
        }
        if (bl) {
            this.setEmptyContent();
            return;
        }
    }

    private void setNonEmptyContent() {
        this.isEmptyContent = false;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.buttonsToolbar = new JToolBar();
        if (isMacLaf) {
            this.buttonsToolbar.setBackground(macBackground);
        }
        this.refresh = new JButton();
        this.buttonsToolbar.setFloatable(false);
        this.buttonsToolbar.setOrientation(1);
        this.buttonsToolbar.setRollover(true);
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionsListViewVisualizer.this.asyncFillModel(false);
            }
        });
        this.buttonsToolbar.add(this.refresh);
        this.add((Component)this.buttonsToolbar, "Before");
        this.add((Component)this.outlineView, "Center");
        this.repaint();
        this.validate();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.outlineView);
        arrayList.add(this.refresh);
        this.refresh.requestFocus();
    }

    @Override
    public int onTimer() {
        this.syncFillModel();
        return 0;
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(false);
                this.task = null;
            }
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    @Override
    public void timerStopped() {
        if (this.isEmptyContent) {
            this.setEmptyContent();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.isShown = false;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private final FunctionCallNode findNodeByName(String string) {
        if (this.currentChildren == null) {
            return null;
        }
        for (Node node : this.currentChildren.getNodes()) {
            FunctionCallNode functionCallNode = (FunctionCallNode)node;
            String string2 = functionCallNode.getDisplayName();
            if (string2 == null || !string2.equals(string)) continue;
            return functionCallNode;
        }
        return null;
    }

    private class VisualizerImplSessionStateListener
    implements SessionStateListener {
        private VisualizerImplSessionStateListener() {
        }

        public void sessionStateChanged(DLightSession dLightSession, DLightSession.SessionState sessionState, DLightSession.SessionState sessionState2) {
        }
    }

    private class ExtendedTableCellRendererForNode
    extends DefaultTableCellRenderer {
        private ExtendedTableCellRendererForNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 != 0) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(FunctionsListViewVisualizer.this.metadata.getColumnByName(FunctionsListViewVisualizer.this.functionDatatableDescription.getNameColumn()).getColumnClass());
            FunctionCallNode functionCallNode = null;
            Object object2 = FunctionsListViewVisualizer.this.uiLock;
            synchronized (object2) {
                functionCallNode = FunctionsListViewVisualizer.this.findNodeByName(object + "");
            }
            if (propertyEditor != null && object != null && !(object + "").trim().equals("")) {
                propertyEditor.setValue(object);
                object2 = (DefaultTableCellRenderer)super.getTableCellRendererComponent(jTable, propertyEditor.getAsText(), bl, bl2, n, n2);
                ((JComponent)object2).setEnabled(functionCallNode != null && functionCallNode.getGoToSourceAction().isEnabled());
                return object2;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class GoToSourceAction
    extends AbstractAction {
        private final FunctionCallNode functionCallNode;
        private SourceFileInfoProvider.SourceFileInfo sourceInfo;
        private Future<Boolean> goToSourceTask;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GoToSourceAction(FunctionCallNode functionCallNode) {
            super(NbBundle.getMessage(FunctionsListViewVisualizer.class, (String)"GoToSourceActionName"));
            this.functionCallNode = functionCallNode;
            String string = FunctionsListViewVisualizer.this.sourcePrefetchExecutorLock;
            synchronized (string) {
                if (FunctionsListViewVisualizer.this.sourcePrefetchExecutor == null) {
                    FunctionsListViewVisualizer.this.sourcePrefetchExecutor = Executors.newFixedThreadPool(2);
                }
            }
            FunctionsListViewVisualizer.this.sourcePrefetchExecutor.submit(new Runnable(){

                public void run() {
                    GoToSourceAction.this.getSource();
                }
            });
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            if (this.goToSourceTask == null || this.goToSourceTask.isDone()) {
                this.goToSourceTask = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return GoToSourceAction.this.goToSource();
                    }
                }, (String)"GoToSource from Functions List View");
            }
        }

        private boolean goToSource() {
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = this.getSource();
            if (sourceFileInfo != null && sourceFileInfo.isSourceKnown()) {
                FunctionsListViewVisualizer.this.sourceSupportProvider.showSource(sourceFileInfo);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SourceFileInfoProvider.SourceFileInfo getSource() {
            GoToSourceAction goToSourceAction = this;
            synchronized (goToSourceAction) {
                if (this.sourceInfo != null) {
                    return this.sourceInfo;
                }
            }
            goToSourceAction = this.functionCallNode.getFunctionCall();
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = FunctionsListViewVisualizer.this.dataProvider.getSourceFileInfo((FunctionCall)goToSourceAction);
            if (sourceFileInfo != null && sourceFileInfo.isSourceKnown()) {
                GoToSourceAction goToSourceAction2 = this;
                synchronized (goToSourceAction2) {
                    if (this.sourceInfo == null) {
                        this.sourceInfo = sourceFileInfo;
                    }
                }
                return this.sourceInfo;
            }
            this.setEnabled(false);
            this.functionCallNode.fire();
            return null;
        }
    }

    private class FunctionCallNode
    extends AbstractNode {
        private final FunctionCall functionCall;
        private Node.PropertySet propertySet;
        private final Action[] actions;
        private final Action goToSourceAction;

        FunctionCallNode(FunctionCall functionCall) {
            super(Children.LEAF);
            this.functionCall = functionCall;
            this.goToSourceAction = new GoToSourceAction(this);
            this.actions = new Action[]{this.goToSourceAction};
            this.propertySet = new Node.PropertySet(){

                public Node.Property<?>[] getProperties() {
                    ArrayList<1> arrayList = new ArrayList<1>();
                    for (final DataTableMetadata.Column column : FunctionsListViewVisualizer.this.metrics) {
                        arrayList.add(new PropertySupport(column.getColumnName(), column.getColumnClass(), column.getColumnUName(), column.getColumnLongUName(), true, false){

                            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                                return FunctionCallNode.this.functionCall.getMetricValue(column.getColumnName());
                            }

                            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                            }
                        });
                    }
                    return arrayList.toArray(new Node.Property[0]);
                }
            };
        }

        public FunctionCall getFunctionCall() {
            return this.functionCall;
        }

        public Image getIcon(int n) {
            return null;
        }

        public Image getOpenedIcon(int n) {
            return null;
        }

        public Action getPreferredAction() {
            return null;
        }

        Action getGoToSourceAction() {
            return this.goToSourceAction;
        }

        private void fire() {
            this.fireDisplayNameChange(this.getDisplayName() + "_", this.getDisplayName());
        }

        public Action[] getActions(boolean bl) {
            return this.actions;
        }

        public String getDisplayName() {
            return this.functionCall.getDisplayedName();
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{this.propertySet};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FunctionCallChildren
    extends Children.Keys<FunctionCall> {
        private final List<FunctionCall> list;

        public FunctionCallChildren(List<FunctionCall> list) {
            this.list = list;
        }

        protected Node[] createNodes(FunctionCall functionCall) {
            return new Node[]{new FunctionCallNode(functionCall)};
        }

        protected void addNotify() {
            this.setKeys(this.list);
        }
    }
}

