/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.TableDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerRefreshVisualizerHandler;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.api.AdvancedTableViewVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.AdvancedTableViewVisualizerConfigurationAccessor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AdvancedTableViewVisualizer
extends JPanel
implements Visualizer<AdvancedTableViewVisualizerConfiguration>,
OnTimerTask,
ComponentListener,
ExplorerManager.Provider {
    private TableDataProvider provider;
    private AdvancedTableViewVisualizerConfiguration configuration;
    private final List<DataRow> data = new ArrayList<DataRow>();
    private JToolBar buttonsToolbar;
    private JButton refresh;
    private OnTimerRefreshVisualizerHandler timerHandler;
    private boolean isEmptyContent;
    private boolean isShown = true;
    private OutlineView outlineView;
    private final String nodeColumnName;
    private final String nodeRowColumnID;
    private final ExplorerManager explorerManager;
    private Future task;
    private final Object queryLock = new Object();
    private final Object uiLock = new Object();

    AdvancedTableViewVisualizer(TableDataProvider tableDataProvider, AdvancedTableViewVisualizerConfiguration advancedTableViewVisualizerConfiguration) {
        this.provider = tableDataProvider;
        this.configuration = advancedTableViewVisualizerConfiguration;
        this.explorerManager = new ExplorerManager();
        this.setLoadingContent();
        this.addComponentListener(this);
        AdvancedTableViewVisualizerConfigurationAccessor advancedTableViewVisualizerConfigurationAccessor = AdvancedTableViewVisualizerConfigurationAccessor.getDefault();
        this.nodeColumnName = advancedTableViewVisualizerConfigurationAccessor.getNodeColumnName(advancedTableViewVisualizerConfiguration);
        this.nodeRowColumnID = advancedTableViewVisualizerConfigurationAccessor.getRowNodeColumnName(advancedTableViewVisualizerConfiguration);
        this.outlineView = new OutlineView(advancedTableViewVisualizerConfiguration.getMetadata().getColumnByName(this.nodeColumnName).getColumnUName());
        this.outlineView.getOutline().setRootVisible(false);
        this.outlineView.getOutline().setDefaultRenderer(Object.class, (TableCellRenderer)new ExtendedTableCellRendererForNode());
        ArrayList<1> arrayList = new ArrayList<1>();
        for (String string : advancedTableViewVisualizerConfiguration.getMetadata().getColumnNames()) {
            if (this.nodeColumnName.equals(string) || this.nodeRowColumnID.equals(string)) continue;
            DataTableMetadata.Column column = advancedTableViewVisualizerConfiguration.getMetadata().getColumnByName(string);
            arrayList.add(new PropertySupport(column.getColumnName(), column.getColumnClass(), column.getColumnUName(), column.getColumnUName(), true, false){

                public Object getValue() throws IllegalAccessException, InvocationTargetException {
                    return null;
                }

                public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                }
            });
        }
        this.outlineView.setProperties(arrayList.toArray(new Node.Property[0]));
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        this.asyncFillModel();
        if (this.timerHandler != null && this.timerHandler.isSessionRunning()) {
            this.timerHandler.startTimer();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(true);
            }
        }
        if (this.timerHandler != null) {
            this.timerHandler.stopTimer();
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    private void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel(this.timerHandler != null && this.timerHandler.isSessionAnalyzed() ? AdvancedTableViewVisualizerConfigurationAccessor.getDefault().getEmptyAnalyzeMessage(this.configuration) : AdvancedTableViewVisualizerConfigurationAccessor.getDefault().getEmptyRunningMessage(this.configuration));
        jLabel.setAlignmentX(0.5f);
        this.add(jLabel);
        this.repaint();
        this.revalidate();
    }

    private void setLoadingContent() {
        this.isEmptyContent = false;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel(NbBundle.getMessage(AdvancedTableViewVisualizer.class, (String)"Loading"));
        jLabel.setAlignmentX(0.5f);
        this.add(jLabel);
        this.repaint();
        this.revalidate();
    }

    private void setContent(boolean bl) {
        if (this.isEmptyContent && bl) {
            return;
        }
        if (this.isEmptyContent && !bl) {
            this.setNonEmptyContent();
            return;
        }
        if (!this.isEmptyContent && bl) {
            this.setEmptyContent();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateList(List<DataRow> list) {
        Object object = this.uiLock;
        synchronized (object) {
            this.setNonEmptyContent();
            this.explorerManager.setRootContext((Node)new AbstractNode((Children)new DataChildren(list)));
        }
    }

    private void setNonEmptyContent() {
        this.isEmptyContent = false;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.buttonsToolbar = new JToolBar();
        this.refresh = new JButton();
        this.buttonsToolbar.setFloatable(false);
        this.buttonsToolbar.setOrientation(1);
        this.buttonsToolbar.setRollover(true);
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setFocusable(false);
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedTableViewVisualizer.this.asyncFillModel();
            }
        });
        this.buttonsToolbar.add(this.refresh);
        this.add((Component)this.buttonsToolbar, "Before");
        this.add((Component)this.outlineView, "Center");
        this.repaint();
        this.validate();
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    @Override
    public int onTimer() {
        if (!this.isShown || !this.isShowing()) {
            return 0;
        }
        this.asyncFillModel();
        return 0;
    }

    public void refresh() {
        this.asyncFillModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncFillModel() {
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(true);
            }
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    Future future = DLightExecutorService.submit((Callable)new Callable<List<DataRow>>(){

                        @Override
                        public List<DataRow> call() throws Exception {
                            return AdvancedTableViewVisualizer.this.provider.queryData(AdvancedTableViewVisualizer.this.configuration.getMetadata());
                        }
                    }, (String)("AdvancedTableViewVisualizer Async data from provider  load for " + AdvancedTableViewVisualizer.this.configuration.getID()));
                    try {
                        final List list = (List)future.get();
                        final boolean bl = list == null || list.isEmpty();
                        UIThread.invoke((Runnable)new Runnable(){

                            public void run() {
                                AdvancedTableViewVisualizer.this.setContent(bl);
                                if (bl) {
                                    return;
                                }
                                AdvancedTableViewVisualizer.this.updateList(list);
                            }
                        });
                        return true;
                    }
                    catch (ExecutionException executionException) {
                        Thread.currentThread().interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    return false;
                }
            }, (String)("AdvancedTableViewVisualizer Async data load for " + this.configuration.getID()));
        }
    }

    public AdvancedTableViewVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void timerStopped() {
        if (this.isEmptyContent) {
            this.setEmptyContent();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
        if (this.isShown) {
            this.onTimer();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.isShown = false;
    }

    private class ExtendedTableCellRendererForNode
    extends DefaultTableCellRenderer {
        private ExtendedTableCellRendererForNode() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 != 0) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(AdvancedTableViewVisualizer.this.configuration.getMetadata().getColumnByName(AdvancedTableViewVisualizer.this.nodeColumnName).getColumnClass());
            if (propertyEditor != null && object != null && !(object + "").trim().equals("")) {
                propertyEditor.setValue(object);
                return super.getTableCellRendererComponent(jTable, propertyEditor.getAsText(), bl, bl2, n, n2);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class DataRowNode
    extends AbstractNode {
        private final DataRow dataRow;
        private Node.PropertySet propertySet;

        DataRowNode(DataRow dataRow) {
            super(Children.LEAF);
            this.dataRow = dataRow;
            this.propertySet = new Node.PropertySet(){

                public Node.Property<?>[] getProperties() {
                    ArrayList<1> arrayList = new ArrayList<1>();
                    for (String string : DataRowNode.this.dataRow.getColumnNames()) {
                        if (string.equals(AdvancedTableViewVisualizer.this.nodeColumnName) || string.equals(AdvancedTableViewVisualizer.this.nodeRowColumnID)) continue;
                        final DataTableMetadata.Column column = AdvancedTableViewVisualizer.this.configuration.getMetadata().getColumnByName(string);
                        arrayList.add(new PropertySupport(string, column.getColumnClass(), column.getColumnUName(), column.getColumnUName(), true, false){

                            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                                return DataRowNode.this.dataRow.getData(column.getColumnName());
                            }

                            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                            }
                        });
                    }
                    return arrayList.toArray(new Node.Property[0]);
                }
            };
        }

        public DataRow getDataRow() {
            return this.dataRow;
        }

        public String getDisplayName() {
            return this.dataRow.getData(AdvancedTableViewVisualizer.this.nodeColumnName) + "";
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{this.propertySet};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DataChildren
    extends Children.Keys<DataRow> {
        private final List<DataRow> list;

        public DataChildren(List<DataRow> list) {
            this.list = list;
        }

        protected Node[] createNodes(DataRow dataRow) {
            return new Node[]{new DataRowNode(dataRow)};
        }

        protected void addNotify() {
            this.setKeys(this.list);
        }
    }
}

