/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModelFactory;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ConfigurationUtils {
    private static WeakHashMap<FileObject, WeakReference<JSFConfigModel>> configModelsEditable = new WeakHashMap();
    private static WeakHashMap<FileObject, WeakReference<JSFConfigModel>> configModelsNonEditable = new WeakHashMap();

    public static synchronized JSFConfigModel getConfigModel(FileObject fileObject, boolean bl) {
        JSFConfigModel jSFConfigModel = null;
        if (fileObject != null && fileObject.isValid()) {
            WeakHashMap<FileObject, WeakReference<JSFConfigModel>> weakHashMap = bl ? configModelsEditable : configModelsNonEditable;
            WeakReference weakReference = (WeakReference)weakHashMap.get(fileObject);
            if (weakReference != null) {
                jSFConfigModel = (JSFConfigModel)weakReference.get();
                if (jSFConfigModel != null) {
                    return jSFConfigModel;
                }
                weakHashMap.remove(fileObject);
            }
            try {
                ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject, (boolean)bl);
                jSFConfigModel = JSFConfigModelFactory.getInstance().getModel(modelSource);
                weakHashMap.put(fileObject, new WeakReference<JSFConfigModel>(jSFConfigModel));
            }
            catch (CatalogModelException catalogModelException) {
                Logger.getLogger("global").log(Level.SEVERE, catalogModelException.getMessage(), catalogModelException);
            }
        }
        return jSFConfigModel;
    }

    public static Servlet getFacesServlet(WebModule webModule) {
        FileObject fileObject = webModule.getDeploymentDescriptor();
        if (fileObject == null) {
            return null;
        }
        try {
            WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
            return (Servlet)webApp.findBeanByName("Servlet", "ServletClass", "javax.faces.webapp.FacesServlet");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getFacesServletMapping(WebModule webModule) {
        FileObject fileObject = webModule.getDeploymentDescriptor();
        Servlet servlet = ConfigurationUtils.getFacesServlet(webModule);
        if (servlet != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                ServletMapping[] servletMappingArray = webApp.getServletMapping();
                for (int i = 0; i < servletMappingArray.length; ++i) {
                    if (!servletMappingArray[i].getServletName().equals(servlet.getServletName())) continue;
                    return servletMappingArray[i].getUrlPattern();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    public static FileObject[] getFacesConfigFiles(WebModule webModule) {
        String[] stringArray = JSFConfigUtilities.getConfigFiles(webModule);
        if (stringArray.length > 0) {
            FileObject fileObject = webModule.getDocumentBase();
            if (fileObject == null) {
                return new FileObject[0];
            }
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (int i = 0; i < stringArray.length; ++i) {
                FileObject fileObject2 = fileObject.getFileObject(stringArray[i]);
                if (fileObject2 == null) continue;
                arrayList.add(fileObject2);
            }
            return arrayList.toArray(new FileObject[arrayList.size()]);
        }
        return new FileObject[0];
    }

    public static String translateURI(String string, String string2) {
        String string3 = "";
        if (string != null && string.length() > 0) {
            if (string.startsWith("*.")) {
                string3 = string2.indexOf(46) > 0 ? string2.substring(0, string2.lastIndexOf(46)) + string.substring(1) : string2 + string.substring(1);
            } else if (string.endsWith("/*")) {
                string3 = string.substring(1, string.length() - 1) + string2;
            }
        }
        return string3;
    }

    public static FileObject findFacesConfigForManagedBean(WebModule webModule, String string) {
        FileObject[] fileObjectArray = ConfigurationUtils.getFacesConfigFiles(webModule);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fileObjectArray[i], true).getRootComponent();
            List<ManagedBean> list = facesConfig.getManagedBeans();
            for (ManagedBean managedBean : list) {
                if (!string.equals(managedBean.getManagedBeanName())) continue;
                return fileObjectArray[i];
            }
        }
        return null;
    }
}

