/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class JSFConfigUtilities {
    private static String CONFIG_FILES_PARAM_NAME = "javax.faces.CONFIG_FILES";
    private static String DEFAULT_FACES_CONFIG_PATH = "WEB-INF/faces-config.xml";

    public static boolean hasJsfFramework(FileObject fileObject) {
        if (fileObject != null) {
            WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
            String[] stringArray = JSFConfigUtilities.getConfigFiles(webModule);
            return stringArray != null && stringArray.length > 0;
        }
        return false;
    }

    public static Set extendJsfFramework(FileObject fileObject, boolean bl) {
        Set set = Collections.EMPTY_SET;
        if (fileObject == null) {
            return set;
        }
        List list = WebFrameworks.getFrameworks();
        for (WebFrameworkProvider webFrameworkProvider : list) {
            if (!(webFrameworkProvider instanceof JSFFrameworkProvider)) continue;
            WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
            ((JSFFrameworkProvider)webFrameworkProvider).setCreateWelcome(bl);
            WebModuleExtender webModuleExtender = webFrameworkProvider.createWebModuleExtender(webModule, ExtenderController.create());
            set = webModuleExtender.extend(webModule);
            return set;
        }
        return set;
    }

    public static NavigationRule findNavigationRule(JSFConfigDataObject jSFConfigDataObject, String string) {
        NavigationRule navigationRule = null;
        FacesConfig facesConfig = ConfigurationUtils.getConfigModel(jSFConfigDataObject.getPrimaryFile(), true).getRootComponent();
        List<NavigationRule> list = facesConfig.getNavigationRules();
        for (NavigationRule navigationRule2 : list) {
            if ((string == null || !string.equals(navigationRule2.getFromViewId())) && (string != null || navigationRule2.getFromViewId() != null && navigationRule2.getFromViewId().trim().length() != 0)) continue;
            navigationRule = navigationRule2;
        }
        return navigationRule;
    }

    public static SourceGroup[] getDocBaseGroups(FileObject fileObject) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        return sources.getSourceGroups("doc_root");
    }

    public static String getResourcePath(SourceGroup[] sourceGroupArray, FileObject fileObject, char c, boolean bl) {
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject2 = sourceGroupArray[i].getRootFolder();
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            if (string != null) {
                int n;
                if (c != '/') {
                    string = string.replace('/', c);
                }
                if (!bl && (n = string.lastIndexOf(46)) > 0) {
                    string = string.substring(0, n);
                }
                return string;
            }
            return "";
        }
        return "";
    }

    public static boolean validateXML(FileObject fileObject) {
        boolean bl = false;
        if (fileObject != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                InitParam initParam = null;
                if (webApp != null) {
                    initParam = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "com.sun.faces.validateXml");
                }
                if (initParam != null) {
                    bl = "true".equals(initParam.getParamValue().trim());
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return bl;
    }

    public static boolean verifyObjects(FileObject fileObject) {
        boolean bl = false;
        if (fileObject != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                InitParam initParam = null;
                if (webApp != null) {
                    initParam = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "com.sun.faces.verifyObjects");
                }
                if (initParam != null) {
                    bl = "true".equals(initParam.getParamValue().trim());
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return bl;
    }

    public static String[] getConfigFiles(WebModule webModule) {
        if (webModule == null) {
            return new String[0];
        }
        return JSFConfigUtilities.getConfigFiles(webModule, webModule.getDeploymentDescriptor());
    }

    public static String[] getConfigFiles(FileObject fileObject) {
        if (fileObject == null) {
            return new String[0];
        }
        return JSFConfigUtilities.getConfigFiles(WebModule.getWebModule((FileObject)fileObject), fileObject);
    }

    public static String[] getConfigFiles(WebModule webModule, FileObject fileObject) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (webModule != null) {
            FileObject fileObject2 = webModule.getDocumentBase();
            FileObject fileObject3 = fileObject2.getFileObject(DEFAULT_FACES_CONFIG_PATH);
            if (fileObject3 != null) {
                arrayList.add(DEFAULT_FACES_CONFIG_PATH);
            }
            if (fileObject != null) {
                Object object;
                InitParam initParam;
                block8: {
                    initParam = null;
                    try {
                        object = DDProvider.getDefault().getDDRoot(fileObject);
                        if (object == null) break block8;
                        InitParam[] initParamArray = object.getContextParam();
                        for (int i = 0; i < initParamArray.length; ++i) {
                            InitParam initParam2 = initParamArray[i];
                            if (!CONFIG_FILES_PARAM_NAME.equals(initParam2.getParamName().trim())) continue;
                            initParam = initParam2;
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                if (initParam != null && (object = initParam.getParamValue().trim()) != null) {
                    stringArray = ((String)object).split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i].trim();
                        if (DEFAULT_FACES_CONFIG_PATH.equals(string) || ("/" + DEFAULT_FACES_CONFIG_PATH).equals(string)) continue;
                        arrayList.add(string);
                    }
                }
            }
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

