/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.modules.web.monitor.client.ComboBoxTableCellEditor;
import org.netbeans.modules.web.monitor.client.DisplayTableModel;
import org.netbeans.modules.web.monitor.client.DisplayTableSorter;
import org.netbeans.modules.web.monitor.client.NameValueCellEditor;
import org.netbeans.modules.web.monitor.data.Param;
import org.openide.util.NbBundle;

public class DisplayTable
extends JTable {
    private static final boolean debug = false;
    public static final int UNEDITABLE = 0;
    public static final int REQUEST = 1;
    public static final int SERVER = 2;
    public static final int HEADERS = 3;
    public static final int PARAMS = 4;
    public static final int COOKIES = 5;
    public static final int NEUTRAL = 0;
    public static final int A2Z = 1;
    public static final int Z2A = 2;
    private int numRows = 0;
    private int numCols = 3;
    private Object[][] data = null;
    private TableCellEditor[][] cellEditors = null;
    private boolean editableNames = false;
    private int editable = 0;
    private int sort = 0;
    private boolean sortable = false;
    boolean fontChanged = true;

    public DisplayTable(String[] stringArray) {
        this(stringArray, null, 0, false);
    }

    public DisplayTable(String[] stringArray, boolean bl) {
        this(stringArray, null, 0, bl);
    }

    public DisplayTable(String[] stringArray, int n) {
        this(stringArray, null, n, false);
    }

    public DisplayTable(String[] stringArray, int n, boolean bl) {
        this(stringArray, null, n, bl);
    }

    public DisplayTable(String[] stringArray, String[] stringArray2) {
        this(stringArray, stringArray2, 0, false);
    }

    public DisplayTable(String[] stringArray, String[] stringArray2, boolean bl) {
        this(stringArray, stringArray2, 0, bl);
    }

    public DisplayTable(String[] stringArray, String[] stringArray2, int n) {
        this(stringArray, stringArray2, n, false);
    }

    public DisplayTable(String[] stringArray, String[] stringArray2, int n, boolean bl) {
        this.numRows = stringArray.length;
        this.editableNames = false;
        this.editable = n;
        this.sortable = bl;
        this.data = new Object[this.numRows][this.numCols];
        this.cellEditors = new TableCellEditor[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            this.data[i][0] = stringArray[i];
            this.data[i][1] = stringArray2 == null ? new String("") : stringArray2[i];
            this.data[i][2] = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$DisplayTable == null ? DisplayTable.class$("org.netbeans.modules.web.monitor.client.DisplayTable") : class$org$netbeans$modules$web$monitor$client$DisplayTable)).getString("MON_Edit_dots");
            this.cellEditors[i][2] = NameValueCellEditor.createCellEditor(this, this.data, false, i, n);
        }
        this.setMyModel(this.data, n > 0);
        this.setup();
    }

    public DisplayTable(Param[] paramArray) {
        this(paramArray, 0, false);
    }

    public DisplayTable(Param[] paramArray, boolean bl) {
        this(paramArray, 0, bl);
    }

    public DisplayTable(Param[] paramArray, int n) {
        this(paramArray, n, false);
    }

    public DisplayTable(Param[] paramArray, int n, boolean bl) {
        this.editableNames = n >= 3;
        this.editable = n;
        this.sortable = bl;
        this.numRows = paramArray.length;
        this.data = new Object[this.numRows][this.numCols];
        this.cellEditors = new TableCellEditor[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            this.data[i][0] = paramArray[i].getAttributeValue("name");
            this.data[i][1] = paramArray[i].getAttributeValue("value");
            this.data[i][2] = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$DisplayTable == null ? DisplayTable.class$("org.netbeans.modules.web.monitor.client.DisplayTable") : class$org$netbeans$modules$web$monitor$client$DisplayTable)).getString("MON_Edit_dots");
            this.cellEditors[i][2] = NameValueCellEditor.createCellEditor(this, this.data, true, i, n);
        }
        this.setMyModel(this.data, n > 0);
        this.setup();
    }

    private void setup() {
        this.setBorderAndColorScheme();
        Dimension dimension = new Dimension(6, 4);
        this.setIntercellSpacing(dimension);
        this.sort();
    }

    private void setBorderAndColorScheme() {
        this.setBorderAndColorScheme(this.editable != 0);
    }

    private void setBorderAndColorScheme(boolean bl) {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        Color color = !bl ? this.getBackground().darker() : Color.white;
        this.setTableHeader(null);
        this.setBackground(color);
    }

    public JComboBox setChoices(int n, int n2, String[] stringArray, boolean bl) {
        ComboBoxTableCellEditor comboBoxTableCellEditor = new ComboBoxTableCellEditor(stringArray);
        this.cellEditors[n][n2] = comboBoxTableCellEditor;
        this.data[n][2] = NbBundle.getBundle((Class)DisplayTable.class).getString("MON_Editing");
        this.cellEditors[n][2] = null;
        return comboBoxTableCellEditor.getComboBox();
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = this.cellEditors[n][n2];
        if (tableCellEditor == null) {
            return super.getCellEditor(n, n2);
        }
        return tableCellEditor;
    }

    public void setSorting(int n) {
        this.sort = n;
        if (this.getModel() instanceof DisplayTableSorter) {
            ((DisplayTableSorter)this.getModel()).sort(this.sort);
        }
    }

    public void sort() {
        if (this.getModel() instanceof DisplayTableSorter) {
            ((DisplayTableSorter)this.getModel()).sort(this.sort);
        }
    }

    private void setMyModel(Object[][] objectArray, boolean bl) {
        Object object;
        DisplayTableModel displayTableModel = new DisplayTableModel(objectArray, bl, this.editable > 2);
        if (this.sortable) {
            object = new DisplayTableSorter(displayTableModel);
            this.setModel((TableModel)object);
        } else {
            this.setModel(displayTableModel);
        }
        object = this.getColumnModel();
        if (object.getColumnCount() > 0) {
            TableColumn tableColumn = object.getColumn(0);
            tableColumn.setPreferredWidth(10);
            object.getColumn(2).setMaxWidth(5);
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.addTableModelListener(tableModelListener);
        }
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.removeTableModelListener(tableModelListener);
        }
    }

    public Object[][] getData() {
        return this.data;
    }

    public void setFont(Font font) {
        this.fontChanged = true;
        super.setFont(font);
    }

    public void paint(Graphics graphics) {
        if (this.fontChanged) {
            Font font = this.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            this.fontChanged = false;
            this.setRowHeight(n);
            return;
        }
        super.paint(graphics);
    }

    private void log(String string) {
        System.out.println("DisplayTable::" + string);
    }
}

