/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Module
extends ModuleInfo {
    public static final String PROP_RELOADABLE = "reloadable";
    public static final String PROP_CLASS_LOADER = "classLoader";
    public static final String PROP_MANIFEST = "manifest";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PROBLEMS = "problems";
    protected final ModuleManager mgr;
    protected final Events events;
    private final Object history;
    private boolean enabled;
    private final boolean autoload;
    protected boolean reloadable;
    private final boolean eager;
    private String codeNameBase;
    private int codeNameRelease;
    private String codeName;
    private String[] provides;
    private Dependency[] dependenciesA;
    private SpecificationVersion specVers;
    protected ClassLoader classloader = null;
    private PackageExport[] publicPackages;
    private Set friendNames;

    protected Module(ModuleManager moduleManager, Events events, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (bl2 && bl3) {
            throw new IllegalArgumentException("A module may not be both autoload and eager");
        }
        this.mgr = moduleManager;
        this.events = events;
        this.history = object;
        this.reloadable = bl;
        this.autoload = bl2;
        this.eager = bl3;
        this.enabled = false;
    }

    protected Module(ModuleManager moduleManager, Events events, Object object, ClassLoader classLoader) throws InvalidException {
        this(moduleManager, events, object, classLoader, false, false);
    }

    protected Module(ModuleManager moduleManager, Events events, Object object, ClassLoader classLoader, boolean bl, boolean bl2) throws InvalidException {
        if (bl && bl2) {
            throw new IllegalArgumentException("A module may not be both autoload and eager");
        }
        this.mgr = moduleManager;
        this.events = events;
        this.history = object;
        this.classloader = classLoader;
        this.reloadable = false;
        this.autoload = bl;
        this.eager = bl2;
        this.enabled = false;
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean bl) {
        if (this.isFixed() && !bl) {
            throw new IllegalStateException("Cannot disable a fixed module: " + (Object)((Object)this));
        }
        this.enabled = bl;
    }

    public boolean isValid() {
        return this.mgr.get(this.getCodeNameBase()) == this;
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isEager() {
        return this.eager;
    }

    public Object getAttribute(String string) {
        return this.getManifest().getMainAttributes().getValue(string);
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public int getCodeNameRelease() {
        return this.codeNameRelease;
    }

    public String[] getProvides() {
        return this.provides;
    }

    public final boolean provides(String string) {
        for (int i = 0; i < this.provides.length; ++i) {
            if (!this.provides[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public Set<Dependency> getDependencies() {
        return new HashSet<Dependency>(Arrays.asList(this.dependenciesA));
    }

    public final Dependency[] getDependenciesArray() {
        return this.dependenciesA;
    }

    public SpecificationVersion getSpecificationVersion() {
        return this.specVers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean owns(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)classLoader)).getModule() == this;
        }
        if (classLoader != this.classloader) {
            return false;
        }
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            boolean bl;
            URL uRL = codeSource.getLocation();
            if (uRL.toString().matches(".+\\.jar")) {
                uRL = new URL("jar:" + uRL + "!/");
            }
            URL uRL2 = new URL(uRL, "META-INF/MANIFEST.MF");
            InputStream inputStream = uRL2.openStream();
            try {
                Manifest manifest = new Manifest(inputStream);
                bl = this.codeName.equals(manifest.getMainAttributes().getValue("OpenIDE-Module"));
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Logger.getLogger(Module.class.getName()).log(Level.FINE, null, iOException);
                }
            }
            inputStream.close();
            return bl;
        }
        return true;
    }

    public PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    boolean isDeclaredAsFriend(Module module) {
        if (this.friendNames == null) {
            return true;
        }
        return this.friendNames.contains(module.getCodeNameBase());
    }

    protected void parseManifest() throws InvalidException {
        Attributes attributes = this.getManifest().getMainAttributes();
        this.codeName = attributes.getValue("OpenIDE-Module");
        if (this.codeName == null) {
            InvalidException invalidException = new InvalidException("Not a module: no OpenIDE-Module tag in manifest of " + (Object)((Object)this));
            Exceptions.attachLocalizedMessage((Throwable)invalidException, (String)NbBundle.getMessage(Module.class, (String)"EXC_not_a_module", (Object)this.toString()));
            throw invalidException;
        }
        try {
            String string;
            Object object;
            Object object2;
            String string2;
            Object object3;
            String[] stringArray;
            boolean bl;
            if (this.codeName.indexOf(44) != -1) {
                throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module: " + this.codeName);
            }
            Object[] objectArray = Util.parseCodeName(this.codeName);
            this.codeNameBase = (String)objectArray[0];
            Set<Dependency> set = this.mgr.loadDependencies(this.codeNameBase);
            boolean bl2 = bl = set == null;
            if (bl) {
                Dependency.create((int)1, (String)this.codeName);
            }
            int n = this.codeNameRelease = objectArray[1] != null ? (Integer)objectArray[1] : -1;
            if (objectArray[2] != null) {
                throw new NumberFormatException(this.codeName);
            }
            String string3 = attributes.getValue("OpenIDE-Module-Specification-Version");
            if (string3 != null) {
                try {
                    this.specVers = new SpecificationVersion(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw (InvalidException)new InvalidException("While parsing OpenIDE-Module-Specification-Version: " + numberFormatException.toString()).initCause(numberFormatException);
                }
            } else {
                this.specVers = null;
            }
            String string4 = attributes.getValue("OpenIDE-Module-Provides");
            if (string4 == null) {
                this.provides = new String[0];
            } else {
                stringArray = new StringTokenizer(string4, ", ");
                this.provides = new String[stringArray.countTokens()];
                for (int i = 0; i < this.provides.length; ++i) {
                    object3 = stringArray.nextToken();
                    if (((String)object3).indexOf(44) != -1) {
                        throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module-Provides: " + (String)object3);
                    }
                    if (bl) {
                        Dependency.create((int)1, (String)object3);
                    }
                    if (((String)object3).lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Provides: " + (String)object3);
                    }
                    this.provides[i] = object3;
                }
                if (new HashSet<String>(Arrays.asList(this.provides)).size() < this.provides.length) {
                    throw new IllegalArgumentException("Duplicate entries in OpenIDE-Module-Provides: " + string4);
                }
            }
            stringArray = this.mgr.refineProvides(this);
            if (stringArray != null) {
                if (this.provides == null) {
                    this.provides = stringArray;
                } else {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(Arrays.asList(this.provides));
                    arrayList.addAll(Arrays.asList(stringArray));
                    this.provides = arrayList.toArray(this.provides);
                }
            }
            if ((string2 = attributes.getValue("OpenIDE-Module-Public-Packages")) != null) {
                if (string2.trim().equals("-")) {
                    this.publicPackages = new PackageExport[0];
                } else {
                    object3 = new StringTokenizer(string2, ", ");
                    object2 = new ArrayList(Math.max(((StringTokenizer)object3).countTokens(), 1));
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        object = ((StringTokenizer)object3).nextToken();
                        if (((String)object).endsWith(".*")) {
                            string = ((String)object).substring(0, ((String)object).length() - 2);
                            if (bl) {
                                Dependency.create((int)1, (String)string);
                            }
                            if (string.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string2);
                            }
                            object2.add(new PackageExport(string.replace('.', '/') + '/', false));
                            continue;
                        }
                        if (((String)object).endsWith(".**")) {
                            string = ((String)object).substring(0, ((String)object).length() - 3);
                            if (bl) {
                                Dependency.create((int)1, (String)string);
                            }
                            if (string.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string2);
                            }
                            object2.add(new PackageExport(string.replace('.', '/') + '/', true));
                            continue;
                        }
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string2);
                    }
                    if (object2.isEmpty()) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string2);
                    }
                    this.publicPackages = object2.toArray(new PackageExport[object2.size()]);
                }
            } else {
                Util.err.warning("module " + this.codeNameBase + " does not declare OpenIDE-Module-Public-Packages in its manifest, so all packages are considered public by default: http://www.netbeans.org/download/dev/javadoc/OpenAPIs/org/openide/doc-files/upgrade.html#3.4-public-packages");
                this.publicPackages = null;
            }
            object3 = attributes.getValue("OpenIDE-Module-Friends");
            if (object3 != null) {
                object2 = new StringTokenizer((String)object3, ", ");
                object = new HashSet();
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    string = ((StringTokenizer)object2).nextToken();
                    if (string.indexOf(47) != -1) {
                        throw new IllegalArgumentException("May specify only module code name bases in OpenIDE-Module-Friends, not major release versions: " + string);
                    }
                    if (bl) {
                        Dependency.create((int)1, (String)string);
                    }
                    ((HashSet)object).add(string);
                }
                if (((HashSet)object).isEmpty()) {
                    throw new IllegalArgumentException("Empty OpenIDE-Module-Friends: " + (String)object3);
                }
                if (this.publicPackages == null || this.publicPackages.length == 0) {
                    throw new IllegalArgumentException("No use specifying OpenIDE-Module-Friends without any public packages: " + (String)object3);
                }
                this.friendNames = object;
            }
            this.initDeps(set, attributes);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (InvalidException)new InvalidException("While parsing " + this.codeName + " a dependency attribute: " + illegalArgumentException.toString()).initCause(illegalArgumentException);
        }
    }

    public abstract List<File> getAllJars();

    public boolean isReloadable() {
        return this.reloadable;
    }

    public abstract void setReloadable(boolean var1);

    public abstract void reload() throws IOException;

    public ClassLoader getClassLoader() throws IllegalArgumentException {
        if (!this.enabled) {
            throw new IllegalArgumentException("Not enabled: " + this.codeNameBase);
        }
        assert (this.classloader != null) : "Should have had a non-null loader for " + (Object)((Object)this);
        return this.classloader;
    }

    protected abstract void classLoaderUp(Set<Module> var1) throws IOException;

    protected abstract void classLoaderDown();

    protected abstract void cleanup();

    protected abstract void destroy();

    public abstract boolean isFixed();

    public File getJarFile() {
        return null;
    }

    public abstract Manifest getManifest();

    public void releaseManifest() {
    }

    public Set<Object> getProblems() {
        if (!this.isValid()) {
            throw new IllegalStateException("Not valid: " + (Object)((Object)this));
        }
        if (this.isEnabled()) {
            return Collections.emptySet();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Union2<Dependency, InvalidException> union2 : this.mgr.missingDependencies(this)) {
            if (union2.hasFirst()) {
                hashSet.add(union2.first());
                continue;
            }
            hashSet.add(union2.second());
        }
        return hashSet;
    }

    final void firePropertyChange0(String string, Object object, Object object2) {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("Module.propertyChange: " + (Object)((Object)this) + " " + string + ": " + object + " -> " + object2);
        }
        this.firePropertyChange(string, object, object2);
    }

    public final Object getHistory() {
        return this.history;
    }

    public String toString() {
        String string = "Module:" + this.getCodeNameBase();
        if (!this.isValid()) {
            string = string + "[invalid]";
        }
        return string;
    }

    private void initDeps(Set<?> set, Attributes attributes) throws IllegalStateException, IllegalArgumentException {
        Object object;
        if (set != null) {
            this.dependenciesA = set.toArray(new Dependency[set.size()]);
            set = null;
            return;
        }
        HashSet<Dependency> hashSet = new HashSet<Dependency>(20);
        Set set2 = Dependency.create((int)4, (String)attributes.getValue("OpenIDE-Module-IDE-Dependencies"));
        if (!set2.isEmpty()) {
            object = (Dependency)set2.iterator().next();
            String string = object.getName();
            if (!string.startsWith("IDE/")) {
                throw new IllegalStateException("Weird IDE dep: " + string);
            }
            hashSet.addAll(Dependency.create((int)1, (String)("org.openide/" + string.substring(4) + " > " + object.getVersion())));
            if (hashSet.size() != 1) {
                throw new IllegalStateException("Should be singleton: " + hashSet);
            }
            Util.err.warning("the module " + this.codeNameBase + " uses OpenIDE-Module-IDE-Dependencies which is deprecated. See http://openide.netbeans.org/proposals/arch/modularize.html");
        }
        hashSet.addAll(Dependency.create((int)3, (String)attributes.getValue("OpenIDE-Module-Java-Dependencies")));
        hashSet.addAll(Dependency.create((int)1, (String)attributes.getValue("OpenIDE-Module-Module-Dependencies")));
        object = attributes.getValue("OpenIDE-Module-Package-Dependencies");
        if (object != null) {
            hashSet.addAll(Dependency.create((int)2, (String)object));
        }
        hashSet.addAll(Dependency.create((int)5, (String)attributes.getValue("OpenIDE-Module-Requires")));
        hashSet.addAll(Dependency.create((int)6, (String)attributes.getValue("OpenIDE-Module-Needs")));
        hashSet.addAll(Dependency.create((int)7, (String)attributes.getValue("OpenIDE-Module-Recommends")));
        this.mgr.refineDependencies(this, hashSet);
        this.dependenciesA = hashSet.toArray(new Dependency[hashSet.size()]);
    }

    public static final class PackageExport {
        public final String pkg;
        public final boolean recursive;

        public PackageExport(String string, boolean bl) {
            this.pkg = string;
            this.recursive = bl;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "**/" : "") + "]";
        }

        public boolean equals(Object object) {
            if (!(object instanceof PackageExport)) {
                return false;
            }
            PackageExport packageExport = (PackageExport)object;
            return this.pkg.equals(packageExport.pkg) && this.recursive == packageExport.recursive;
        }

        public int hashCode() {
            return this.pkg.hashCode();
        }
    }
}

