/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Component;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class IOContainer {
    private static IOContainer defaultIOContainer;
    private Provider provider;
    private static final Logger LOGGER;

    public static IOContainer create(Provider provider) {
        Parameters.notNull((CharSequence)"provider", (Object)provider);
        return new IOContainer(provider);
    }

    public static IOContainer getDefault() {
        if (defaultIOContainer == null) {
            Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
            if (provider == null) {
                provider = new Trivial();
            }
            defaultIOContainer = IOContainer.create(provider);
        }
        return defaultIOContainer;
    }

    private IOContainer(Provider provider) {
        this.provider = provider;
    }

    public void open() {
        this.log("open()", new Object[0]);
        this.provider.open();
    }

    public void requestActive() {
        this.log("requestActive()", new Object[0]);
        this.provider.requestActive();
    }

    public void requestVisible() {
        this.log("requestVisible()", new Object[0]);
        this.provider.requestVisible();
    }

    public boolean isActivated() {
        this.log("isActivated()", new Object[0]);
        return this.provider.isActivated();
    }

    public void add(JComponent jComponent, CallBacks callBacks) {
        this.log("requestVisible()", jComponent, callBacks);
        this.provider.add(jComponent, callBacks);
    }

    public void remove(JComponent jComponent) {
        this.log("remove()", jComponent);
        this.provider.remove(jComponent);
    }

    public void select(JComponent jComponent) {
        this.log("select()", jComponent);
        this.provider.select(jComponent);
    }

    public JComponent getSelected() {
        this.log("getSelected()", new Object[0]);
        return this.provider.getSelected();
    }

    public void setTitle(JComponent jComponent, String string) {
        this.log("setTitle()", jComponent, string);
        this.provider.setTitle(jComponent, string);
    }

    public void setToolTipText(JComponent jComponent, String string) {
        this.log("setToolTipText()", jComponent, string);
        this.provider.setToolTipText(jComponent, string);
    }

    public void setIcon(JComponent jComponent, Icon icon) {
        this.log("setIcon()", jComponent, icon);
        this.provider.setIcon(jComponent, icon);
    }

    public void setToolbarActions(JComponent jComponent, Action[] actionArray) {
        this.log("setToolbarActions()", jComponent, actionArray);
        this.provider.setToolbarActions(jComponent, actionArray);
    }

    public boolean isCloseable(JComponent jComponent) {
        this.log("isCloseable()", jComponent);
        return this.provider.isCloseable(jComponent);
    }

    private synchronized void log(String string, Object ... objectArray) {
        LOGGER.log(Level.FINER, "{0}: {1} {2}", new Object[]{this.provider.getClass(), string, Arrays.asList(objectArray)});
        IOContainer.checkIsEDT();
    }

    private static void checkIsEDT() {
        if (!SwingUtilities.isEventDispatchThread()) {
            StackTraceElement[] stackTraceElementArray;
            Level level = Level.FINE;
            assert ((level = Level.WARNING) != null);
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
                if (!"java.awt.EventDispatchThread".equals(stackTraceElement.getClassName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                LOGGER.log(level, null, new IllegalStateException("Should be called from AWT thread."));
            } else {
                LOGGER.log(level, null, new IllegalStateException("Known problem in JDK occurred. If you are interested, vote and report at:\nhttp://bugs.sun.com/view_bug.do?bug_id=6424157, http://bugs.sun.com/view_bug.do?bug_id=6553239 \nAlso see related discussion at http://www.netbeans.org/issues/show_bug.cgi?id=90590"));
            }
        }
    }

    static {
        LOGGER = Logger.getLogger(IOContainer.class.getName());
    }

    private static class Trivial
    extends JTabbedPane
    implements Provider {
        private JFrame frame;

        private Trivial() {
        }

        public void open() {
            if (this.frame == null) {
                this.frame = new JFrame();
                this.frame.setDefaultCloseOperation(1);
                this.frame.add(this);
                if (this.getTabCount() > 0) {
                    this.frame.setTitle(this.getTitleAt(0));
                }
                this.frame.pack();
            }
            this.frame.setVisible(true);
        }

        public void requestActive() {
            this.frame.requestFocus();
        }

        public void requestVisible() {
            this.frame.setVisible(true);
        }

        public boolean isActivated() {
            return this.frame.isActive();
        }

        public void add(JComponent jComponent, CallBacks callBacks) {
            this.add(jComponent);
        }

        public void remove(JComponent jComponent) {
            this.remove((Component)jComponent);
        }

        public void select(JComponent jComponent) {
            this.setSelectedComponent(jComponent);
        }

        public JComponent getSelected() {
            return (JComponent)this.getSelectedComponent();
        }

        public void setTitle(JComponent jComponent, String string) {
            this.setTitleAt(this.indexOfComponent(jComponent), string);
        }

        public void setToolTipText(JComponent jComponent, String string) {
            this.setToolTipTextAt(this.indexOfComponent(jComponent), string);
        }

        public void setIcon(JComponent jComponent, Icon icon) {
            this.setIconAt(this.indexOfComponent(jComponent), icon);
        }

        public void setToolbarActions(JComponent jComponent, Action[] actionArray) {
        }

        public boolean isCloseable(JComponent jComponent) {
            return true;
        }
    }

    public static interface CallBacks {
        public void closed();

        public void selected();

        public void activated();

        public void deactivated();
    }

    public static interface Provider {
        public void open();

        public void requestActive();

        public void requestVisible();

        public boolean isActivated();

        public void add(JComponent var1, CallBacks var2);

        public void remove(JComponent var1);

        public void select(JComponent var1);

        public JComponent getSelected();

        public void setTitle(JComponent var1, String var2);

        public void setToolTipText(JComponent var1, String var2);

        public void setIcon(JComponent var1, Icon var2);

        public void setToolbarActions(JComponent var1, Action[] var2);

        public boolean isCloseable(JComponent var1);
    }
}

