/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class Breakpoint {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_DISPOSED = "disposed";
    public static final String PROP_GROUP_NAME = "groupName";
    public static final String PROP_VALIDITY = "validity";
    public static final String PROP_HIT_COUNT_FILTER = "hitCountFilter";
    private PropertyChangeSupport pcs;
    private String groupName = "";
    private VALIDITY validity = VALIDITY.UNKNOWN;
    private String validityMessage;
    private int hitCountFilter;
    private HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle;

    public Breakpoint() {
        this.pcs = new PropertyChangeSupport(this);
    }

    protected void dispose() {
    }

    public abstract boolean isEnabled();

    public abstract void disable();

    public abstract void enable();

    public final synchronized VALIDITY getValidity() {
        return this.validity;
    }

    public final synchronized String getValidityMessage() {
        return this.validityMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setValidity(VALIDITY vALIDITY, String string) {
        VALIDITY vALIDITY2;
        Breakpoint breakpoint = this;
        synchronized (breakpoint) {
            this.validityMessage = string;
            if (this.validity == vALIDITY) {
                return;
            }
            vALIDITY2 = this.validity;
            this.validity = vALIDITY;
        }
        this.firePropertyChange(PROP_VALIDITY, (Object)vALIDITY2, (Object)vALIDITY);
    }

    public final synchronized int getHitCountFilter() {
        return this.hitCountFilter;
    }

    public final synchronized HIT_COUNT_FILTERING_STYLE getHitCountFilteringStyle() {
        return this.hitCountFilteringStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHitCountFilter(int n, HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE) {
        Object[] objectArray;
        Object[] objectArray2;
        Breakpoint breakpoint = this;
        synchronized (breakpoint) {
            if (n == this.hitCountFilter && hIT_COUNT_FILTERING_STYLE == this.hitCountFilteringStyle) {
                return;
            }
            if (hIT_COUNT_FILTERING_STYLE == null && n > 0) {
                throw new NullPointerException("hitCountFilteringStyle must not be null.");
            }
            if (n == 0) {
                hIT_COUNT_FILTERING_STYLE = null;
            }
            objectArray2 = this.hitCountFilter == 0 ? null : new Object[]{this.hitCountFilter, this.hitCountFilteringStyle};
            objectArray = n == 0 ? null : new Object[]{n, hIT_COUNT_FILTERING_STYLE};
            this.hitCountFilter = n;
            this.hitCountFilteringStyle = hIT_COUNT_FILTERING_STYLE;
        }
        this.firePropertyChange(PROP_HIT_COUNT_FILTER, objectArray2, objectArray);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        if (this.groupName.equals(string)) {
            return;
        }
        String string2 = this.groupName;
        this.groupName = string.intern();
        this.firePropertyChange(PROP_GROUP_NAME, string2, string);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    void disposeOut() {
        this.dispose();
        this.firePropertyChange(PROP_DISPOSED, Boolean.FALSE, Boolean.TRUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HIT_COUNT_FILTERING_STYLE {
        EQUAL,
        GREATER,
        MULTIPLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VALIDITY {
        UNKNOWN,
        VALID,
        INVALID;

    }
}

