/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginProperties;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBDeploymentFactory
implements DeploymentFactory {
    public static final String URI_PREFIX = "jboss-deployer:";
    private static final String DISCONNECTED_URI = "jboss-deployer:http://localhost:8080&";
    private static final Logger LOGGER = Logger.getLogger(JBDeploymentFactory.class.getName());
    private static JBDeploymentFactory instance;
    private HashMap jbossFactories = new HashMap();
    private static final String INSTALL_ROOT_PROP_NAME = "org.netbeans.modules.j2ee.jboss4.installRoot";

    public static synchronized DeploymentFactory create() {
        if (instance == null) {
            instance = new JBDeploymentFactory();
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
            JBDeploymentFactory.registerDefaultServerInstance();
        }
        return instance;
    }

    public static URLClassLoader getJBClassLoader(String string, String string2) {
        try {
            Object object;
            JBPluginUtils.Version version = JBPluginUtils.getServerVersion(new File(string));
            boolean bl = version != null && version.compareToIgnoreUpdate(JBPluginUtils.JBOSS_5_0_0) >= 0;
            File file = new File(string, JBPluginUtils.LIB + "dom4j.jar");
            if (!file.exists()) {
                file = new File(string2, JBPluginUtils.LIB + "dom4j.jar");
            }
            if (!file.exists()) {
                file = null;
                LOGGER.log(Level.INFO, "No dom4j.jar availabale on classpath");
            }
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (file != null) {
                arrayList.add(file.toURI().toURL());
            }
            if (bl) {
                object = JBPluginUtils.getJB5ClientClasspath(string);
                arrayList.addAll((Collection<URL>)object);
                File file2 = new File(string, "bin" + File.separator + "run.jar");
                if (file2.exists()) {
                    arrayList.add(file2.toURI().toURL());
                }
            } else {
                arrayList.add(new File(string, JBPluginUtils.CLIENT + "jbossall-client.jar").toURI().toURL());
                arrayList.add(new File(string, JBPluginUtils.CLIENT + "jboss-deployment.jar").toURI().toURL());
                arrayList.add(new File(string, JBPluginUtils.CLIENT + "jnp-client.jar").toURI().toURL());
                object = new File(string, JBPluginUtils.CLIENT + "jboss-common-client.jar");
                if (((File)object).exists()) {
                    arrayList.add(((File)object).toURI().toURL());
                }
            }
            object = new JBClassLoader(arrayList.toArray(new URL[0]), JBDeploymentFactory.class.getClassLoader());
            return object;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, null, exception);
            return null;
        }
    }

    public DeploymentFactory getFactory(String string) {
        DeploymentFactory deploymentFactory = null;
        try {
            String string2 = InstanceProperties.getInstanceProperties((String)string).getProperty("root-dir");
            String string3 = InstanceProperties.getInstanceProperties((String)string).getProperty("server-dir");
            if (string2 == null) {
                string2 = JBPluginProperties.getInstance().getInstallLocation();
            }
            if (string3 == null) {
                string3 = JBPluginProperties.getInstance().getDomainLocation();
            }
            if ((deploymentFactory = (DeploymentFactory)this.jbossFactories.get(string2)) == null) {
                URLClassLoader uRLClassLoader = JBDeploymentFactory.getJBClassLoader(string2, string3);
                deploymentFactory = (DeploymentFactory)uRLClassLoader.loadClass("org.jboss.deployment.spi.factories.DeploymentFactoryImpl").newInstance();
                this.jbossFactories.put(string2, deploymentFactory);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, null, exception);
        }
        return deploymentFactory;
    }

    public boolean handlesURI(String string) {
        return string != null && string.startsWith(URI_PREFIX);
    }

    public DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        if (!this.handlesURI(string)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)string));
        }
        try {
            DeploymentFactory deploymentFactory = this.getFactory(string);
            if (deploymentFactory == null) {
                throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_ERROR_CREATING_DM", (Object)string));
            }
            String string4 = string;
            try {
                string4 = string.substring(0, string.indexOf("&"));
            }
            catch (Exception exception) {
                LOGGER.log(Level.INFO, null, exception);
            }
            return new JBDeploymentManager(deploymentFactory.getDeploymentManager(string4, string2, string3), string, string2, string3);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            DeploymentManagerCreationException deploymentManagerCreationException = new DeploymentManagerCreationException("Classpath is incomplete");
            deploymentManagerCreationException.initCause((Throwable)noClassDefFoundError);
            throw deploymentManagerCreationException;
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        if (!this.handlesURI(string)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)string));
        }
        try {
            DeploymentFactory deploymentFactory = null;
            InstanceProperties instanceProperties = InstanceProperties.getInstanceProperties((String)string);
            if (instanceProperties == null) {
                if (!DISCONNECTED_URI.equals(string)) {
                    throw new DeploymentManagerCreationException("JBoss instance " + string + " is not registered in the IDE.");
                }
            } else {
                deploymentFactory = this.getFactory(string);
                if (deploymentFactory == null) {
                    throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_ERROR_CREATING_DM", (Object)string));
                }
            }
            String string2 = string;
            try {
                string2 = string.substring(0, string.indexOf("&"));
            }
            catch (Exception exception) {
                LOGGER.log(Level.INFO, null, exception);
            }
            return new JBDeploymentManager(deploymentFactory != null ? deploymentFactory.getDisconnectedDeploymentManager(string2) : null, string, null, null);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            DeploymentManagerCreationException deploymentManagerCreationException = new DeploymentManagerCreationException("Classpath is incomplete");
            deploymentManagerCreationException.initCause((Throwable)noClassDefFoundError);
            throw deploymentManagerCreationException;
        }
    }

    public String getProductVersion() {
        return NbBundle.getMessage(JBDeploymentFactory.class, (String)"LBL_JBossFactoryVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JBDeploymentFactory.class, (String)"SERVER_NAME");
    }

    private static void registerDefaultServerInstance() {
        try {
            FileObject fileObject = JBDeploymentFactory.getServerInstanceDir();
            String string = JBDeploymentFactory.getDefaultInstallLocation();
            String string2 = string + File.separator + "server" + File.separator + "default";
            JBDeploymentFactory.setRemovability(fileObject, string2);
            File file = new File(string);
            if (JBPluginUtils.isGoodJBLocation(file, new File(string2)) && !JBDeploymentFactory.isAlreadyRegistered(fileObject, string2)) {
                String string3 = "localhost";
                String string4 = JBPluginUtils.getHTTPConnectorPort(string2);
                JBDeploymentFactory.register(fileObject, string, string2, string3, string4);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.getMessage());
        }
    }

    private static String getDefaultInstallLocation() {
        String string = System.getProperty(INSTALL_ROOT_PROP_NAME);
        if (string != null && new File(string).exists()) {
            return string;
        }
        return "";
    }

    private static boolean isAlreadyRegistered(FileObject fileObject, String string) throws IOException {
        String string2 = new File(string).getCanonicalPath();
        for (FileObject fileObject2 : fileObject.getChildren()) {
            String string3;
            String string4 = (String)fileObject2.getAttribute("server-dir");
            if (string4 == null || !string2.equals(string3 = new File(string4).getCanonicalPath())) continue;
            return true;
        }
        return false;
    }

    private static void setRemovability(FileObject fileObject, String string) throws IOException {
        String string2 = new File(string).getCanonicalPath();
        for (FileObject fileObject2 : fileObject.getChildren()) {
            String string3 = (String)fileObject2.getAttribute("url");
            if (string3 == null) {
                LOGGER.log(Level.INFO, "No server URL in " + FileUtil.getFileDisplayName((FileObject)fileObject2));
                continue;
            }
            if (!string3.startsWith(URI_PREFIX)) continue;
            String string4 = (String)fileObject2.getAttribute("server-dir");
            String string5 = new File(string4).getCanonicalPath();
            if (string2.equals(string5)) {
                fileObject2.setAttribute("removeForbidden", (Object)Boolean.TRUE);
                continue;
            }
            if (fileObject2.getAttribute("removeForbidden") == null) continue;
            fileObject2.setAttribute("removeForbidden", (Object)Boolean.FALSE);
        }
    }

    private static void register(FileObject fileObject, String string, String string2, String string3, String string4) throws IOException {
        String string5 = JBDeploymentFactory.generateDisplayName(fileObject);
        String string6 = URI_PREFIX + string3 + ":" + string4 + "#default&" + string;
        String string7 = FileUtil.findFreeFileName((FileObject)fileObject, (String)"instance", null);
        FileObject fileObject2 = fileObject.createData(string7);
        fileObject2.setAttribute("url", (Object)string6);
        fileObject2.setAttribute("username", (Object)"");
        fileObject2.setAttribute("password", (Object)"");
        fileObject2.setAttribute("displayName", (Object)string5);
        fileObject2.setAttribute("removeForbidden", (Object)"true");
        fileObject2.setAttribute("server", (Object)"default");
        String string8 = JBPluginUtils.getDeployDir(string2);
        fileObject2.setAttribute("deploy-dir", (Object)string8);
        fileObject2.setAttribute("server-dir", (Object)string2);
        fileObject2.setAttribute("root-dir", (Object)string);
        fileObject2.setAttribute("host", (Object)string3);
        fileObject2.setAttribute("port", (Object)string4);
    }

    private static FileObject getServerInstanceDir() {
        FileObject fileObject = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        return fileObject;
    }

    private static String generateDisplayName(FileObject fileObject) {
        String string;
        String string2 = string = NbBundle.getMessage(JBDeploymentFactory.class, (String)"SERVER_NAME");
        int n = 1;
        Set<String> set = JBDeploymentFactory.getServerInstancesNames(fileObject);
        while (set.contains(string2.toUpperCase())) {
            string2 = string + " (" + String.valueOf(n++) + ")";
        }
        return string2;
    }

    private static Set<String> getServerInstancesNames(FileObject fileObject) {
        HashSet<String> hashSet = new HashSet<String>();
        for (FileObject fileObject2 : fileObject.getChildren()) {
            String string = (String)fileObject2.getAttribute("displayName");
            hashSet.add(string.toUpperCase());
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JBClassLoader
    extends URLClassLoader {
        public JBClassLoader(URL[] uRLArray, ClassLoader classLoader) throws MalformedURLException, RuntimeException {
            super(uRLArray, classLoader);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            return permissions;
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            if (string.indexOf("jndi.properties") != -1) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(string);
        }
    }
}

