/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.tools.impl.LLDataCollectorConfigurationAccessor;
import org.netbeans.modules.dlight.tools.impl.ProcDataProvider;

public class ProcDataProviderLinux
implements ProcDataProvider.Engine {
    private static final Set<Integer> USR_TIME_IDX = new HashSet<Integer>(Arrays.asList(13, 15, 42, 43));
    private static final Set<Integer> SYS_TIME_IDX = new HashSet<Integer>(Arrays.asList(14, 16, 41));
    private static final int THREADS_IDX = 19;
    private final ProcDataProvider provider;
    private final ServiceInfoDataStorage serviceInfoStorage;
    private final boolean decreaseThreads;

    public ProcDataProviderLinux(ProcDataProvider procDataProvider, ServiceInfoDataStorage serviceInfoDataStorage) {
        this.provider = procDataProvider;
        this.serviceInfoStorage = serviceInfoDataStorage;
        String[] stringArray = this.serviceInfoStorage == null || serviceInfoDataStorage.getValue("service.storage.idp.names") == null ? null : serviceInfoDataStorage.getValue("service.storage.idp.names").split(":");
        List list = stringArray == null ? null : Arrays.asList(stringArray);
        this.decreaseThreads = list == null ? false : list.contains(LLDataCollectorConfigurationAccessor.getDefault().getName());
    }

    public String getCommand(int n) {
        return "while head -n1 /proc/stat && head -n1 /proc/" + n + "/stat; do sleep 1; done";
    }

    public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
        return InputProcessors.bridge((LineProcessor)new LinuxProcLineProcessor());
    }

    private static float percent(long l, long l2) {
        if (0L < l2) {
            if (l <= 0L) {
                return 0.0f;
            }
            if (l2 <= l) {
                return 100.0f;
            }
            return 100.0f * (float)l / (float)l2;
        }
        return 0.0f;
    }

    private class LinuxProcLineProcessor
    implements LineProcessor {
        private int threads;
        private long prevTicks;
        private long currTicks;
        private long prevUsrTicks;
        private long currUsrTicks;
        private long prevSysTicks;
        private long currSysTicks;

        private LinuxProcLineProcessor() {
        }

        public void processLine(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                if (stringTokenizer.nextToken().equals("cpu")) {
                    this.prevTicks = this.currTicks;
                    long l = 0L;
                    while (stringTokenizer.hasMoreTokens()) {
                        l += Long.parseLong(stringTokenizer.nextToken());
                    }
                    this.currTicks = l;
                } else {
                    this.prevUsrTicks = this.currUsrTicks;
                    this.prevSysTicks = this.currSysTicks;
                    long l = 0L;
                    long l2 = 0L;
                    int n = 1;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (USR_TIME_IDX.contains(n)) {
                            l += Long.parseLong(string2);
                        } else if (SYS_TIME_IDX.contains(n)) {
                            l2 += Long.parseLong(string2);
                        } else if (19 == n) {
                            this.threads = Integer.parseInt(string2);
                        }
                        ++n;
                    }
                    if (ProcDataProviderLinux.this.decreaseThreads) {
                        --this.threads;
                    }
                    this.currUsrTicks = l;
                    this.currSysTicks = l2;
                    if (0L < this.prevTicks) {
                        long l3 = this.currTicks - this.prevTicks;
                        float f = ProcDataProviderLinux.percent(this.currUsrTicks - this.prevUsrTicks, l3);
                        float f2 = ProcDataProviderLinux.percent(this.currSysTicks - this.prevSysTicks, l3);
                        DataRow dataRow = new DataRow(Arrays.asList(ProcDataProviderConfiguration.USR_TIME.getColumnName(), ProcDataProviderConfiguration.SYS_TIME.getColumnName(), ProcDataProviderConfiguration.THREADS.getColumnName()), Arrays.asList(Float.valueOf(f), Float.valueOf(f2), this.threads));
                        ProcDataProviderLinux.this.provider.notifyIndicators(dataRow);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

