/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.tools.impl.LLDataCollectorConfigurationAccessor;
import org.netbeans.modules.dlight.tools.impl.NativeToolsUtil;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LLDataCollector
extends IndicatorDataProvider<LLDataCollectorConfiguration>
implements DataCollector<LLDataCollectorConfiguration>,
DLightTarget.ExecutionEnvVariablesProvider {
    private EnumSet<LLDataCollectorConfiguration.CollectedData> collectedData;
    private DLightTarget target;
    private ValidationStatus validationStatus;
    private List<ValidationListener> validationListeners;
    private final String name;

    public LLDataCollector(LLDataCollectorConfiguration lLDataCollectorConfiguration) {
        this.collectedData = EnumSet.of(LLDataCollectorConfigurationAccessor.getDefault().getCollectedData(lLDataCollectorConfiguration));
        this.name = LLDataCollectorConfigurationAccessor.getDefault().getName();
        this.validationStatus = ValidationStatus.initialStatus();
        this.validationListeners = new ArrayList<ValidationListener>();
    }

    public void addConfiguration(LLDataCollectorConfiguration lLDataCollectorConfiguration) {
        this.collectedData.add(LLDataCollectorConfigurationAccessor.getDefault().getCollectedData(lLDataCollectorConfiguration));
    }

    public String getName() {
        return this.name;
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        ArrayList<DataTableMetadata> arrayList = new ArrayList<DataTableMetadata>();
        if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.CPU)) {
            arrayList.add(LLDataCollectorConfiguration.CPU_TABLE);
        }
        if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.MEM)) {
            arrayList.add(LLDataCollectorConfiguration.MEM_TABLE);
        }
        if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.SYNC)) {
            arrayList.add(LLDataCollectorConfiguration.SYNC_TABLE);
        }
        return arrayList;
    }

    public Collection<DataStorageType> getSupportedDataStorageTypes() {
        return Arrays.asList(DataStorageTypeFactory.getInstance().getDataStorageType("db:sql"));
    }

    public void init(DataStorage dataStorage, DLightTarget dLightTarget) {
        block2: {
            this.target = dLightTarget;
            ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
            if (executionEnvironment.isLocal()) break block2;
            for (Map.Entry<String, File> entry : this.locateProfAgents(executionEnvironment).entrySet()) {
                this.upload(executionEnvironment, entry.getValue(), this.getRemoteDir(executionEnvironment, entry.getValue(), entry.getKey()), 420);
            }
            Iterator<Map.Entry<String, File>> iterator = this.locateProfMonitors(executionEnvironment).entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, File> entry;
                entry = iterator.next();
                this.upload(executionEnvironment, entry.getValue(), this.getRemoteDir(executionEnvironment, entry.getValue(), entry.getKey()), 493);
            }
        }
    }

    private void upload(ExecutionEnvironment executionEnvironment, File file, String string, int n) {
        try {
            CommonTasksSupport.mkDir((ExecutionEnvironment)executionEnvironment, (String)string, null).get();
            CommonTasksSupport.uploadFile((String)file.getAbsolutePath(), (ExecutionEnvironment)executionEnvironment, (String)(string + "/" + file.getName()), (int)n, null).get();
        }
        catch (InterruptedException interruptedException) {
            DLightLogger.instance.log(Level.WARNING, null, interruptedException);
        }
        catch (ExecutionException executionException) {
            DLightLogger.instance.log(Level.WARNING, null, executionException);
        }
    }

    public boolean isAttachable() {
        return true;
    }

    public String getCmd() {
        return null;
    }

    public String[] getArgs() {
        return null;
    }

    public Map<String, String> getExecutionEnv(DLightTarget dLightTarget) throws ConnectException {
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        Map<String, File> map = this.locateProfAgents(executionEnvironment);
        if (!map.isEmpty()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            for (Map.Entry<String, File> entry : map.entrySet()) {
                if (string == null) {
                    string = entry.getValue().getName();
                }
                if (0 < stringBuilder.length()) {
                    stringBuilder.append(':');
                }
                stringBuilder.append(this.getRemoteDir(executionEnvironment, entry.getValue(), entry.getKey()));
            }
            hashMap.put(NativeToolsUtil.getLdPathName(executionEnvironment), stringBuilder.toString());
            hashMap.put(NativeToolsUtil.getLdPreloadName(executionEnvironment), string);
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private String getRemoteDir(ExecutionEnvironment executionEnvironment, File file, String string) {
        String string2;
        if (executionEnvironment.isLocal()) {
            return file.getParentFile().getAbsolutePath();
        }
        try {
            string2 = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getTempDir();
        }
        catch (Throwable throwable) {
            string2 = "/var/tmp";
        }
        return string2 + "/tools/" + string;
    }

    private Map<String, File> locateProfAgents(ExecutionEnvironment executionEnvironment) {
        return NativeToolsUtil.getCompatibleBinaries(executionEnvironment, "prof_agent.${soext}");
    }

    private Map<String, File> locateProfMonitors(ExecutionEnvironment executionEnvironment) {
        return NativeToolsUtil.getCompatibleBinaries(executionEnvironment, "prof_monitor");
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.startMonitor();
            }
        }
    }

    private void startMonitor() {
        ExecutionDescriptor executionDescriptor;
        AttachableTarget attachableTarget = (AttachableTarget)this.target;
        ExecutionEnvironment executionEnvironment = this.target.getExecEnv();
        NativeProcessBuilder nativeProcessBuilder = null;
        Iterator<Map.Entry<String, File>> iterator = this.locateProfMonitors(executionEnvironment).entrySet().iterator();
        if (iterator.hasNext()) {
            executionDescriptor = iterator.next();
            nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
            nativeProcessBuilder.setExecutable(this.getRemoteDir(executionEnvironment, executionDescriptor.getValue(), executionDescriptor.getKey()) + "/" + executionDescriptor.getValue().getName());
        }
        if (nativeProcessBuilder == null) {
            DLightLogger.instance.severe("Failed to find prof_monitor");
            return;
        }
        iterator = new StringBuilder("-");
        if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.CPU)) {
            ((StringBuilder)((Object)iterator)).append('c');
        }
        if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.MEM)) {
            ((StringBuilder)((Object)iterator)).append('m');
        }
        if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.SYNC)) {
            ((StringBuilder)((Object)iterator)).append('s');
        }
        nativeProcessBuilder = nativeProcessBuilder.setArguments(new String[]{((StringBuilder)((Object)iterator)).toString(), String.valueOf(attachableTarget.getPID())});
        executionDescriptor = new ExecutionDescriptor();
        executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                return InputProcessors.bridge((LineProcessor)new MonitorOutputProcessor());
            }
        });
        executionDescriptor = executionDescriptor.inputOutput(InputOutput.NULL);
        ExecutionService executionService = ExecutionService.newService((Callable)nativeProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)"monitor");
        executionService.run();
    }

    public void dataFiltersChanged(List<DataFilter> list) {
    }

    public ValidationStatus validate(DLightTarget dLightTarget) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus validationStatus = this.validationStatus;
        ValidationStatus validationStatus2 = this.doValidation(dLightTarget);
        this.notifyStatusChanged(validationStatus, validationStatus2);
        this.validationStatus = validationStatus2;
        return validationStatus2;
    }

    public void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    private ValidationStatus doValidation(DLightTarget dLightTarget) {
        DLightLogger.assertNonUiThread();
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        if (!ConnectionManager.getInstance().isConnectedTo(executionEnvironment)) {
            AsynchronousAction asynchronousAction = ConnectionManager.getInstance().getConnectToAction(executionEnvironment, new Runnable(){

                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            });
            return ValidationStatus.unknownStatus((String)LLDataCollector.getMessage("ValidationStatus.HostNotConnected"), (AsynchronousAction)asynchronousAction);
        }
        HostInfo.OSFamily oSFamily = HostInfo.OSFamily.UNKNOWN;
        try {
            oSFamily = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getOSFamily();
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (oSFamily != HostInfo.OSFamily.LINUX) {
            return ValidationStatus.invalidStatus((String)LLDataCollector.getMessage("ValidationStatus.ProfAgent.OSNotSupported"));
        }
        Map<String, File> map = this.locateProfAgents(executionEnvironment);
        if (map.isEmpty()) {
            return ValidationStatus.invalidStatus((String)LLDataCollector.getMessage("ValidationStatus.AgentNotFound"));
        }
        Map<String, File> map2 = this.locateProfMonitors(executionEnvironment);
        if (map2.isEmpty()) {
            return ValidationStatus.invalidStatus((String)LLDataCollector.getMessage("ValidationStatus.MonitorNotFound"));
        }
        return ValidationStatus.validStatus();
    }

    private void notifyStatusChanged(ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (!validationStatus.equals((Object)validationStatus2)) {
            for (ValidationListener validationListener : this.validationListeners) {
                validationListener.validationStateChanged((Validateable)this, validationStatus, validationStatus2);
            }
        }
    }

    public void addValidationListener(ValidationListener validationListener) {
        if (!this.validationListeners.contains(validationListener)) {
            this.validationListeners.add(validationListener);
        }
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(LLDataCollector.class, (String)string);
    }

    private class MonitorOutputProcessor
    implements LineProcessor {
        private float syncPrev;

        private MonitorOutputProcessor() {
        }

        public void processLine(String string) {
            DataRow dataRow = null;
            if (string.startsWith("cpu:")) {
                String[] stringArray = string.substring(5).split("\t");
                dataRow = new DataRow(LLDataCollectorConfiguration.CPU_TABLE.getColumnNames(), Arrays.asList(Float.valueOf(stringArray[0]), Float.valueOf(stringArray[1])));
            } else if (string.startsWith("mem:")) {
                dataRow = new DataRow(LLDataCollectorConfiguration.MEM_TABLE.getColumnNames(), Arrays.asList(string.substring(5)));
            } else if (string.startsWith("sync:")) {
                String[] stringArray = string.substring(6).split("\t");
                float f = Float.parseFloat(stringArray[0]);
                if (0.0f < this.syncPrev) {
                    int n = Integer.parseInt(stringArray[1]);
                    dataRow = new DataRow(LLDataCollectorConfiguration.SYNC_TABLE.getColumnNames(), Arrays.asList(Float.valueOf((f - this.syncPrev) * 100.0f / (float)n), n));
                }
                this.syncPrev = f;
            }
            if (dataRow != null) {
                LLDataCollector.this.notifyIndicators(Collections.singletonList(dataRow));
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

