/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.derby.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Utilities;

public class JDKDerbyHelper {
    private static final Logger LOGGER = Logger.getLogger(JDKDerbyHelper.class.getName());
    private final JavaPlatform platform;

    public static JDKDerbyHelper forDefaultPlatform() {
        return new JDKDerbyHelper(JavaPlatformManager.getDefault().getDefaultPlatform());
    }

    private JDKDerbyHelper(JavaPlatform javaPlatform) {
        this.platform = javaPlatform;
    }

    public boolean canBundleDerby() {
        Specification specification = this.platform.getSpecification();
        if (specification == null) {
            return false;
        }
        SpecificationVersion specificationVersion = specification.getVersion();
        if (specificationVersion == null) {
            return false;
        }
        return specificationVersion.compareTo((Object)new SpecificationVersion("1.6")) >= 0;
    }

    public String findDerbyLocation() {
        Object object;
        Object object2;
        if (!this.canBundleDerby()) {
            return null;
        }
        if (Utilities.isWindows()) {
            Object object3;
            LOGGER.log(Level.FINE, "Operating system: Windows");
            object2 = System.getenv("ProgramFiles");
            LOGGER.log(Level.FINE, "Program Files path: {0}", object2);
            if (object2 != null && (object = JDKDerbyHelper.testDerbyInstallLocation((File)(object3 = new File((String)object2, "Sun/JavaDB")))) != null) {
                return object;
            }
        }
        if (Utilities.isUnix()) {
            LOGGER.log(Level.FINE, "Operating system: Unix");
            object2 = JDKDerbyHelper.testDerbyInstallLocation(new File("/opt/SUNWjavadb"));
            if (object2 != null) {
                return object2;
            }
            object2 = JDKDerbyHelper.testDerbyInstallLocation(new File("/opt/sun/javadb"));
            if (object2 != null) {
                return object2;
            }
            object2 = JDKDerbyHelper.testDerbyInstallLocation(new File("/usr/share/javadb"));
            if (object2 != null) {
                return object2;
            }
        }
        for (Object object3 : this.platform.getInstallFolders()) {
            String string;
            object = object3.getFileObject("db");
            if (object == null || (string = JDKDerbyHelper.testDerbyInstallLocation(FileUtil.toFile((FileObject)object))) == null) continue;
            return string;
        }
        return null;
    }

    private static String testDerbyInstallLocation(File file) {
        LOGGER.log(Level.FINE, "Testing directory: {0}", file);
        if (Util.isDerbyInstallLocation(file)) {
            return file.getAbsolutePath();
        }
        return null;
    }
}

