/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.Externalizable;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.tomcat.context.WebXmlReader;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.logging.TomcatLogger;
import org.apache.tomcat.service.PoolTcpConnector;
import org.apache.tomcat.startup.EmbededTomcat;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.netbeans.modules.httpserver.NbLoaderInterceptor;
import org.netbeans.modules.httpserver.NbServletsInterceptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HttpServerModule
extends ModuleInstall
implements Externalizable {
    private static ContextManager server;
    private static ContextReloader reloader;
    private static Thread serverThread;
    private static boolean inSetRunning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            HttpServerModule.stopHTTPServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initHTTPServer() {
        if (inSetRunning) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            if (inSetRunning) {
                return;
            }
            inSetRunning = true;
            try {
                if (serverThread != null) {
                    HttpServerModule.httpserverSettings();
                    if (!HttpServerSettings.running) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (serverThread != null) {
                            HttpServerModule.httpserverSettings();
                            if (!HttpServerSettings.running) {
                                serverThread.stop();
                                serverThread = null;
                            }
                        }
                    }
                }
                if (serverThread == null) {
                    serverThread = new Thread("HTTPServer"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                server = HttpServerModule.buildServer();
                                server.start();
                                HttpServerModule.httpserverSettings().runSuccess();
                                reloader.activate();
                                if (HttpServerModule.httpserverSettings().isStartStopMessages()) {
                                    System.out.println(NbBundle.getMessage(HttpServerModule.class, (String)"CTL_ServerStarted", (Object[])new Object[]{new Integer(HttpServerModule.httpserverSettings().getPort())}));
                                }
                            }
                            catch (ThreadDeath threadDeath) {
                                throw threadDeath;
                            }
                            catch (Throwable throwable) {
                                Logger.getLogger("global").log(Level.INFO, null, throwable);
                                serverThread = null;
                                inSetRunning = false;
                                HttpServerModule.httpserverSettings().runFailure(throwable);
                            }
                            finally {
                                HttpServerModule.httpserverSettings().setStartStopMessages(true);
                            }
                        }
                    };
                    serverThread.start();
                }
                try {
                    HttpServerSettings.httpLock().wait(3000L);
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.INFO, null, exception);
                }
            }
            finally {
                inSetRunning = false;
            }
        }
    }

    public void uninstalled() {
        HttpServerModule.stopHTTPServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopHTTPServer() {
        if (inSetRunning) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            block13: {
                if (inSetRunning) {
                    return;
                }
                inSetRunning = true;
                try {
                    if (reloader != null) {
                        reloader.deactivate();
                        reloader = null;
                    }
                    if (serverThread == null || server == null) break block13;
                    try {
                        server.stop();
                        serverThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        serverThread.stop();
                    }
                    catch (Exception exception) {
                        serverThread.stop();
                    }
                    serverThread = null;
                    if (HttpServerModule.httpserverSettings().isStartStopMessages()) {
                        System.out.println(NbBundle.getBundle(HttpServerModule.class).getString("CTL_ServerStopped"));
                    }
                }
                finally {
                    inSetRunning = false;
                }
            }
        }
    }

    private static ContextManager getContextManager(EmbededTomcat embededTomcat) {
        try {
            Field field = EmbededTomcat.class.getDeclaredField("contextM");
            field.setAccessible(true);
            return (ContextManager)field.get(embededTomcat);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    private static void removeWebXmlReader(EmbededTomcat embededTomcat) {
        try {
            Field field = EmbededTomcat.class.getDeclaredField("contextInt");
            field.setAccessible(true);
            Vector vector = (Vector)field.get(embededTomcat);
            for (Object e : vector) {
                if (!(e instanceof WebXmlReader)) continue;
                vector.remove(e);
                break;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
    }

    private static ContextManager buildServer() throws Exception {
        HttpServerSettings httpServerSettings = HttpServerModule.httpserverSettings();
        NbLogger nbLogger = new NbLogger();
        nbLogger.setName("tc_log");
        EmbededTomcat embededTomcat = new EmbededTomcat();
        File file = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
        file = new File(file, "httpwork");
        embededTomcat.setWorkDir(file.getAbsolutePath());
        NbLoaderInterceptor nbLoaderInterceptor = new NbLoaderInterceptor();
        embededTomcat.addContextInterceptor(nbLoaderInterceptor);
        embededTomcat.addApplicationAdapter(null);
        NbServletsInterceptor nbServletsInterceptor = new NbServletsInterceptor();
        embededTomcat.addContextInterceptor(nbServletsInterceptor);
        HttpServerModule.removeWebXmlReader(embededTomcat);
        ServletContext servletContext = embededTomcat.addContext("", file.toURI().toURL());
        embededTomcat.initContext(servletContext);
        embededTomcat.addEndpoint(httpServerSettings.getPort(), null, null);
        ContextManager contextManager = HttpServerModule.getContextManager(embededTomcat);
        reloader = new ContextReloader(embededTomcat, contextManager, servletContext);
        Enumeration enumeration = contextManager.getConnectors();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof PoolTcpConnector)) continue;
            PoolTcpConnector poolTcpConnector = (PoolTcpConnector)e;
            poolTcpConnector.setAttribute("min_spare_threads", "0");
            poolTcpConnector.setAttribute("max_spare_threads", "1");
            poolTcpConnector.setAttribute("max_threads", "3");
        }
        return contextManager;
    }

    static HttpServerSettings httpserverSettings() {
        return HttpServerSettings.getDefault();
    }

    static {
        inSetRunning = false;
    }

    private static class ContextReloader
    implements LookupListener,
    Runnable {
        private ServletContext ide_ctx;
        private EmbededTomcat tc;
        private ContextManager cm;
        private Lookup.Result<ClassLoader> res;

        public ContextReloader(EmbededTomcat embededTomcat, ContextManager contextManager, ServletContext servletContext) {
            this.ide_ctx = servletContext;
            this.tc = embededTomcat;
            this.cm = contextManager;
        }

        public void activate() {
            this.res = Lookup.getDefault().lookup(new Lookup.Template(ClassLoader.class));
            this.res.addLookupListener((LookupListener)this);
        }

        public void deactivate() {
            if (this.res != null) {
                this.res.removeLookupListener((LookupListener)this);
                this.res = null;
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            ClassLoader classLoader = (ClassLoader)this.res.allInstances().iterator().next();
            this.cm.setParentClassLoader(classLoader);
            File file = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
            file = new File(file, "httpwork");
            Enumeration enumeration = this.cm.getContexts();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof Context)) continue;
                Context context = (Context)e;
                this.tc.removeContext(this.ide_ctx);
                try {
                    this.ide_ctx = this.tc.addContext("", file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.tc.initContext(this.ide_ctx);
            }
        }
    }

    private static class NbLogger
    extends TomcatLogger {
        protected void realLog(String string) {
        }

        protected void realLog(String string, Throwable throwable) {
        }

        public void flush() {
        }
    }
}

