/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.api;

import java.util.Collection;
import org.netbeans.modules.websvc.wsstack.WSStackAccessor;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSStack<T> {
    private final WSStackImplementation<T> impl;
    private final Source stackSource;
    private final Class<T> stackDescriptor;

    public static <T> WSStack<T> findWSStack(Lookup lookup, Class<T> clazz) {
        Collection collection = lookup.lookupAll(WSStack.class);
        for (WSStack wSStack : collection) {
            if (wSStack.stackDescriptor != clazz) continue;
            return wSStack;
        }
        return null;
    }

    private WSStack(Class<T> clazz, WSStackImplementation<T> wSStackImplementation, Source source) {
        this.impl = wSStackImplementation;
        this.stackSource = source;
        this.stackDescriptor = clazz;
    }

    public T get() {
        return this.impl.get();
    }

    public WSStackVersion getVersion() {
        return this.impl.getVersion();
    }

    public WSTool getWSTool(Tool tool) {
        return this.impl.getWSTool(tool);
    }

    public boolean isFeatureSupported(Feature feature) {
        return this.impl.isFeatureSupported(feature);
    }

    public Source getSource() {
        return this.stackSource;
    }

    static {
        WSStackAccessor.DEFAULT = new WSStackAccessor(){

            @Override
            public <T> WSStack<T> createWSStack(Class<T> clazz, WSStackImplementation<T> wSStackImplementation, Source source) {
                return new WSStack(clazz, wSStackImplementation, source);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Source {
        IDE,
        JDK,
        SERVER;

    }

    public static interface Feature {
        public String getName();
    }

    public static interface Tool {
        public String getName();
    }
}

