/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PhpInterpreter {
    private static final Logger LOGGER = Logger.getLogger(PhpInterpreter.class.getName());
    private final String interpreter;
    private final String[] parameters;
    private final String fullCommand;

    public PhpInterpreter(String string) {
        if (string == null) {
            string = "";
        }
        String[] stringArray = string.split(" * (?=\\-|/)");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("%s => %s", string, Arrays.asList(stringArray)));
        }
        this.interpreter = stringArray[0].trim();
        if (stringArray.length == 1) {
            this.parameters = new String[0];
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length - 1);
            for (int i = 1; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i].trim());
            }
            this.parameters = arrayList.toArray(new String[arrayList.size()]);
        }
        this.fullCommand = string.trim();
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String getFullCommand() {
        return this.fullCommand;
    }

    public boolean isValid() {
        return this.interpreter.length() > 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [interpreter: ");
        stringBuilder.append(this.interpreter);
        stringBuilder.append(", parameters: ");
        stringBuilder.append(Arrays.asList(this.parameters));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

