/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.ui.LastUsedFolders;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.LocalServerController;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.wizards.ConfigurableProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureProjectPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ConfigureNewProjectPanelVisual
extends ConfigurableProjectPanel {
    private static final long serialVersionUID = 51987432745375479L;
    private final LocalServerController localServerComponent;
    private JComboBox encodingComboBox;
    private JLabel encodingLabel;
    private JButton localServerButton;
    private JComboBox localServerComboBox;
    private JLabel localServerInfoLabel;
    private JPanel projectFolderPanel;
    private JLabel projectNameLabel;
    protected JTextField projectNameTextField;
    private JSeparator separator;
    private JLabel sourcesLabel;

    ConfigureNewProjectPanelVisual(ConfigureProjectPanel configureProjectPanel) {
        this.setName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_ProjectNameLocation"));
        this.putClientProperty("WizardPanel_contentSelectedIndex", 0);
        this.putClientProperty("WizardPanel_contentData", configureProjectPanel.getSteps());
        this.initComponents();
        this.localServerComponent = LocalServerController.create(this.localServerComboBox, this.localServerButton, new BrowseSources(), NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_SelectSourceFolderTitle"), new LocalServer[0]);
        this.projectFolderPanel.add("North", this.projectFolderComponent);
        this.init();
    }

    private void init() {
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.localServerComponent.addChangeListener(this);
        this.encodingComboBox.setModel(new Utils.EncodingModel());
        this.encodingComboBox.setRenderer(new Utils.EncodingRenderer());
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.sourcesLabel = new JLabel();
        this.localServerComboBox = new JComboBox();
        this.localServerButton = new JButton();
        this.localServerInfoLabel = new JLabel();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox();
        this.separator = new JSeparator();
        this.projectFolderPanel = new JPanel();
        this.setFocusTraversalPolicy(null);
        this.projectNameLabel.setHorizontalAlignment(2);
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_ProjectName"));
        this.projectNameLabel.setVerticalAlignment(1);
        this.sourcesLabel.setLabelFor(this.localServerComboBox);
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_Sources"));
        this.sourcesLabel.setVerticalAlignment(1);
        this.localServerComboBox.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.localServerButton, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_LocalServerBrowse"));
        Mnemonics.setLocalizedText((JLabel)this.localServerInfoLabel, (String)"dummy");
        this.localServerInfoLabel.setEnabled(false);
        this.encodingLabel.setLabelFor(this.encodingComboBox);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"LBL_Encoding"));
        this.projectFolderPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.sourcesLabel).add((Component)this.encodingLabel)).add(24, 24, 24).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameTextField, -1, 297, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.localServerComboBox, 0, 202, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.localServerButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.localServerInfoLabel).addContainerGap()).add((Component)this.encodingComboBox, 0, 297, Short.MAX_VALUE))).add((Component)this.separator, -1, 431, Short.MAX_VALUE).add((Component)this.projectFolderPanel, -1, 431, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameTextField, -2, -1, -2).add((Component)this.projectNameLabel)).add(7, 7, 7).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.localServerComboBox, -2, -1, -2).add((Component)this.localServerButton).add((Component)this.sourcesLabel)).addPreferredGap(0).add((Component)this.localServerInfoLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.encodingComboBox, -2, -1, -2).add((Component)this.encodingLabel)).addPreferredGap(1).add((Component)this.separator, -2, 2, -2).addPreferredGap(1).add((Component)this.projectFolderPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectNameLabel.AccessibleContext.accessibleName"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectNameLabel.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.sourcesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.sourcesLabel.AccessibleContext.accessibleName"));
        this.sourcesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.sourcesLabel.AccessibleContext.accessibleDescription"));
        this.localServerComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerComboBox.AccessibleContext.accessibleName"));
        this.localServerComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerComboBox.AccessibleContext.accessibleDescription"));
        this.localServerButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerButton.AccessibleContext.accessibleName"));
        this.localServerButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerButton.AccessibleContext.accessibleDescription"));
        this.localServerInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerInfoLabel.AccessibleContext.accessibleName"));
        this.localServerInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.localServerInfoLabel.AccessibleContext.accessibleDescription"));
        this.encodingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.encodingLabel.AccessibleContext.accessibleName"));
        this.encodingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.encodingLabel.AccessibleContext.accessibleDescription"));
        this.encodingComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.encodingComboBox.AccessibleContext.accessibleName"));
        this.encodingComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.encodingComboBox.AccessibleContext.accessibleDescription"));
        this.separator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.separator.AccessibleContext.accessibleName"));
        this.separator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.separator.AccessibleContext.accessibleDescription"));
        this.projectFolderPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectFolderPanel.AccessibleContext.accessibleName"));
        this.projectFolderPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.projectFolderPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureNewProjectPanelVisual.class, (String)"ConfigureNewProjectPanelVisual.AccessibleContext.accessibleDescription"));
    }

    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    public void setProjectName(String string) {
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
    }

    public LocalServer getSourcesLocation() {
        return this.localServerComponent.getLocalServer();
    }

    public MutableComboBoxModel getLocalServerModel() {
        return this.localServerComponent.getLocalServerModel();
    }

    public void setLocalServerModel(MutableComboBoxModel mutableComboBoxModel) {
        this.localServerComponent.setLocalServerModel(mutableComboBoxModel);
    }

    public void selectSourcesLocation(LocalServer localServer) {
        this.localServerComponent.selectLocalServer(localServer);
    }

    public Charset getEncoding() {
        return (Charset)this.encodingComboBox.getSelectedItem();
    }

    public void setEncoding(Charset charset) {
        this.encodingComboBox.setSelectedItem(charset);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        String string = this.localServerComponent.getLocalServer().getHint();
        this.localServerInfoLabel.setText(string);
        super.stateChanged(changeEvent);
    }

    private static class BrowseSources
    implements LocalServerController.BrowseHandler {
        private BrowseSources() {
        }

        public File getCurrentDirectory() {
            return LastUsedFolders.getSources();
        }

        public void locationChanged(File file) {
            LastUsedFolders.setSources(file);
        }
    }
}

