/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.classpath.GlobalIncludePathSupport;
import org.netbeans.modules.php.project.ui.IncludePathUiSupport;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.options.SelectPhpInterpreterPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class PhpOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1092136352492432078L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton addFolderButton;
    private JButton browseButton;
    private JLabel commandLineLabel;
    private JSeparator commandLineSeparator;
    private JLabel debuggerPortLabel;
    private JTextField debuggerPortTextField;
    private JLabel debuggingLabel;
    private JSeparator debuggingSeparator;
    private JCheckBox editorCheckBox;
    private JLabel errorLabel;
    private JLabel globalIncludePathLabel;
    private JSeparator globalIncludePathSeparator;
    private JList includePathList;
    private JScrollPane includePathScrollPane;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JLabel openResultInLabel;
    private JCheckBox outputWindowCheckBox;
    private JLabel phpInterpreterLabel;
    private JTextField phpInterpreterTextField;
    private JButton removeButton;
    private JButton searchButton;
    private JCheckBox stopAtTheFirstLineCheckBox;
    private JLabel useTheFollowingPathByDefaultLabel;
    private JCheckBox webBrowserCheckBox;

    public PhpOptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.initPhpGlobalIncludePath();
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.phpInterpreterTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.debuggerPortTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    private void initPhpGlobalIncludePath() {
        DefaultListModel defaultListModel = IncludePathUiSupport.createListModel(GlobalIncludePathSupport.getInstance().itemsIterator());
        this.includePathList.setModel(defaultListModel);
        this.includePathList.setCellRenderer(new IncludePathUiSupport.ClassPathListCellRenderer());
        IncludePathUiSupport.EditMediator.register(this.includePathList, this.addFolderButton.getModel(), this.removeButton.getModel(), this.moveUpButton.getModel(), this.moveDownButton.getModel());
    }

    public String getPhpInterpreter() {
        return this.phpInterpreterTextField.getText();
    }

    public void setPhpInterpreter(String string) {
        this.phpInterpreterTextField.setText(string);
    }

    public boolean isOpenResultInOutputWindow() {
        return this.outputWindowCheckBox.isSelected();
    }

    public void setOpenResultInOutputWindow(boolean bl) {
        this.outputWindowCheckBox.setSelected(bl);
    }

    public boolean isOpenResultInBrowser() {
        return this.webBrowserCheckBox.isSelected();
    }

    public void setOpenResultInBrowser(boolean bl) {
        this.webBrowserCheckBox.setSelected(bl);
    }

    public boolean isOpenResultInEditor() {
        return this.editorCheckBox.isSelected();
    }

    public void setOpenResultInEditor(boolean bl) {
        this.editorCheckBox.setSelected(bl);
    }

    public Integer getDebuggerPort() {
        Integer n = null;
        try {
            n = Integer.parseInt(this.debuggerPortTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public void setDebuggerPort(int n) {
        this.debuggerPortTextField.setText(String.valueOf(n));
    }

    public boolean isDebuggerStoppedAtTheFirstLine() {
        return this.stopAtTheFirstLineCheckBox.isSelected();
    }

    public void setDebuggerStoppedAtTheFirstLine(boolean bl) {
        this.stopAtTheFirstLineCheckBox.setSelected(bl);
    }

    public String getPhpGlobalIncludePath() {
        String[] stringArray = GlobalIncludePathSupport.getInstance().encodeToStrings(IncludePathUiSupport.getIterator((DefaultListModel)this.includePathList.getModel()));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public void setError(String string) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(string);
    }

    public void setWarning(String string) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(string);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.commandLineLabel = new JLabel();
        this.commandLineSeparator = new JSeparator();
        this.phpInterpreterLabel = new JLabel();
        this.phpInterpreterTextField = new JTextField();
        this.browseButton = new JButton();
        this.searchButton = new JButton();
        this.openResultInLabel = new JLabel();
        this.outputWindowCheckBox = new JCheckBox();
        this.webBrowserCheckBox = new JCheckBox();
        this.editorCheckBox = new JCheckBox();
        this.debuggingLabel = new JLabel();
        this.debuggingSeparator = new JSeparator();
        this.debuggerPortLabel = new JLabel();
        this.debuggerPortTextField = new JTextField();
        this.stopAtTheFirstLineCheckBox = new JCheckBox();
        this.globalIncludePathLabel = new JLabel();
        this.globalIncludePathSeparator = new JSeparator();
        this.includePathScrollPane = new JScrollPane();
        this.includePathList = new JList();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.useTheFollowingPathByDefaultLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return PhpOptionsPanel.this.phpInterpreterTextField;
            }

            public Component getFirstComponent(Container container) {
                return PhpOptionsPanel.this.phpInterpreterTextField;
            }

            public Component getLastComponent(Container container) {
                return PhpOptionsPanel.this.moveDownButton;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == PhpOptionsPanel.this.phpInterpreterTextField) {
                    return PhpOptionsPanel.this.browseButton;
                }
                if (component == PhpOptionsPanel.this.browseButton) {
                    return PhpOptionsPanel.this.searchButton;
                }
                if (component == PhpOptionsPanel.this.searchButton) {
                    return PhpOptionsPanel.this.outputWindowCheckBox;
                }
                if (component == PhpOptionsPanel.this.outputWindowCheckBox) {
                    return PhpOptionsPanel.this.webBrowserCheckBox;
                }
                if (component == PhpOptionsPanel.this.webBrowserCheckBox) {
                    return PhpOptionsPanel.this.editorCheckBox;
                }
                if (component == PhpOptionsPanel.this.editorCheckBox) {
                    return PhpOptionsPanel.this.debuggerPortTextField;
                }
                if (component == PhpOptionsPanel.this.stopAtTheFirstLineCheckBox) {
                    return PhpOptionsPanel.this.includePathList;
                }
                if (component == PhpOptionsPanel.this.debuggerPortTextField) {
                    return PhpOptionsPanel.this.stopAtTheFirstLineCheckBox;
                }
                if (component == PhpOptionsPanel.this.includePathList) {
                    return PhpOptionsPanel.this.addFolderButton;
                }
                if (component == PhpOptionsPanel.this.addFolderButton) {
                    return PhpOptionsPanel.this.removeButton;
                }
                if (component == PhpOptionsPanel.this.removeButton) {
                    return PhpOptionsPanel.this.moveUpButton;
                }
                if (component == PhpOptionsPanel.this.moveUpButton) {
                    return PhpOptionsPanel.this.moveDownButton;
                }
                return PhpOptionsPanel.this.phpInterpreterTextField;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == PhpOptionsPanel.this.browseButton) {
                    return PhpOptionsPanel.this.phpInterpreterTextField;
                }
                if (component == PhpOptionsPanel.this.searchButton) {
                    return PhpOptionsPanel.this.browseButton;
                }
                if (component == PhpOptionsPanel.this.outputWindowCheckBox) {
                    return PhpOptionsPanel.this.searchButton;
                }
                if (component == PhpOptionsPanel.this.webBrowserCheckBox) {
                    return PhpOptionsPanel.this.outputWindowCheckBox;
                }
                if (component == PhpOptionsPanel.this.editorCheckBox) {
                    return PhpOptionsPanel.this.webBrowserCheckBox;
                }
                if (component == PhpOptionsPanel.this.debuggerPortTextField) {
                    return PhpOptionsPanel.this.editorCheckBox;
                }
                if (component == PhpOptionsPanel.this.includePathList) {
                    return PhpOptionsPanel.this.stopAtTheFirstLineCheckBox;
                }
                if (component == PhpOptionsPanel.this.stopAtTheFirstLineCheckBox) {
                    return PhpOptionsPanel.this.debuggerPortTextField;
                }
                if (component == PhpOptionsPanel.this.addFolderButton) {
                    return PhpOptionsPanel.this.includePathList;
                }
                if (component == PhpOptionsPanel.this.removeButton) {
                    return PhpOptionsPanel.this.addFolderButton;
                }
                if (component == PhpOptionsPanel.this.moveUpButton) {
                    return PhpOptionsPanel.this.removeButton;
                }
                if (component == PhpOptionsPanel.this.moveDownButton) {
                    return PhpOptionsPanel.this.moveUpButton;
                }
                return PhpOptionsPanel.this.moveDownButton;
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.commandLineLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_CommandLine"));
        this.phpInterpreterLabel.setLabelFor(this.phpInterpreterTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpInterpreterLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_PhpInterpreter"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhpOptionsPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Search"));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhpOptionsPanel.this.searchButtonActionPerformed(actionEvent);
            }
        });
        this.openResultInLabel.setLabelFor(this.outputWindowCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.openResultInLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_OpenResultIn"));
        Mnemonics.setLocalizedText((AbstractButton)this.outputWindowCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_OutputWindow"));
        Mnemonics.setLocalizedText((AbstractButton)this.webBrowserCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_WebBrowser"));
        Mnemonics.setLocalizedText((AbstractButton)this.editorCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Editor"));
        Mnemonics.setLocalizedText((JLabel)this.debuggingLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Debugging"));
        this.debuggerPortLabel.setLabelFor(this.debuggerPortTextField);
        Mnemonics.setLocalizedText((JLabel)this.debuggerPortLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_DebuggerPort"));
        Mnemonics.setLocalizedText((AbstractButton)this.stopAtTheFirstLineCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_StopAtTheFirstLine"));
        Mnemonics.setLocalizedText((JLabel)this.globalIncludePathLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_GlobalIncludePath"));
        this.includePathScrollPane.setViewportView(this.includePathList);
        this.includePathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_AddFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_MoveDown"));
        this.useTheFollowingPathByDefaultLabel.setLabelFor(this.includePathList);
        Mnemonics.setLocalizedText((JLabel)this.useTheFollowingPathByDefaultLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_UseTheFollowingPathByDefault"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.phpInterpreterLabel).add((Component)this.openResultInLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.phpInterpreterTextField, -1, 121, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton).addPreferredGap(0).add((Component)this.searchButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.outputWindowCheckBox).addPreferredGap(0).add((Component)this.webBrowserCheckBox).addPreferredGap(0).add((Component)this.editorCheckBox)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.commandLineLabel).addPreferredGap(0).add((Component)this.commandLineSeparator, -1, 337, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.debuggingLabel).addPreferredGap(0).add((Component)this.debuggingSeparator, -1, 362, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.stopAtTheFirstLineCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.debuggerPortLabel).addPreferredGap(0).add((Component)this.debuggerPortTextField, -2, 101, -2)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.globalIncludePathLabel).addPreferredGap(0).add((Component)this.globalIncludePathSeparator, -1, 311, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.includePathScrollPane, -1, 314, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.addFolderButton).add((Component)this.removeButton).add((Component)this.moveUpButton).add((Component)this.moveDownButton))).add((Component)this.useTheFollowingPathByDefaultLabel))).add((Component)this.errorLabel)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addFolderButton, this.moveDownButton, this.moveUpButton, this.removeButton}, 1);
        groupLayout.linkSize(new Component[]{this.browseButton, this.searchButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.commandLineLabel).add((Component)this.commandLineSeparator, -2, 10, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.phpInterpreterTextField, -2, -1, -2).add((Component)this.searchButton).add((Component)this.phpInterpreterLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.outputWindowCheckBox).add((Component)this.webBrowserCheckBox).add((Component)this.editorCheckBox).add((Component)this.openResultInLabel)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.debuggingLabel).add((Component)this.debuggingSeparator, -2, 10, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.debuggerPortLabel).add((Component)this.debuggerPortTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.stopAtTheFirstLineCheckBox).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.globalIncludePathLabel).add((Component)this.globalIncludePathSeparator, -2, 10, -2)).addPreferredGap(0).add((Component)this.useTheFollowingPathByDefaultLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.includePathScrollPane, -1, 142, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addFolderButton).addPreferredGap(0).add((Component)this.removeButton).addPreferredGap(0).add((Component)this.moveUpButton).addPreferredGap(0).add((Component)this.moveDownButton))).addPreferredGap(0).add((Component)this.errorLabel).addContainerGap()));
        this.commandLineLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineLabel.AccessibleContext.accessibleName"));
        this.commandLineLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineLabel.AccessibleContext.accessibleDescription"));
        this.commandLineSeparator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineSeparator.AccessibleContext.accessibleName"));
        this.commandLineSeparator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineSeparator.AccessibleContext.accessibleDescription"));
        this.phpInterpreterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterLabel.AccessibleContext.accessibleName"));
        this.phpInterpreterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterLabel.AccessibleContext.accessibleDescription"));
        this.phpInterpreterTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterTextField.AccessibleContext.accessibleName"));
        this.phpInterpreterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterTextField.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.browseButton.AccessibleContext.accessibleName"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.browseButton.AccessibleContext.accessibleDescription"));
        this.searchButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.searchButton.AccessibleContext.accessibleName"));
        this.searchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.searchButton.AccessibleContext.accessibleDescription"));
        this.openResultInLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.openResultInLabel.AccessibleContext.accessibleName"));
        this.openResultInLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.openResultInLabel.AccessibleContext.accessibleDescription"));
        this.outputWindowCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.outputWindowCheckBox.AccessibleContext.accessibleName"));
        this.outputWindowCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.outputWindowCheckBox.AccessibleContext.accessibleDescription"));
        this.webBrowserCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.webBrowserCheckBox.AccessibleContext.accessibleName"));
        this.webBrowserCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.webBrowserCheckBox.AccessibleContext.accessibleDescription"));
        this.editorCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.editorCheckBox.AccessibleContext.accessibleName"));
        this.editorCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.editorCheckBox.AccessibleContext.accessibleDescription"));
        this.debuggingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggingLabel.AccessibleContext.accessibleName"));
        this.debuggingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggingLabel.AccessibleContext.accessibleDescription"));
        this.debuggingSeparator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggingSeparator.AccessibleContext.accessibleName"));
        this.debuggingSeparator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggingSeparator.AccessibleContext.accessibleDescription"));
        this.debuggerPortLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerPortLabel.AccessibleContext.accessibleName"));
        this.debuggerPortLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerPortLabel.AccessibleContext.accessibleDescription"));
        this.debuggerPortTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerPortTextField.AccessibleContext.accessibleName"));
        this.debuggerPortTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.debuggerPortTextField.AccessibleContext.accessibleDescription"));
        this.stopAtTheFirstLineCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.stopAtTheFirstLineCheckBox.AccessibleContext.accessibleName"));
        this.stopAtTheFirstLineCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.stopAtTheFirstLineCheckBox.AccessibleContext.accessibleDescription"));
        this.globalIncludePathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathLabel.AccessibleContext.accessibleName"));
        this.globalIncludePathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathLabel.AccessibleContext.accessibleDescription"));
        this.globalIncludePathSeparator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathSeparator.AccessibleContext.accessibleName"));
        this.globalIncludePathSeparator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathSeparator.AccessibleContext.accessibleDescription"));
        this.includePathScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathScrollPane.AccessibleContext.accessibleName"));
        this.includePathScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathScrollPane.AccessibleContext.accessibleDescription"));
        this.addFolderButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.addFolderButton.AccessibleContext.accessibleName"));
        this.addFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.addFolderButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.removeButton.AccessibleContext.accessibleName"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.removeButton.AccessibleContext.accessibleDescription"));
        this.moveUpButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveUpButton.AccessibleContext.accessibleName"));
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveUpButton.AccessibleContext.accessibleDescription"));
        this.moveDownButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveDownButton.AccessibleContext.accessibleName"));
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveDownButton.AccessibleContext.accessibleDescription"));
        this.useTheFollowingPathByDefaultLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.useTheFollowingPathByDefaultLabel.AccessibleContext.accessibleName"));
        this.useTheFollowingPathByDefaultLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.useTheFollowingPathByDefaultLabel.AccessibleContext.accessibleDescription"));
        this.errorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.errorLabel.AccessibleContext.accessibleName"));
        this.errorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.errorLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browsePhpInterpreter(this, this.phpInterpreterTextField);
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        SelectPhpInterpreterPanel selectPhpInterpreterPanel = new SelectPhpInterpreterPanel();
        if (selectPhpInterpreterPanel.open() && selectPhpInterpreterPanel.getSelectedPhpInterpreter() != null) {
            this.phpInterpreterTextField.setText(selectPhpInterpreterPanel.getSelectedPhpInterpreter());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        private void processUpdate() {
            PhpOptionsPanel.this.fireChange();
        }
    }
}

