/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class PhpLogicalViewProvider
implements LogicalViewProvider {
    private static final Logger LOGGER = Logger.getLogger(PhpLogicalViewProvider.class.getName());
    final PhpProject project;

    public PhpLogicalViewProvider(PhpProject phpProject) {
        assert (phpProject != null);
        this.project = phpProject;
    }

    public Node createLogicalView() {
        return new PhpLogicalViewRootNode(this.project);
    }

    public Node findPath(Node node, Object object) {
        Node[] nodeArray;
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        for (Node node2 : nodeArray = node.getChildren().getNodes(true)) {
            DataObject dataObject;
            if (!(object instanceof DataObject) && !(object instanceof FileObject) || (dataObject = (DataObject)node2.getLookup().lookup(DataObject.class)) == null) continue;
            FileObject fileObject = dataObject.getPrimaryFile();
            FileObject fileObject2 = null;
            fileObject2 = object instanceof DataObject ? ((DataObject)object).getPrimaryFile() : (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject2);
            if (!project.equals(project2)) {
                return null;
            }
            if (fileObject == fileObject2) {
                return node2;
            }
            if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) continue;
            String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            String[] stringArray = string.split("/");
            stringArray[stringArray.length - 1] = fileObject2.getName();
            Node node3 = this.findNode(node2, stringArray);
            if (node3 == null) {
                stringArray[stringArray.length - 1] = fileObject2.getNameExt();
                node3 = this.findNode(node2, stringArray);
            }
            if (node3 == null) {
                return null;
            }
            if (this.hasObject(node3, object)) {
                return node3;
            }
            Node node4 = node3.getParentNode();
            Children children = node4.getChildren();
            for (Node node5 : nodeArray = children.getNodes()) {
                if (!this.hasObject(node5, object)) continue;
                return node5;
            }
        }
        return null;
    }

    private Node findNode(Node node, String[] stringArray) {
        Node node2 = null;
        try {
            node2 = NodeOp.findPath((Node)node, (String[])stringArray);
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        return node2;
    }

    private boolean hasObject(Node node, Object object) {
        if (object == null) {
            return false;
        }
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        if (object instanceof DataObject) {
            if (dataObject.equals(object)) {
                return true;
            }
            FileObject fileObject = ((DataObject)object).getPrimaryFile();
            return this.hasObject(node, fileObject);
        }
        if (object instanceof FileObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return object.equals(fileObject);
        }
        return false;
    }

    private static class PhpLogicalViewRootNode
    extends AbstractNode {
        PhpProject project;

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory());
            return NbBundle.getMessage(PhpLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }

        public Action[] getActions(boolean bl) {
            PhpActionProvider phpActionProvider = (PhpActionProvider)this.project.getLookup().lookup(PhpActionProvider.class);
            assert (phpActionProvider != null);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(phpActionProvider.getAction("run"));
            arrayList.add(phpActionProvider.getAction("debug"));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setProjectConfigurationAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            arrayList.add(null);
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(PhpLogicalViewProvider.class);
        }

        public PhpLogicalViewRootNode(PhpProject phpProject) {
            super(PhpLogicalViewRootNode.createChildren(phpProject), Lookups.singleton((Object)phpProject));
            this.project = phpProject;
            this.setIconBaseWithExtension("org/netbeans/modules/php/project/ui/resources/phpProject.png");
            this.setName(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        }

        private static Children createChildren(PhpProject phpProject) {
            return NodeFactorySupport.createCompositeChildren((Project)phpProject, (String)"Projects/org-netbeans-modules-php-project/Nodes");
        }
    }
}

