/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.util.NbBundle;

public final class RunAsValidator {
    private static final String INVALID_SEPARATOR = "\\";

    private RunAsValidator() {
    }

    public static String validateWebFields(String string, File file, String string2, String string3) {
        String string4 = null;
        string4 = !Utils.isValidUrl(string) ? NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUrl") : (!string.endsWith("/") ? NbBundle.getMessage(RunAsValidator.class, (String)"MSG_UrlNotTrailingSlash") : RunAsValidator.validateIndexFile(file, string2, string3));
        return string4;
    }

    public static String validateScriptFields(String string, File file, String string2, String string3) {
        String string4 = Utils.validatePhpInterpreter(string);
        if (string4 != null) {
            return string4;
        }
        return RunAsValidator.validateIndexFile(file, string2, string3);
    }

    public static String validateUploadDirectory(String string, boolean bl) {
        assert (string != null);
        if (bl && string.length() == 0) {
            return null;
        }
        if (!string.startsWith("/")) {
            return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUploadDirectoryStart", (Object)"/");
        }
        if (string.length() > 1 && string.endsWith("/")) {
            return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUploadDirectoryEnd", (Object)"/");
        }
        if (string.contains(INVALID_SEPARATOR)) {
            return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUploadDirectoryContent", (Object)INVALID_SEPARATOR);
        }
        return null;
    }

    private static String validateIndexFile(File file, String string, String string2) {
        assert (file != null);
        if (string != null) {
            if (string.trim().length() == 0) {
                return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_NoIndexFile");
            }
            File file2 = new File(file, string.replace('/', File.separatorChar));
            if (!file2.isFile()) {
                return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_IndexFileInvalid");
            }
        }
        return null;
    }

    public static String composeUrlHint(String string, String string2, String string3) throws InvalidUrlException {
        URL uRL = null;
        try {
            if (string != null && string.trim().length() > 0) {
                uRL = new URL(string);
            }
            if (uRL != null && string2 != null && string2.trim().length() > 0) {
                uRL = new URL(uRL, string2);
            }
            if (uRL != null && string3 != null && string3.trim().length() > 0) {
                uRL = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), string3, uRL.getRef()).toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidUrlException(NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUrl"));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidUrlException(NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUrl"));
        }
        return uRL != null ? uRL.toExternalForm() : "";
    }

    public static String composeUploadDirectoryHint(String string, String string2, String string3) {
        String string4 = string2 + string3;
        return "ftp://" + string + string4.replaceAll("/{2,}", "/");
    }

    public static final class InvalidUrlException
    extends Exception {
        private static final long serialVersionUID = 1234514014505423742L;

        public InvalidUrlException(String string) {
            super(string);
        }
    }
}

